#include "bsp.h"
#include "stdio.h"
#include "lib_gpio.h"
#include "lib_uart.h"
#include "lib_scs.h"

//PA14
void LED_init()
{
    SCU->PROT.Word = 0X55AA6996;
    SCU->PCLKEN0.GPIO_EN = 1;

    GPIO->PADIR.DIR_14 = 0;
}

void LED_toggle()
{
    GPIO->PADATABRR.Word = 1U << 14;
}

void UARTInit(void)
{
    GPIO_InitStruType y;
    UART_InitStruType uart;

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_2;
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_PUEN = GPIO_PUE_Input_Disable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Strong;
    GPIO_Init(GPIOA, GPIO_Pin_15, &y);               //PA15---TxD

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_2;
    y.GPIO_Direction = GPIO_Dir_In;
    y.GPIO_PUEN = GPIO_PUE_Input_Enable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Strong;
    GPIO_Init(GPIOA, GPIO_Pin_16, &y);               //PA16---RxD

    uart.UART_StopBits = UART_StopBits_1;          //ֹͣλ1
    uart.UART_TxMode = UART_DataMode_8;            //ݸʽ8λ
    uart.UART_TxPolar = UART_Polar_Normal;         //Ͷ˿ڼԣ
    uart.UART_RxMode = UART_DataMode_8;            //ݸʽ8λ
    uart.UART_RxPolar = UART_Polar_Normal;         //ն˿ڼԣ
    uart.UART_BaudRate = 115200;                   //
    uart.UART_ClockSet = UART_Clock_1;             //ʱѡPclk
    UART_Init(UART2, &uart);

    UART_TBIMConfig(UART2, UART_TRBIM_Byte);
    UART_RBIMConfig(UART2, UART_TRBIM_Byte);
    UART_ITConfig(UART2, UART_IT_RB, ENABLE);
    NVIC_Init(NVIC_UART2_IRQn, NVIC_Priority_1, ENABLE);
    UART2_TxEnable();                               //UART2ʹ
    UART2_RxEnable();
}

void UART_SendString(char *ptr)
{
    while (*ptr)
    {
        UART_SendByte(UART2, *ptr++);

        while (UART_GetFlagStatus(UART2, UART_FLAG_TB) == RESET);
    }
}

int fputc(int c, FILE *f)
{
    while (UART_GetFlagStatus(UART2, UART_FLAG_TB) == RESET);

    UART_SendByte(UART2, (char)c);
    return c;
}
