/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Jiayc
*  :  V1.00
*  :  2020/8/24
*  :  FreeRTOS_Mutexesʾ
          MCUES8P5088
          FreeRTOS汾v10.2.1
          ֵźUARTжзͶֵź
          ӲܽţLED:PA14  UART_TX:PA15 UART_RX:PA16
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "ES8P508x.h"
#include "bsp.h"
#include "lib_uart.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"

SemaphoreHandle_t Semaphore = NULL;

static void vLED_Task(void *pvParameters);
static void vSemaphoreTake_Task(void *pvParameters);


int main()
{
    LED_init();
    UARTInit();

    Semaphore = xSemaphoreCreateBinary();   //ֵź

    taskENTER_CRITICAL();                   //ٽ籣

    xTaskCreate(vLED_Task,                  //
                "LED",
                128,
                NULL,
                5,
                NULL);

    xTaskCreate(vSemaphoreTake_Task,
                "SemaphoreTake",
                128,
                NULL,
                3,
                NULL);

    taskEXIT_CRITICAL();                    //˳ٽ籣

    vTaskStartScheduler();                  //ʼ

    for (;;)
    {

    }
}

static void vLED_Task(void *pvParameters)
{
    for (;;)
    {
        GPIO->PADATABRR.Word = 1U << 14;
        vTaskDelay(500);
    }
}

static void vSemaphoreTake_Task(void *pvParameters)
{
    for (;;)
    {
        if (xSemaphoreTake(Semaphore, portMAX_DELAY) == pdTRUE) //նֵź
        {
            UART_SendString("SemaphoreTake_Task takes semaphore.\r\n");
            UART_SendString("\r\n");
        }
    }
}

void UART2_IRQHandler()
{
    uint8_t c;
    static BaseType_t xHigherPriorityTaskWoken;
    xHigherPriorityTaskWoken = pdFALSE;

    if (UART_GetITStatus(UART2, UART_IT_RB))
    {
        c = UART_RecByte(UART2);

        if (c == 0x55)              //ڽյ0x55Ͷֵź
        {
            xSemaphoreGiveFromISR(Semaphore, &xHigherPriorityTaskWoken);
        }
    }
}

