/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Jiayc
*  :  V1.00
*  :  2020/8/24
*  :  FreeRTOS_Mutexesʾ
          MCUES8P5088
          FreeRTOS汾v10.2.1
          ֵźŷͽ
          ӲܽţLED:PA14  UART_TX:PA15 UART_RX:PA16
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "ES8P508x.h"
#include "bsp.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"

SemaphoreHandle_t Semaphore = NULL;

static void vLED_Task(void *pvParameters);
static void vSemaphoreTake_Task(void *pvParameters);
static void vSemaphoreGive_Task(void *pvParameters);


int main()
{
    LED_init();
    UARTInit();

    Semaphore = xSemaphoreCreateBinary();       //ֵź

    taskENTER_CRITICAL();                       //ٽ籣

    xTaskCreate(vLED_Task,                      //
                "LED",
                128,
                NULL,
                5,
                NULL);

    xTaskCreate(vSemaphoreTake_Task,
                "SemaphoreTake",
                128,
                NULL,
                3,
                NULL);
    xTaskCreate(vSemaphoreGive_Task,
                "SemaphoreGive",
                128,
                NULL,
                4,
                NULL);

    taskEXIT_CRITICAL();                        //˳ٽ籣

    vTaskStartScheduler();                      //ʼ

    for (;;)
    {

    }
}

static void vLED_Task(void *pvParameters)
{
    for (;;)
    {
        GPIO->PADATABRR.Word = 1U << 14;
        vTaskDelay(500);
    }
}

static void vSemaphoreTake_Task(void *pvParameters)
{
    for (;;)
    {
        if (xSemaphoreTake(Semaphore, portMAX_DELAY) == pdTRUE)     //նֵź
        {
            UART_SendString("SemaphoreTake_Task takes semaphore.\r\n");
            UART_SendString("\r\n");
        }
    }
}

static void vSemaphoreGive_Task(void *pvParameters)
{
    for (;;)
    {
        xSemaphoreGive(Semaphore);                                  //Ͷֵź
        UART_SendString("SemaphoreGive_Task gives semaphore.\r\n");
        vTaskDelay(1000);
    }
}

