/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Jiayc
*  :  V1.00
*  :  2020/8/24
*  :  FreeRTOS_Mutexesʾ
          MCUES8P5088
          FreeRTOS汾v10.2.1
          зͽʵϢ
          ӲܽţLED:PA14  UART_TX:PA15 UART_RX:PA16
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "ES8P508x.h"
#include "stdio.h"
#include "bsp.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"

QueueHandle_t MessageQueue;

static void vLED_Task(void *pvParameters);
static void vMessageQueuesProduce_Task(void *pvParameters);
static void vMessageQueuesConsume_Task(void *pvParameters);


int main()
{
    LED_init();
    UARTInit();

    MessageQueue = xQueueCreate(1, sizeof(char *));     //Ϣ

    taskENTER_CRITICAL();                               //ٽ籣

    xTaskCreate(vLED_Task,                              //
                "LED",
                128,
                NULL,
                5,
                NULL);

    xTaskCreate(vMessageQueuesProduce_Task,
                "MessageQueuesProduce",
                128,
                NULL,
                3,
                NULL);
    xTaskCreate(vMessageQueuesConsume_Task,
                "MessageQueuesConsume",
                128,
                NULL,
                4,
                NULL);

    taskEXIT_CRITICAL();                                //˳ٽ籣

    vTaskStartScheduler();                              //ʼ

    for (;;)
    {

    }
}

static void vLED_Task(void *pvParameters)
{

    for (;;)
    {
        GPIO->PADATABRR.Word = 1U << 14;
        vTaskDelay(500);
    }
}

static void vMessageQueuesProduce_Task(void *pvParameters)
{
    for (;;)
    {
        char *ptr = "Hello world!";
        printf("MessageQueuesProduce_Task sends message.\r\n");
        xQueueSend(MessageQueue, &ptr, 0);                          //Ϣ
        vTaskDelay(1000);
    }
}

static void vMessageQueuesConsume_Task(void *pvParameters)
{
    char *ptr;

    for (;;)
    {
        if (xQueueReceive(MessageQueue, &ptr, portMAX_DELAY) == pdPASS) //Ϣ
        {
            printf("MessageQueuesConsume_Task receives message, the message is: %s\r\n\r\n", ptr);
        }
    }
}

