/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Jiayc
*  :  V1.00
*  :  2020/8/24
*  :  FreeRTOS_NotifyFromISRʾ
          MCUES8P5088
          ֪ͨڴж֪֪ͨͨźš
          ӲܽţLED:PA14  UART_TX:PA15 UART_RX:PA16
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "ES8P508x.h"
#include "bsp.h"
#include "lib_uart.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"


static void vLED_Task(void *pvParameters);
static void vNotifyTake_Task(void *pvParameters);

TaskHandle_t NotifyTake_Handler;

int main()
{
    LED_init();
    UARTInit();

    taskENTER_CRITICAL();                   //ٽ籣

    xTaskCreate(vLED_Task,                  //
                "LED",
                128,
                NULL,
                5,
                NULL);

    xTaskCreate(vNotifyTake_Task,
                "NotifyTake",
                128,
                NULL,
                3,
                &NotifyTake_Handler);

    taskEXIT_CRITICAL();                    //˳ٽ籣

    vTaskStartScheduler();                  //ʼ

    for (;;)
    {

    }
}

static void vLED_Task(void *pvParameters)
{
    for (;;)
    {
        GPIO->PADATABRR.Word = 1U << 14;
        vTaskDelay(500);
    }
}

static void vNotifyTake_Task(void *pvParameters)
{
    for (;;)
    {
        if (ulTaskNotifyTake(pdTRUE, 0) == pdTRUE)              //֪ͨź
        {
            UART_SendString("NotifyTake_Task takes notify.\r\n");
            UART_SendString("\r\n");
        }
    }
}

void UART2_IRQHandler()
{
    volatile uint8_t c;
    static BaseType_t xHigherPriorityTaskWoken;
    xHigherPriorityTaskWoken = pdFALSE;

    if (UART_GetITStatus(UART2, UART_IT_RB))
    {
        c = UART_RecByte(UART2);

        if (c == 0x55)                          //յ0x55ʱvNotifyTake_Task֪ͨź
        {
            vTaskNotifyGiveFromISR(NotifyTake_Handler, &xHigherPriorityTaskWoken);
        }
    }
}

