/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Jiayc
*  :  V1.00
*  :  2020/8/24
*  :  FreeRTOS_Notifyʾ
          MCUES8P5088
          FreeRTOS汾v10.2.1
          ֱ𴴽֪ͨźŷͺͽģֵźʵͬ
          ӲܽţLED:PA14  UART_TX:PA15 UART_RX:PA16
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "ES8P508x.h"
#include "bsp.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"


static void vLED_Task(void *pvParameters);
static void vNotifyTake_Task(void *pvParameters);
static void vNotifyGive_Task(void *pvParameters);

TaskHandle_t NotifyTake_Handler;
TaskHandle_t NotifyGive_Handler;

int main()
{
    LED_init();
    UARTInit();

    taskENTER_CRITICAL();                   //ٽ籣

    xTaskCreate(vLED_Task,                  //
                "LED",
                128,
                NULL,
                5,
                NULL);

    xTaskCreate(vNotifyTake_Task,
                "NotifyTake",
                128,
                NULL,
                3,
                &NotifyTake_Handler);
    xTaskCreate(vNotifyGive_Task,
                "NotifyGive",
                128,
                NULL,
                4,
                &NotifyGive_Handler);

    taskEXIT_CRITICAL();                    //˳ٽ籣

    vTaskStartScheduler();                  //ʼ

    for (;;)
    {

    }
}

static void vLED_Task(void *pvParameters)
{
    for (;;)
    {
        GPIO->PADATABRR.Word = 1U << 14;
        vTaskDelay(500);
    }
}

static void vNotifyTake_Task(void *pvParameters)
{
    for (;;)
    {
        if (ulTaskNotifyTake(pdTRUE, portMAX_DELAY) == pdTRUE)  //ȡ֪ͨź
        {
            UART_SendString("NotifyTake_Task takes notify.\r\n");
            UART_SendString("\r\n");
        }
    }
}

static void vNotifyGive_Task(void *pvParameters)
{
    for (;;)
    {
        xTaskNotifyGive(NotifyTake_Handler);                    //֪ͨź
        UART_SendString("NotifyGive_Task gives notify.\r\n");
        vTaskDelay(1000);
    }
}

