/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Jiayc
*  :  V1.00
*  :  2020/8/24
*  :  FreeRTOS_Mutexesʾ
          MCUES8P5088
          FreeRTOS汾v10.2.1
          ȼ񣬸ȼȼԼȼ
          ȼ͵ȼ
          ʹûȼʱȼߵȼһ£ȼܴ
          ȼ
          ӲܽţLED:PA14  UART_TX:PA15 UART_RX:PA16
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "ES8P508x.h"
#include "stdio.h"
#include "bsp.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"

SemaphoreHandle_t MultexSemaphore = NULL;

static void vMutexHighPriority_Task(void *pvParameters);
static void vMutexMediumPriority_Task(void *pvParameters);
static void vMutexLowPriority_Task(void *pvParameters);


int main()
{
    LED_init();
    UARTInit();

    MultexSemaphore = xSemaphoreCreateMutex();  //

    taskENTER_CRITICAL();                       //ٽ籣

    xTaskCreate(vMutexHighPriority_Task,        //
                "MutexHighPriority",
                configMINIMAL_STACK_SIZE,
                NULL,
                5,
                NULL);
    xTaskCreate(vMutexMediumPriority_Task,
                "MutexMediumPriority",
                configMINIMAL_STACK_SIZE,
                NULL,
                4,
                NULL);
    xTaskCreate(vMutexLowPriority_Task,
                "MutexLowPriority",
                configMINIMAL_STACK_SIZE,
                NULL,
                3,
                NULL);

    taskEXIT_CRITICAL();                        //˳ٽ籣

    vTaskStartScheduler();                      //ʼ

    for (;;)
    {

    }
}

static void vMutexHighPriority_Task(void *pvParameters)
{
    for (;;)
    {
        if (xSemaphoreTake(MultexSemaphore, portMAX_DELAY) == pdTRUE)       //ȡ
        {
            printf("MutexHighPriority_Task takes multex semaphore.\r\n");
            xSemaphoreGive(MultexSemaphore);                                //ͷŻ
        }

        vTaskDelay(1000);
    }
}

void vMutexMediumPriority_Task(void *pvParameters)
{
    for (;;)
    {
        GPIO->PADATABRR.Word = 1U << 14;
        printf("MutexMediumPriority_Task is running.\r\n");
        vTaskDelay(1000);
    }
}

static void vMutexLowPriority_Task(void *pvParameters)
{
    for (;;)
    {
        if (xSemaphoreTake(MultexSemaphore, portMAX_DELAY) == pdTRUE)
        {
            uint32_t i;
            printf("MutexLowPriority_Task takes multex semaphore.\r\n\r\n");

            for (i = 0; i < 100000; i++)        //ģȼʱռCPU
            {
                taskYIELD();                    //
            }

            xSemaphoreGive(MultexSemaphore);    //ͷź
        }

        vTaskDelay(1000);
    }
}

