/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Liut
*  :  V1.00
*  :  2017/06/25
*  :  SPI EEPROM Demo
          :
          ------------------------
          SPI EEPROM:
          ------------------------
          NSS - PA27,
          SCK - PA26,
          MISO - PA25,
          MOSI - PA24
          ------------------------
          UART:
          ------------------------
          TXD - PA15
          RXD - PA16
          ------------------------
                    ʹõⲿFlashͺΪ93AA46AֱͨÿHRSDK-GMB-01
                    ʹES-BridgeUARTմӡݡ
*  ע:  HRSDK-GDB-ES8P508x V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"

int main(void)
{
    uint8_t w_buffer[1] = {0xCD};
    uint8_t r_buffer[1] = {0x0};

    PLLClock_Config(ENABLE, SCU_PLL_HRC, SCU_PLL_48M, ENABLE);    /* PLLƵ48MHz */
    SystemCoreClock = 48000000;
    SystemInit();
    DeviceClockAllEnable();
    SysTickInit();

    E2rom_init();

    E2romEraseAll();
    E2romWriteData(0x00, w_buffer[0]);
    printf("E2ROM writeten finished, content: %d\n\r", w_buffer[0]);

    E2romReadData(0x00, r_buffer);
    printf("Content readout from E2ROM: %d\n\r\n\r", r_buffer[0]);

    while (1)
    {
    }
}
