/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  spi.h
*  :  Liut
*  :  V1.00
*  :  2017/06/26
*  :  SPIģ
*  ע:  HRSDK-GDB-ES8P508x V1.1
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "spi.h"

#define ISR 1

uint8_t g_wbuf[20];
uint8_t g_rbuf[20];
uint8_t g_rbufamount;
uint8_t g_wbufamount;

/*********************************************************
: void SPI_GPIO_Init(void)
  : SPI_GPIOʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void SPI_GPIO_Init(void)
{
    GPIO_InitStruType x;
    SPI_InitStruType y;

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_OD = GPIO_ODE_Output_Disable;
    x.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, SCK_PIN, &x);      //PA26-SCK,PA27-NSS,PA24-SDO-MOSI   FUN3
    GPIO_Init(GPIOA, SDO_PIN, &x);

    x.GPIO_Func = GPIO_Func_0;
    GPIO_Init(GPIOA, CS_PIN, &x);       //GPIO˿ڳʼ

    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_In;
    GPIO_Init(GPIOA, SDI_PIN, &x);

    y.SPI_Freq = 10000;
    y.SPI_Df = SPI_RiseSendFallRec;
    y.SPI_Mode = SPI_Mode_Master;
    y.SPI_DW = 7;
    y.SPI_DelayRec = ENABLE;            //ʱʹ
    y.SPI_DelaySend = DISABLE;
    y.SPI_SendDelayPeroid = 0x3F;
    SPI_Init(&y);                       //SPIʼ

    CS_SET;
    SPI_RecEnable();
    SPI_RBIMConfig(SPI_IType_BYTE);
    SPI_TBIMConfig(SPI_IType_BYTE);
    NVIC_Init(NVIC_SPI0_IRQn, NVIC_Priority_0, ENABLE);
    SPI_Enable();
}

/*********************************************************
: SPIReadData(uint8_t *rbuf, uint8_t n)
  : SPIݣֽڶ(ѯģʽ)
ֵ: nݸ
ֵ: rbufݻ
ֵ: 
**********************************************************/
void SPIReadData(uint8_t *rbuf, uint8_t n)
{
    uint8_t i;

    /* սջ */
    rbufIndex = 0x0U;
    g_rbufamount = n;
    SPI_TX_CLR();
    SPI_RX_CLR();

#if ISR
    SPI_ITConfig(SPI_IT_TB, DISABLE);
    SPI_ITConfig(SPI_IT_RB, ENABLE);
#endif

    /* Ƭѡ */
    CS_RESET;

    for (i = 0; i < n; i++)
    {
        while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

        SPI_SendByte(0x3F);

#if ISR
#else

        while ((SPI_GetFlagStatus(SPI_Flag_RB) == RESET));

        g_rbuf[i] = SPI_RecByte();
#endif
    }

#if ISR

    while (rbufIndex < n)
    {
        ;
    }

#endif

    CS_SET;

    memcpy(rbuf, g_rbuf, n);

    return;
}

/*********************************************************
: SPIWriteData(uint8_t *wbuf, uint8_t n)
  : SPIдݣֽڶ(ѯģʽ)
ֵ: wbuf͵
        nݸ
ֵ: 
ֵ: 
**********************************************************/
void SPIWriteData(uint8_t *wbuf, uint8_t n)
{
#if ISR
#else
    uint8_t i;
#endif

    /* շͻ */
    wbufIndex = 0x0U;
    g_wbufamount = n;
    memcpy(g_wbuf, wbuf, n);
    SPI_TX_CLR();

    /* Ƭѡ */
    CS_RESET;

#if ISR
    SPI_ITConfig(SPI_IT_TB, ENABLE);
    SPI_ITConfig(SPI_IT_RB, DISABLE);
#endif

#if ISR
#else

    for (i = 0; i < n; i++)
    {
        SPI_SendByte(wbuf[i]);

        while ((SPI_GetFlagStatus(SPI_Flag_TB) == RESET) || SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);
    }

#endif

#if ISR

    while (wbufIndex < n)
    {
        ;
    }

#endif

    /* ȴͿ */
    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    CS_SET;

    return;
}
