/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  sleep.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/10/08
*描  述:  休眠函数
*备  注:  本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#include "sleep.h"

/***************************************************************
 函数名：void light_sleep(void)
 描  述：进入浅睡眠
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void light_sleep(void)
{
    SCB_SystemLPConfig(SCB_LP_SleepDeep, DISABLE);      /* 浅睡眠 */
    SCB_SystemLPConfig(SCB_LP_SleepOnExit, DISABLE);    /* 从ISR中断处理程序返回到线程模式时不进入休眠 */
    SCB_SystemLPConfig(SCB_LP_SEVOPend, ENABLE);        /* 中断挂起作为唤醒事件 */

    __NOP();
    __NOP();
    __WFI(); /* 休眠 */
    __NOP();
    __NOP();
}

/***************************************************************
 函数名：void deep_sleep(void)
 描  述：进入深度睡眠
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void deep_sleep(void)
{
    SCU_RegUnLock();
    SCU->WAKEUPTIME.Word = 0x00040400;                  /* LDO 1.4V，关闭HRC、PLL、XTAL和CLKFLT */
    SCB_SystemLPConfig(SCB_LP_SleepDeep, ENABLE);       /* 深度睡眠 */
    SCB_SystemLPConfig(SCB_LP_SleepOnExit, DISABLE);    /* 从ISR中断处理程序返回到线程模式时不进入休眠 */
    SCB_SystemLPConfig(SCB_LP_SEVOPend, ENABLE);        /* 中断挂起作为唤醒事件 */
    SCU_RegLock();

    __NOP();
    __NOP();
    __WFI(); /* 休眠 */
    __NOP();
    __NOP();
}
