/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  gpio.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/10/08
*描  述:  外部端口中断配置程序
*备  注:  本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#include "gpio.h"

/***************************************************************
 函数名：void PINTx_Init(void)
 描  述：端口中断初始化函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void PINTx_Init(void)
{
    GPIO_InitStruType x;

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_PDEN = GPIO_PDE_Input_Enable;
    GPIO_Init(GPIOA, GPIO_Pin_0, &x);

    PINT_Config(PINT0, PINT_SEL0, PINT_Trig_Rise);
    PINT0_MaskDisable();
    PINT0_Enable();
    NVIC_Init(NVIC_PINT0_IRQn, NVIC_Priority_1, ENABLE);

    return;
}

/***************************************************************
 函数名：void KINTx_Init(void)
 描  述：按键中断初始化函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void KINTx_Init(void)
{
    GPIO_InitStruType x;
    KINT_InitSettingType y;

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_PDEN = GPIO_PDE_Input_Enable;
    GPIO_Init(GPIOA, GPIO_Pin_3, &x);

    y.IE_Set = KINT_IE_Set_Enable;
    y.Trigger_Style = KINT_Trigger_Rising_Edge;
    KINT_Init(GPIOA, GPIO_Pin_3, &y);
    NVIC_Init(NVIC_KINT_IRQn, NVIC_Priority_1, ENABLE);

    return;
}
