/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  sleep.c
*  :
*  :  V1.00
*  :  2018/05/3
*  :
*  ע:  HRSDK-GDB-ES8P508x V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "sleep.h"
#include "key.h"

/*********************************************************
: void Sleep(uchar mode)
  : ģʽӳ
ֵ: mode - IDLEģʽ
ֵ: 
ֵ: 
**********************************************************/
void Sleep(uint8_t mode)
{
    uint32_t i;
    SCU_RegUnLock();
    //SCU->WAKEUPTIME.Word = 0x00040000;        //˯¹رHRCPLLXTALԼCLKFLT
    SCU_RegLock();

    __disable_irq(); //رIRQж
    IWDT_Clear();  //幷
    DeviceClockAllEnable();
    SCU_OpenXTAL();  //ʹⲿ
    GPIO->PAINEB.Word = 0XFFFFFFFF; //ر
    GPIO->PBINEB.Word = 0XFFFFFFFF;
    GPIO->PADIR.Word = 0X00000000;  //
    GPIO->PBDIR.Word = 0X00000000;
    GPIO->PADATA.Word = 0XFFFFFFFF;  //PAȫ
    GPIO->PBDATA.Word = 0XFFFFFFFF;  //PBȫ

    KINTInit();                             //ʼKINT

    SCU_RegUnLock();
    SCU_LVDVS_3V9();    //LVDѵѹ3.9V
    SCU_LVDIFS_Fall(); //LVDѹ߼
    SCU_LVDFLT_Enable(); //LVD˲ʹ
    SCU_LVD_Enable(); //LVDжʹ
    SCU->SCLKEN0.CLKFLT_BY = 0x55;//CLKFLT·CLKFLTΪϵͳʱ˲
    SCU->SCLKEN1.PLL_EN = 0;//PLLƵֹ
    SCU->WAKEUPTIME.Word = 0x00040400; //ʱֵС0x3FF
    SCU->WAKEUPTIME.CLKFLT_EN = 0; //˯ϵͳʱ˲ر
    SCU->WAKEUPTIME.MOSC_EN = 1; //˯ʱӲرգΪRTCʱԴXTAL
    SCU_RegLock();

    RTC_Init(RTC_LOSC, RTC_HOUR24);//ʵʱʱӳʼ
    RTC_WriteSecond(30);
    RTC_InterruptEnable(RTC_Interrupt_Source_Second);//ʹʵʱʱӵж

    IWDT_RegUnLock();//WDTرд
    IWDT_ITEnable(); //IEʹ

    if (1 == mode)
    {
        SCB_SystemLPConfig(SCB_LP_SleepDeep, ENABLE);   //Ϊ˯ģʽ
    }

    NVIC_EnableIRQ(RTC_IRQn);  //ʹ뻽Դ
    NVIC_EnableIRQ(LVD_IRQn);  //ʹLVDԴ
    NVIC_EnableIRQ(KINT_IRQn); //ʹܰ
    NVIC_EnableIRQ(IWDT_IRQn);  //ʹWDTԴ
    RTC->WP.WP = 0x55AAAA55;   //RTCرд

    while (1) //ѭ
    {
        SCU_RegUnLock();
        SCU->SCLKEN1.HRC_EN = 0; //HRCرϵͳʱԶлLRC //ϵͳʱڲС2us

        NVIC->ICPR[0] = 0XFFFFFFFF; //NVICʶ
        __NOP();
        __NOP();
        __WFI();
        __NOP();
        __NOP();

        SCU->SCLKEN1.HRC_EN = 1;

        while (SCU->SCLKEN1.HRC_RDY == 0);      //ȴʱӿ

        SCU->SCLKEN0.CLK_SEL = SCU_SysClk_HRC;
        SCU_RegLock();

        if (SCU_GetLVDFlagStatus(SCU_LVDFlag_IF) != RESET) //LVD
        {
            SCU_RegUnLock();
            SCU_LVDClearIFBit();
            SCU_RegLock();
            NVIC_SystemReset();   //λ
        }

        if (IWDT_GetFlagStatus() != RESET)
        {
            IWDT_Clear();   //幷
        }

        if (RTC_GetFlagStatus(RTC_Interrupt_Source_Second) != RESET
                && RTC_GetITStatus(RTC_Interrupt_Source_Second) != RESET)  //뻽
        {
            RTC->IF.Word = 1U << 0; //жϱʶ
            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת
        }

        if (PINT_GetITStatus(PINT_IT_PINT4) != RESET)  //KINT
        {
            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 565350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 565350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 565350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 565350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 565350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 565350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 565350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת
            PINT_ClearITPendingBit(PINT_IT_PINT4);
        }
    }
}
