/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  sleep.c
*  :
*  :  V1.00
*  :  2018/05/3
*  :
*  ע:  HRSDK-GDB-ES8P508x V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "sleep.h"
#include "key.h"

/*********************************************************
: void Sleep(uchar mode)
  : ģʽӳ
ֵ: mode - IDLEģʽ
ֵ: 
ֵ: 
**********************************************************/
void Sleep(uint8_t mode)
{
    uint32_t i;
    SCU_RegUnLock();
    SCU->WAKEUPTIME.Word = 0x00040000;        //˯¹رHRCPLLXTALԼCLKFLT
    SCU_RegLock();

    __disable_irq(); //رIRQж
    DeviceClockAllEnable();

    GPIO->PAINEB.Word = 0XFFFFFFFF; //ر
    GPIO->PBINEB.Word = 0XFFFFFFFF;
    GPIO->PADIR.Word = 0X00000000;  //
    GPIO->PBDIR.Word = 0X00000000;
    GPIO->PADATA.Word = 0X00004000;  //PA6߹رLED1
    GPIO->PBDATA.Word = 0X00000080;  //PB7

    KINTInit();                             //ʼKINT

    SCU->PCLKEN0.Word = 0x00000003;         //رʱӣscu޷رգͬʱGPIOʱӹⲿжϻ
    SCU->PCLKEN1.Word = 0x00000000;

    SCU_RegUnLock();
    SCU_LVDVS_3V9();    //LVDѵѹ3.9V
    SCU_LVDIFS_Fall(); //LVDѹ߼
    SCU_LVDFLT_Enable(); //LVD˲ʹ
    SCU_LVD_Enable(); //LVDжʹ
    SCU->WAKEUPTIME.CLKFLT_EN  = 0; //˯ϵͳʱ˲ر
    SCU->WAKEUPTIME.MOSC_EN = 0; //˯ʱԶر
    SCU->WAKEUPTIME.WAKEUPTIME = 0x400; //ʱֵС0x3FF
    SCU_RegLock();

    if (1 == mode)
    {
        SCB_SystemLPConfig(SCB_LP_SleepDeep, ENABLE);   //Ϊ˯ģʽ
    }

    NVIC_EnableIRQ(LVD_IRQn);  //ʹLVDԴ
    NVIC_EnableIRQ(KINT_IRQn); //ʹܰ
    NVIC_EnableIRQ(IWDT_IRQn);  //ʹWDTԴ

    while (1) //ѭ
    {

        NVIC->ICPR[0] = 0XFFFFFFFF; //NVICʶ
        __NOP();
        __NOP();
        __WFI();
        __NOP();
        __NOP();

        if (SCU_GetLVDFlagStatus(SCU_LVDFlag_IF) != RESET) //LVD
        {
            SCU_RegUnLock();
            SCU_LVDClearIFBit();
            SCU_RegLock();
            NVIC_SystemReset();   //λ
        }

        if (IWDT_GetFlagStatus() != RESET)
        {
            IWDT_Clear();   //幷
        }

        if (PINT_GetITStatus(PINT_IT_PINT4) != RESET)  //KINT
        {

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת
            PINT_ClearITPendingBit(PINT_IT_PINT4);
        }

    }
}
