/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  iic.c
*  :  Liut
*  :  V1.00
*  :  2017/06/26
*  :  IICģ
          EEPROM
*  ע:  HRSDK-GDB-ES8P508x V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "iic.h"
#include "systick.h"

uint8_t g_txbuf[255];
uint8_t g_rxbuf[255] ;
uint8_t g_tx_length;
uint8_t g_rx_length;
volatile uint8_t g_tx_count;
volatile uint8_t g_rx_count;

/*********************************************************
: void IIC1MasterInit(void)
  : IICʼӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void IICMasterInit(void)
{
    GPIO_InitStruType x;
    I2C_InitStruType y;

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PUEN = GPIO_PUE_Input_Enable;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_OD = GPIO_ODE_Output_Enable;
    x.GPIO_DS = GPIO_DS_Output_Normal;;
    GPIO_Init(GPIOA, GPIO_Pin_30, &x);  //SDA
    GPIO_Init(GPIOA, GPIO_Pin_31, &x);  //SCL

    y.I2C_SclOd = I2C_PinMode_OD;
    y.I2C_SdaOd = I2C_PinMode_OD;
    y.I2C_16XSamp = DISABLE;
    y.I2C_Clk = 100000;        //100KHz
    y.I2C_Mode = I2C_Mode_Master;
    y.I2C_AutoStop = DISABLE;
    y.I2C_AutoCall = DISABLE;
    I2C_Init(&y);

    I2C_TBIMConfig(I2C_TRBIM_Byte);
    I2C_RBIMConfig(I2C_TRBIM_Byte);
    I2C_RecModeConfig(I2C_RecMode_0);

    I2C_ITConfig(I2C_IT_TB, DISABLE);   //ͻж(Ҫʱʱ)
    I2C_ITConfig(I2C_IT_RB, ENABLE);    //ջжϣճ

    I2C_AckDelay(I2C_AckDelay_4, ENABLE);
    NVIC_Init(NVIC_I2C0_IRQn, NVIC_Priority_1, ENABLE);
    I2C_Enable();
}

/*********************************************************
: uint8_t IIC1ReadByte(uint8_t slave_addr, uint8_t memory_addr)
  : IICݣֽڶ(ѯģʽ)
ֵ: addrַ
ֵ: 
ֵ: bufݻ
**********************************************************/
uint8_t IICReadByte(uint8_t slave_addr)
{
    uint32_t time_count = 0x0U;
    g_rx_length = 1;
    g_rx_count = 0;

    /* I2Cóʼ */
    IICMasterInit();

    I2C_SendAddress(slave_addr, I2C_Mode_Read);
    I2C_SRTrigger();

    while ((I2C_GetFlagStatus(I2C_Flag_SR) == RESET) && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SR);

    I2C_RecModeConfig(I2C_RecMode_1);
    I2C_ITConfig(I2C_IT_RB, ENABLE);
    I2C_RDTrigger();

    /* ȵ */
    time_count = 0x0U;

    while ((g_rx_count < g_rx_length) && (++time_count < 0xFFF));

    time_count = 0x0U;
    I2C_SPTrigger();

    while ((I2C_GetFlagStatus(I2C_Flag_SP) == RESET) && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SP);

    /* λI2Cģ */
    I2C_Reset();

    return g_rxbuf[0];
}

/*********************************************************
: ErrorStatus IIC1WriteByte(uint8_t slave_addr, uint8_t memory_addr, uint8_t buf)
  : SPIдݣֽڱ
ֵ: addrַ
        bufݻ
ֵ: 
ֵ: 
**********************************************************/
ErrorStatus IICWriteByte(uint8_t slave_addr, uint8_t buf)
{
    uint32_t time_count = 0x0U;
    g_txbuf[0] = buf;
    g_tx_length = 1;
    g_tx_count = 0;

    /* I2Cóʼ */
    IICMasterInit();
    I2C_ITConfig(I2C_IT_TB, ENABLE);
    I2C_ClearITPendingBit(I2C_Clr_NA);

    I2C_SendAddress(slave_addr, I2C_Mode_Write);
    I2C_SRTrigger();

    while ((I2C_GetFlagStatus(I2C_Flag_SR) == RESET) && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SR);

    /* ȴͿ */
    time_count = 0x0U;

    while ((((I2C_GetTBStatus() == RESET) || (g_tx_count != g_tx_length))) && (++time_count < 0xFFF));

    time_count = 0x0U;

    while ((I2C_GetTBStatus() == RESET) && (++time_count < 0xFFF));

    I2C_SPTrigger();
    time_count = 0x0U;

    while ((I2C_GetFlagStatus(I2C_Flag_SP) == RESET) && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SP);

    /* λI2Cģ */
    I2C_Reset();

    if (I2C_GetFlagStatus(I2C_Flag_NA) == SET)
    {
        return ERROR;
    }

    return SUCCESS;
}

/*********************************************************
: void IICReadBuf(uint8_t slave_addr, uint8_t *buf, uint8_t len)
: IICݣֽڶ
ֵ: addr-ַ
        len-ȡݴС
ֵ: 
ֵ: buf-ݻ
**********************************************************/
void IICReadBuf(uint8_t slave_addr, uint8_t *buf, uint8_t len)
{
    uint32_t time_count = 0x0U;
    g_rx_length = len;
    g_rx_count = 0;

    /* I2Cʼ */
    IICMasterInit();

    I2C_SendAddress(slave_addr, I2C_Mode_Read);
    I2C_SRTrigger();

    while ((I2C_GetFlagStatus(I2C_Flag_SR) == RESET) && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SR);

    I2C_RecModeConfig(I2C_RecMode_6);
    I2C_ITConfig(I2C_IT_RB, ENABLE);
    I2C_RDTrigger();

    /* ȴ */
    time_count = 0x0U;

    while ((g_rx_count < g_rx_length) && (++time_count < 0xFFF));

    time_count = 0x0U;
    I2C_SPTrigger();

    while ((I2C_GetFlagStatus(I2C_Flag_SP) == RESET) && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SP);

    /* λI2Cģ */
    I2C_Reset();

    memcpy(buf, g_rxbuf, len);

    return;
}

/*********************************************************
: ErrorStatus IICWriteBuf(uint8_t slave_addr, uint8_t *buf, uint8_t len)
: IICд
ֵ: addr-ַ
        buf-ݻ
        len-ݴС
ֵ: 
ֵ: success/error
**********************************************************/
ErrorStatus IICWriteBuf(uint8_t slave_addr, uint8_t *buf, uint8_t len)
{
    uint32_t time_count = 0x0U;

    memcpy(g_txbuf, buf, len);
    g_tx_length = len;
    g_tx_count = 0;

    /* I2Cóʼ */
    IICMasterInit();
    I2C_ITConfig(I2C_IT_TB, ENABLE);
    I2C_ClearITPendingBit(I2C_Clr_NA);

    I2C_SendAddress(slave_addr, I2C_Mode_Write);
    I2C_SRTrigger();

    while ((I2C_GetFlagStatus(I2C_Flag_SR) == RESET) && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SR);

    /* ȴз */
    time_count = 0x0U;

    while ((((I2C_GetTBStatus() == RESET) || (g_tx_count != g_tx_length))) && (++time_count < 0xFFF));

    time_count = 0x0U;
    I2C_SPTrigger();

    while ((I2C_GetFlagStatus(I2C_Flag_SP) == RESET) && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SP);

    /* λI2Cģ */
    I2C_Reset();

    if (I2C_GetFlagStatus(I2C_Flag_NA) == SET)
    {
        return ERROR;
    }

    return SUCCESS;
}

