#include "irqhandler.h"
#include "lib_iic.h"

uint8_t rxcnt;
uint8_t txcnt;

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
}

/***************************************************************
 : void T16N3_IRQHandler(void)
   T16N3ʱжϺ
 ֵ
 ֵ
 ֵ
***************************************************************/
void T16N3_IRQHandler(void)
{

}

/***************************************************************
 : void I2C0_IRQHandler(void)
   IICжϺ
         ûҪٴʱʹòĴķ
 ֵ
 ֵ
 ֵ
***************************************************************/
void I2C0_IRQHandler(void)
{
    /* յʼλ+ַƥ+Ӧλ */
    if (I2C_GetITStatus(I2C_IT_SR) == SET)
    {
        I2C_ClearITPendingBit(I2C_Clr_SR);

        if (I2C_GetRWMode() == I2C_Mode_Read)
        {
            txcnt = 0x0U;

            I2C_ClearITPendingBit(I2C_Clr_NA);
            I2C_ClearITPendingBit(I2C_Clr_TIDLE);
            I2C_ITConfig(I2C_IT_RB, DISABLE);
            I2C_ITConfig(I2C_IT_TB, ENABLE);
        }
        else if (I2C_GetRWMode() == I2C_Mode_Write)
        {
            rxcnt = 0x0U;

            I2C_ClearITPendingBit(I2C_Clr_NA);
            I2C_ClearITPendingBit(I2C_Clr_TIDLE);
            I2C_ITConfig(I2C_IT_RB, ENABLE);
            I2C_ITConfig(I2C_IT_TB, DISABLE);
        }
    }

    /* ж */
    if (I2C_GetITStatus(I2C_IT_RB) == SET)
    {
        g_buf[rxcnt++] = I2C_RecByte();
    }

    /* ж */
    if (I2C_GetITStatus(I2C_IT_TB) == SET)
    {
        if (I2C_GetFlagStatus(I2C_Flag_NA) != SET)
        {
            I2C_SendByte(g_buf[txcnt++]);
        }
    }

    /* յλ */
    if (I2C_GetITStatus(I2C_IT_SP) == SET)
    {
        I2C_ClearITPendingBit(I2C_Clr_SP);
        I2C_ClearITPendingBit(I2C_Clr_NA);

        I2C_ITConfig(I2C_IT_RB, DISABLE);
        I2C_ITConfig(I2C_IT_TIDLE, DISABLE);
    }
}
