/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  iic.c
*  :  Liut
*  :  V1.00
*  :  2017/06/26
*  :  IICģ
*  ע:  HRSDK-GDB-ES8P508x V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "iic.h"


/*********************************************************
: void IIC1MasterInit(void)
  : IICʼӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void IICMasterInit(void)
{
    GPIO_InitStruType x;
    I2C_InitStruType y;

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PUEN = GPIO_PUE_Input_Enable;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_OD = GPIO_ODE_Output_Enable;
    x.GPIO_DS = GPIO_DS_Output_Strong;
    GPIO_Init(GPIOA, GPIO_Pin_31, &x);   //PA31--SCL,FUN3
    GPIO_Init(GPIOA, GPIO_Pin_30, &x);   //PA30--SDA,FUN3

    y.I2C_SclOd = I2C_PinMode_OD;
    y.I2C_SdaOd = I2C_PinMode_OD;
    y.I2C_16XSamp = DISABLE;
    y.I2C_Clk = 400000;        //400KHz
    y.I2C_Mode = I2C_Mode_Master;
    y.I2C_AutoStop = DISABLE;
    y.I2C_AutoCall = DISABLE;
    I2C_Init(&y);

    I2C_TBIMConfig(I2C_TRBIM_Byte);
    I2C_RBIMConfig(I2C_TRBIM_Byte);
    I2C_RecModeConfig(I2C_RecMode_0);

    I2C_Enable();
}

/*********************************************************
: uint8_t IICReadByte(uint8_t slave_addr)
  : IICݣֽڶ(ѯģʽ)
ֵ: slave_addrַ
ֵ: 
ֵ: bufݻ
**********************************************************/
uint8_t IICReadByte(uint8_t slave_addr)
{
    uint32_t time_count = 0x0U;
    uint8_t temp;

    I2C_SendAddress(slave_addr, I2C_Mode_Read);
    I2C_SRTrigger();

    while (I2C_GetFlagStatus(I2C_Flag_SR) == RESET && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SR);

    I2C_RecModeConfig(I2C_RecMode_1);
    I2C_RDTrigger();

    time_count = 0x0U;

    while (I2C_GetFlagStatus(I2C_Flag_RB) == RESET && (++time_count < 0xFFF));

    temp = I2C_RecByte();
    time_count = 0x0U;

    while (I2C_GetFlagStatus(I2C_Flag_RB) == SET && (++time_count < 0xFFF));

    time_count = 0x0U;
    I2C_SPTrigger();

    while (I2C_GetFlagStatus(I2C_Flag_SP) == RESET && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SP);

    return temp;
}

/*********************************************************
: ErrorStatus IICWriteByte(uint8_t slave_addr, uint8_t buf)
  : IICдݣֽڱ
ֵ: addrַ
        bufݻ
ֵ: 
ֵ: 
**********************************************************/
ErrorStatus IICWriteByte(uint8_t slave_addr, uint8_t buf)
{
    uint32_t time_count = 0x0U;

    I2C_ClearITPendingBit(I2C_Clr_NA);

    I2C_SendAddress(slave_addr, I2C_Mode_Write);
    I2C_SRTrigger();

    while (I2C_GetFlagStatus(I2C_Flag_SR) == RESET && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SR);

    time_count = 0x0U;

    while (I2C_GetTBStatus() == RESET && (++time_count < 0xFFF));

    I2C_SendByte(buf);
    time_count = 0x0U;

    while (I2C_GetTBStatus() == RESET && (++time_count < 0xFFF));

    time_count = 0x0U;
    I2C_SPTrigger();

    while (I2C_GetFlagStatus(I2C_Flag_SP) == RESET && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SP);

    if (I2C_GetFlagStatus(I2C_Flag_NA) == SET)
        return ERROR;

    return SUCCESS;
}



/*********************************************************
: void IICReadBuf(uint8_t slave_addr , char * buf, char size )
  : IICݣֽڶ(ѯģʽ)
ֵ: slave_addrַ
        size-ݴС
ֵ: 
ֵ: bufݻ
**********************************************************/
void IICReadBuf(uint8_t slave_addr, uint8_t *buf, uint8_t size)
{
    uint32_t time_count = 0x0U;

    I2C_SendAddress(slave_addr, I2C_Mode_Read);
    I2C_SRTrigger();

    while (I2C_GetFlagStatus(I2C_Flag_SR) == RESET && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SR);

    I2C_RecModeConfig(I2C_RecMode_0);

    while (size-- > 1)
    {
        I2C_RDTrigger();
        time_count = 0x0U;

        while (I2C_GetFlagStatus(I2C_Flag_RB) == RESET && (++time_count < 0xFFF));

        *buf++ = I2C_RecByte();
    }

    I2C_RecModeConfig(I2C_RecMode_1);
    I2C_RDTrigger();
    time_count = 0x0U;

    while (I2C_GetFlagStatus(I2C_Flag_RB) == RESET && (++time_count < 0xFFF));

    *buf = I2C_RecByte();
    time_count = 0x0U;

    while (I2C_GetFlagStatus(I2C_Flag_RB) == SET && (++time_count < 0xFFF));

    time_count = 0x0U;
    I2C_SPTrigger();

    while (I2C_GetFlagStatus(I2C_Flag_SP) == RESET && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SP);

    return;
}




/*********************************************************
: IICWriteBuf
  : IICд
ֵ: addrַ
        bufݻ
        size-ݴС
ֵ: 
ֵ: 
**********************************************************/
ErrorStatus IICWriteBuf(uint8_t slave_addr, uint8_t *buf, uint8_t size)
{
    uint32_t time_count = 0x0U;

    I2C_ClearITPendingBit(I2C_Clr_NA);

    I2C_SendAddress(slave_addr, I2C_Mode_Write);
    I2C_SRTrigger();

    while (I2C_GetFlagStatus(I2C_Flag_SR) == RESET && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SR);

    while (size-- > 0)
    {
        time_count = 0x0U;

        while (I2C_GetTBStatus() == RESET && (++time_count < 0xFFF));

        time_count = 0x0U;
        I2C_SendByte(*buf++);

        while ((I2C_GetFlagStatus(I2C_Flag_TB) == RESET) && (++time_count < 0xFFF));
    }

    time_count = 0x0U;

    while (I2C_GetTBStatus() == RESET && (++time_count < 0xFFF));

    time_count = 0x0U;
    I2C_SPTrigger();

    while (I2C_GetFlagStatus(I2C_Flag_SP) == RESET && (++time_count < 0xFFF));

    I2C_ClearITPendingBit(I2C_Clr_SP);

    if (I2C_GetFlagStatus(I2C_Flag_NA) == SET)
        return ERROR;

    return SUCCESS;
}
