/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  systick.c
*  :  Liut
*  :  V1.00
*  :  2017/06/25
*  :  SysTickģ
*  ע:  HRSDK-GDB-ES8P508 V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "systick.h"

__IO uint32_t TimingDelay;

/***************************************************************
 void SysTickInit(void)
   ϵͳδʼ100us
 ֵ
 ֵ
 ֵ
***************************************************************/
void SysTickInit(void)
{
    SYSTICK_InitStruType x;

    x.SysTick_Value = 2000;                     //100us
    x.SysTick_ClkSource = SysTick_ClkS_Cpu;
    x.SysTick_ITEnable = ENABLE;                //жʹ
    SysTick_Init(&x);

    SysTick_Disable();                          //ʹʱſ
}

/***************************************************************
 void Delay100us(__IO uint32_t nTime)
   ϵͳδ100usʱ
 ֵʱ100us
 ֵ
 ֵ
***************************************************************/
void Delay100us(__IO uint32_t nTime)
{
    TimingDelay = nTime;
    SysTick_Enable();

    while (TimingDelay != 0);

    SysTick_Disable();
}

/***************************************************************
 void Delay1ms(__IO uint32_t nTime)
   ʱ
 ֵʱ1msĸ
 ֵ
 ֵ
***************************************************************/
void Delay1ms(__IO uint32_t nTime)
{
    uint32_t i;

    for (i = 0; i < nTime; i++)
        Delay100us(10);
}

/***************************************************************
 void TimingDelay_Decrement(void)
   ϵͳδжϵ
 ֵ
 ֵ
 ֵ
***************************************************************/
void TimingDelay_Decrement(void)
{
    if (TimingDelay != 0)
        TimingDelay --;
}
