/***************************************************************
 *Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
 *ļ  lib_scu.c
 *  ߣ  Liut
 *    V1.00
 *  ڣ  2017/07/14
 *    ϵͳģ⺯
 *  ע   ES8P508xоƬ
 ѧϰʾʹãûֱôķջеκηΡ
 ***************************************************************/
#include "lib_scu.h"

/***************************************************************
  SCU_OpenXTAL
    : ⲿʱ
  ֵ
  ֵ
  ֵϵͳʱԴ
 ***************************************************************/
void SCU_OpenXTAL(void)
{
    SCU_RegUnLock();
    SCU->SCLKEN1.XTAL_EN = 1;
    SCU->SCLKEN0.XTAL_LP = 0;

    while (SCU->SCLKEN1.XTAL_RDY == 0); //ȴⲿʱȶ

    SCU_RegLock() ;
}

/***************************************************************
  SCU_NMISelect
    NMIж
  ֵж
  ֵ
  ֵ
 ***************************************************************/
void SCU_NMISelect(SCU_TYPE_NMICS NMI_Type)
{
    SCU_RegUnLock();
    SCU->NMICON.NMICS = NMI_Type;
    SCU_RegLock() ;
}

/***************************************************************
  SCU_GetPWRCFlagStatus
    ȡPWRCλ״̬Ĵ־λ״̬
  ֵPWRCĴ־λ
  ֵ
  ֵRESET/SET
 ***************************************************************/
FlagStatus  SCU_GetPWRCFlagStatus(SCU_TYPE_PWRC PWRC_Flag)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->PWRC.Word & (uint32_t)PWRC_Flag) != (uint32_t)RESET)
        bitstatus = SET;
    else
        bitstatus = RESET;

    return  bitstatus;
}

/***************************************************************
  SCU_ClearPWRCFlagBit
    PWRCλ״̬Ĵ־λ
  ֵPWRCĴ־λ
  ֵ
  ֵ
 ***************************************************************/
void SCU_ClearPWRCFlagBit(SCU_TYPE_PWRC PWRC_Flag)
{
    SCU_RegUnLock() ;
    SCU->PWRC.Word &= ~((uint32_t)PWRC_Flag);
    SCU_RegLock() ;
}

/***************************************************************
  SCU_GetLVDFlagStatus
    ȡLVDDĴ־λ״̬
  ֵLVDĴ־λ
  ֵ
  ֵRESET/SET
 ***************************************************************/
FlagStatus  SCU_GetLVDFlagStatus(SCU_TYPE_LVD0CON LVD_Flag)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->LVDCON.Word & (uint32_t)LVD_Flag) != (uint32_t)RESET)
        bitstatus = SET;
    else
        bitstatus = RESET;

    return  bitstatus;
}

/***************************************************************
  SCU_SysClkSelect
    ѡϵͳʱ
  ֵʱԴ
  ֵ
  ֵ
 ***************************************************************/
void SCU_SysClkSelect(SCU_TYPE_CLK_SEL Sysclk)
{
    SCU_RegUnLock() ;
    SCU->SCLKEN0.CLK_SEL = Sysclk;
    SCU_RegLock() ;
}

/***************************************************************
  SCU_GetSysClk
    ȡϵͳʱԴ
  ֵ
  ֵ
  ֵϵͳʱԴ
 ***************************************************************/
SCU_TYPE_SYSCLK SCU_GetSysClk(void)
{
    return (SCU_TYPE_SYSCLK)(SCU->SCLKEN0.CLK_SEL);
}

/***************************************************************
  SCU_HRCReadyFlag
    ȡHRCȶ־λ
  ֵ
  ֵ
  ֵRESETȶ/SETȶ
 ***************************************************************/
FlagStatus SCU_HRCReadyFlag(void)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->SCLKEN1.HRC_RDY) != (uint32_t)RESET)
        bitstatus = SET;
    else
        bitstatus = RESET;

    return  bitstatus;
}

/***************************************************************
  SCU_XTALReadyFlag
    ȡXTALȶ־λ
  ֵ
  ֵ
  ֵRESETȶ/SETȶ
 ***************************************************************/
FlagStatus  SCU_XTALReadyFlag(void)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->SCLKEN1.XTAL_RDY) != (uint32_t)RESET)
        bitstatus = SET;
    else
        bitstatus = RESET;

    return  bitstatus;
}

/***************************************************************
  SCU_LOSCReadyFlag
    ȡLOSCȶ־λ
  ֵ
  ֵ
  ֵRESETȶ/SETȶ
 ***************************************************************/
FlagStatus  SCU_PLLReadyFlag(void)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->SCLKEN1.PLL_RDY) != (uint32_t)RESET)
        bitstatus = SET;
    else
        bitstatus = RESET;

    return  bitstatus;
}

/***************************************************************
 SystemClockConfig
   ϵͳʱãڲʱӣ20MHZʱ
 ֵ
 ֵ
 ֵ
***************************************************************/
void SystemClockConfig(void)
{
    uint32_t Prot_Temp;

    Prot_Temp = SCU->PROT.PROT;

    if (Prot_Temp != 0)                     //д
        SCU_RegUnLock();                    //

    SCU_HRC_Enable();                       //ʹڲ20MHZ

    while (SCU_HRCReadyFlag() != SET);      //ȴʱӿ

    SCU_SysClkSelect(CLK_SEL_HRC);       //ѡڲ20MHZΪϵͳʱ

    SCU_SysClk_Div1();                      //ϵͳʱӺƵ1:1

    SystemCoreClock = 20000000;

    if (Prot_Temp != 0)                     //д
        SCU_RegLock();                      //д
}

/***************************************************************
  DeviceClockAllEnable
    ʱ
  ֵ
  ֵ
  ֵ
 ***************************************************************/
void DeviceClockAllEnable(void)
{
    uint32_t Prot_Temp;

    Prot_Temp = SCU->PROT.PROT;

    if (Prot_Temp != 0)                     //д
        SCU_RegUnLock();                    //

    SCU->PCLKEN0.Word = 0xFFFFFFFF;
    SCU->PCLKEN1.Word = 0xFFFFFFFF;         //ʱ

    if (Prot_Temp != 0)                     //д
        SCU_RegLock();                      //д
}

/***************************************************************
  DeviceClockAllDisable
    رʱ
  ֵ
  ֵ
  ֵ
 ***************************************************************/
void DeviceClockAllDisable(void)
{
    uint32_t Prot_Temp;

    Prot_Temp = SCU->PROT.PROT;

    if (Prot_Temp != 0)                     //д
        SCU_RegUnLock();                    //

    SCU->PCLKEN0.Word = 0x00000000;         //رʱӣscu޷ر
    SCU->PCLKEN1.Word = 0x00000000;

    if (Prot_Temp != 0)                     //д
        SCU_RegLock();                  //д
}

/***************************************************************
  : DeviceClockAllEnableButIAP
    : 򿪳IAPģʱ
  ֵ: 
  ֵ: 
  ֵ: 
 ***************************************************************/
void DeviceClockAllEnableButIAP(void)
{
    uint32_t prot_tmp;
    prot_tmp = SCU->PROT.PROT;

    if (prot_tmp != 0)                 //дѿ
        SCU_RegUnLock();               //д

    SCU->PCLKEN0.Word = 0xFFFFFFFB;
    SCU->PCLKEN1.Word = 0xFFFFFFFF;    //򿪳IAPʱ

    if (prot_tmp != 0)                 //дѿ
        SCU_RegLock();                 //д

    return;
}

/***************************************************************
  SystemClockSelect
    ϵͳʱѡ
  ֵCLKx ϵͳʱԴѡ
  ֵ
  ֵ
 ***************************************************************/
void SystemClockSelect(SCU_TYPE_CLK_SEL CLK_SEL)
{
    SCU_RegUnLock();                        //

    switch (CLK_SEL)
    {
        case CLK_SEL_HRC:
            SCU_HRC_Enable();

            while (SCU_HRCReadyFlag() != SET);

            break;

        case CLK_SEL_XTAL:
            SCU_XTAL_Enable();

            while (SCU_XTALReadyFlag() != SET);

            break;

        default:
            break;
    }

    SCU->SCLKEN0.CLKFLT_BY = 0; //ϵͳʱӲΪ48M·ʱ˲
    SCU->SCLKEN0.SYSCLK_DIV = 0;
    SCU->SCLKEN0.CLK_SEL = CLK_SEL;

    SCU_RegLock();
}


/***************************************************************
  PLLClock_Config
    PLLʱ,PLLʱΪϵͳʱ
  ֵpll_en:ǷPLLpll_originpllʱԴѡpll_outpllƵѡsys_pllϵͳʱǷʹPLLʱ
  ֵ
  ֵ
 ***************************************************************/
void PLLClock_Config(TYPE_FUNCEN pll_en, SCU_PLL_Origin  pll_origin, SCU_PLL_Out pll_out, TYPE_FUNCEN sys_pll)
{
    uint32_t i_buf;
    uint32_t n_buf = 29000;

    SCU_RegUnLock();

    if (pll_en == DISABLE) //PLLΪֱֹӽֹPLL
    {
        SCU->SCLKEN0.PLL_MUX = 0;
        SCU->SCLKEN1.PLL_BYLOCK = 0;
        SCU->SCLKEN0.CLKFLT_BY = 0x00;
        SCU->SCLKEN1.PLL_EN = 0;
        return;
    }

    if ((pll_origin == SCU_PLL_HRC))        //ʹڲʱӣ迪ڲʱ
    {
        if (SCU->SCLKEN1.HRC_RDY == 0)
        {
            SCU->SCLKEN1.HRC_EN = 1;

            while (SCU->SCLKEN1.HRC_RDY == 0); //ȴHRC
        }
    }

    if ((pll_origin == SCU_PLL_XTAL_32K)
            || (pll_origin == SCU_PLL_XTAL_4M)
            || (pll_origin == SCU_PLL_XTAL_8M)
            || (pll_origin == SCU_PLL_XTAL_16M)
            || (pll_origin == SCU_PLL_XTAL_20M))          //ʹⲿʱӣ迪ⲿʱ
    {
        if (SCU->SCLKEN1.XTAL_RDY == 0)
        {
            SCU->SCLKEN1.XTAL_EN = 1;
            SCU->SCLKEN0.XTAL_LP = 0;

            while (SCU->SCLKEN1.XTAL_RDY == 0); //ȴXTAL
        }
    }

    switch (pll_origin)
    {
        case SCU_PLL_HRC:
            SCU->SCLKEN1.PLL_REF_SEL = 0x00;
            break;

        case SCU_PLL_LRC:
            SCU->SCLKEN1.PLL_REF_SEL = 0x02;
            break;

        case SCU_PLL_XTAL_32K:
            SCU->SCLKEN1.PLL_REF_SEL = 0x03;
            break;

        case SCU_PLL_XTAL_4M:
            SCU->SCLKEN1.PLL_REF_SEL = 0x04;
            break;

        case SCU_PLL_XTAL_8M:
            SCU->SCLKEN1.PLL_REF_SEL = 0x05;
            break;

        case SCU_PLL_XTAL_16M:
            SCU->SCLKEN1.PLL_REF_SEL = 0x06;
            break;

        case SCU_PLL_XTAL_20M:
            SCU->SCLKEN1.PLL_REF_SEL = 0x07;
            break;

        default:
            break;
    }

    SCU->SCLKEN1.PLL_48M_SEL = pll_out;   //PLLΪ3248Mhz

    SCU->SCLKEN1.PLL_EN = 1;

    for (i_buf = 0; i_buf < n_buf; i_buf++)    //־λѯʱȴʱ20ms
    {
        if (SCU->SCLKEN1.PLL_RDY == SET)
            break;
    }

    if (sys_pll == ENABLE)
    {

        if (pll_out == SCU_PLL_32M)
        {
            SCU->SCLKEN0.CLKFLT_BY = 0;
        }
        else
        {
            SCU->SCLKEN0.CLKFLT_BY = 0x55;  //48M ʱ˲·
        }

        SCU->SCLKEN1.PLL_BYLOCK = 1;
        SCU->SCLKEN0.PLL_MUX = 1;
    }
    else
    {
        SCU->SCLKEN0.PLL_MUX = 0;
        SCU->SCLKEN1.PLL_BYLOCK = 0;
        SCU->SCLKEN0.CLKFLT_BY = 0x00;
    }

    SCU_RegLock();
}

/*************************END OF FILE**********************/



