/***************************************************************
 *Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 *ļ
 *  :  AE
 *  :  V1.00
 *  :  2017/07/14
 *  
 *  ע   ES8P508оƬ
 ѧϰʾʹãûֱôķջеκηΡ
 ***************************************************************/
#include "lib_aes.h"

/***************************************************************
AES_Init
  AESܳʼ
ֵAES_InitStruct ʼṹ
ֵ
ֵ
***************************************************************/
void AES_Init(AES_InitStruType *AES_InitStruct)
{


    AES_Reset();

    AES->CON.ENCRYPT = AES_InitStruct->MODE;
    return;
}

/***************************************************************
AES_WriteKey
  AESдԿ
ֵAES_KEY дԿ
ֵ
ֵ
***************************************************************/
void AES_WriteKey(uint32_t *AES_KEY)
{
    uint32_t *address = AES_KEY;

    AES->KEY3.AES_KEY3 = *address;
    address ++;
    AES->KEY2.AES_KEY2 = *address;
    address ++;
    AES->KEY1.AES_KEY1 = *address;
    address ++;
    AES->KEY0.AES_KEY0 = *address;
}

/***************************************************************
AES_ReadKey
  AESԿ
ֵ
ֵAES_DATAԿλ
ֵ
***************************************************************/
void AES_ReadKey(uint32_t *AES_KEY)
{
    uint32_t *address = AES_KEY;

    *address = AES->KEY3.AES_KEY3;
    address ++;
    *address = AES->KEY2.AES_KEY2;
    address ++;
    *address = AES->KEY1.AES_KEY1;
    address ++;
    *address = AES->KEY0.AES_KEY0;
    return;
}

/***************************************************************
AES_WriteData
  AESдݺ
ֵAES_DATA д
ֵ
ֵ
***************************************************************/
void AES_WriteData(uint32_t *AES_DATA)
{
    uint32_t *address = AES_DATA;

    AES->DATA3.AES_DATA3 = *address;
    address ++;
    AES->DATA2.AES_DATA2 = *address;
    address ++;
    AES->DATA1.AES_DATA1 = *address;
    address ++;
    AES->DATA0.AES_DATA0 = *address;
}

/***************************************************************
AES_WriteData
  AESݺ
ֵ
ֵAES_DATAݴλ
ֵ
***************************************************************/
void AES_ReadData(uint32_t *AES_DATA)
{
    uint32_t *address = AES_DATA;

    *address = AES->DATA3.AES_DATA3;
    address ++;
    *address = AES->DATA2.AES_DATA2;
    address ++;
    *address = AES->DATA1.AES_DATA1;
    address ++;
    *address = AES->DATA0.AES_DATA0;
    return;
}

/***************************************************************
AES_ITConfig
  AESжʹ
ֵAES_IE
    NewState Enable/Disable
ֵ
ֵ
***************************************************************/
void AES_ITConfig(AES_TYPE_IT AES_IE, TYPE_FUNCEN NewState)
{
    uint32_t Word = AES->CON.Word & 0xffffff8e;

    if (AES->CON.GO_DONE == 1)
    {
        return;
    }

    if (NewState == ENABLE)
        Word |= (uint32_t)AES_IE;
    else

        Word &= ~(uint32_t)AES_IE;

    AES->CON.Word = Word;
    return;

}

/***************************************************************
AES_GetFlagStatus
  AESضжϱ־
ֵIFName
        AES_IF_IF ӽж
ֵ
ֵжϱ־
***************************************************************/
FlagStatus AES_GetFlagStatus(AES_TYPE_IF IFName)
{

    if (AES->CON.Word & IFName)
    {
        return SET;
    }

    return RESET;
}

/***************************************************************
AES_ClearITPendingBit
  AESضжϱ־
ֵIFName
        AES_IF_DONE ӽж
ֵ
ֵ
***************************************************************/
void AES_ClearITPendingBit(void)
{
    /* ǵIFGO_DONEͬһwordУIFֵܻһЩ
     * GO_DONE1ʱȡֵGO_DONE0ֵԭ1ٶиֵ
     * òҪв
     */

    if (AES->CON.GO_DONE == SET)
    {
        return;
    }

    AES->CON.IF = SET;

    return;
}

/***************************************************************
AES_GetDoneStatus
  AESǷ/
ֵ
ֵ
ֵAES_DONE_NO δ
    AES_DONE_YES δܻ߼Ѿ
***************************************************************/
AES_TYPE_DONE AES_GetDoneStatus(void)
{
    if (AES->CON.GO_DONE == 1)
    {
        return AES_DONE_NO;
    }

    return AES_DONE_YES;
}

/***************************************************************
AES_Reset
  AESλ
ֵ
ֵ
ֵ
***************************************************************/
void AES_Reset(void)
{
    AES->DATA0.Word = 0x00008000;
    AES->DATA1.Word = 0x00008000;
    AES->DATA2.Word = 0x00008000;
    AES->DATA3.Word = 0x00008000;

    AES->KEY0.Word = 0x00008000;
    AES->KEY1.Word = 0x00008000;
    AES->KEY2.Word = 0x00008000;
    AES->KEY3.Word = 0x00008000;

    AES->CON.Word = 0x00000000;
}


