/***************************************************************
 *Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 *ļ lib_gpio.h
 * ߣ Liut
 *  V1.00
 * ڣ 2017/07/14
 *  GPIOģ鼰ⲿжϡжϿ⺯ͷļ
 * ע  ES8P508xоƬ
 ѧϰʾʹãûֱôķջеκηΡ
 ***************************************************************/
#ifndef __LIBGPIO_H__
#define __LIBGPIO_H__

#include "ES8P508x.h"
#include "type.h"

/*״̬*/

/*˿ڶ*/
typedef enum
{
    GPIOA = 0x0,
    GPIOB = 0x1,
} GPIO_TYPE;

/*Ŷ*/
typedef enum
{
    GPIO_Pin_0 = 0x00,
    GPIO_Pin_1 = 0x01,
    GPIO_Pin_2 = 0x02,
    GPIO_Pin_3 = 0x03,
    GPIO_Pin_4 = 0x04,
    GPIO_Pin_5 = 0x05,
    GPIO_Pin_6 = 0x06,
    GPIO_Pin_7 = 0x07,
    GPIO_Pin_8 = 0x08,
    GPIO_Pin_9 = 0x09,
    GPIO_Pin_10 = 0x0A,
    GPIO_Pin_11 = 0x0B,
    GPIO_Pin_12 = 0x0C,
    GPIO_Pin_13 = 0x0D,
    GPIO_Pin_14 = 0x0E,
    GPIO_Pin_15 = 0x0F,
    GPIO_Pin_16 = 0x10,
    GPIO_Pin_17 = 0x11,
    GPIO_Pin_18 = 0x12,
    GPIO_Pin_19 = 0x13,
    GPIO_Pin_20 = 0x14,
    GPIO_Pin_21 = 0x15,
    GPIO_Pin_22 = 0x16,
    GPIO_Pin_23 = 0x17,
    GPIO_Pin_24 = 0x18,
    GPIO_Pin_25 = 0x19,
    GPIO_Pin_26 = 0x1A,
    GPIO_Pin_27 = 0x1B,
    GPIO_Pin_28 = 0x1C,
    GPIO_Pin_29 = 0x1D,
    GPIO_Pin_30 = 0x1E,
    GPIO_Pin_31 = 0x1F,
} GPIO_TYPE_PIN;

/* Źѡ */
typedef enum
{
    GPIO_Func_0 = 0x0,
    GPIO_Func_1 = 0x1,
    GPIO_Func_2 = 0x2,
    GPIO_Func_3 = 0x3,
} GPIO_TYPE_FUNC;

/* ŷѡ */
typedef enum
{
    GPIO_Dir_Out = 0x0,
    GPIO_Dir_In = 0x1,
} GPIO_TYPE_DIR;

/* ѡ */
typedef enum
{
    GPIO_DS_Output_Normal = 0,   // ͨ
    GPIO_DS_Output_Strong = 1,   // ǿ
} GPIO_TYPE_DS;

/* ź */
typedef enum
{
    GPIO_Pin_Signal_Digital = 0, // ź
    GPIO_Pin_Signal_Analog = 1,  // ģź
} GPIO_Pin_Signal;

/* ʹ */
typedef enum
{
    GPIO_PUE_Input_Disable = 0,  // ֹ
    GPIO_PUE_Input_Enable = 1,   // ʹ
} GPIO_PUE_Input;

/* ʹ */
typedef enum
{
    GPIO_PDE_Input_Disable = 0,  // ֹ
    GPIO_PDE_Input_Enable = 1,   // ʹ
} GPIO_PDE_Input;


/* ©ʹλ */
typedef enum
{
    GPIO_ODE_Output_Disable = 0, // ©ֹ
    GPIO_ODE_Output_Enable = 1,  // ©ʹ
} GPIO_ODE_Output;

/* Ƶƽ */
typedef enum
{
    UART_TXPLV_Low = 0x0,          //Ƶƽ:
    UART_TXPLV_High = 0x1,         //Ƶƽ:
} UART_TYPE_TXPLV;

/* PWMѡ */
typedef enum
{
    UART_TX3PS_NO = 0x0,         //PWMѡ:ǵ
    UART_TX3PS_BUZ = 0x1,        //PWMѡ:BUZҪ̶38K
    UART_TX3PS_T16N3Out0 = 0x2,  //PWMѡ:T16N3OUT0
    UART_TX3PS_T16N3Out1 = 0x3,  //PWMѡ:T16N3OUT1
} UART_TYPE_TX3PS;

typedef enum
{
    UART_TX2PS_NO = 0x0,         //PWMѡ:ǵ
    UART_TX2PS_BUZ = 0x1,        //PWMѡ:BUZҪ̶38K
    UART_TX2PS_T16N2Out0 = 0x2,  //PWMѡ:T16N2OUT0
    UART_TX2PS_T16N2Out1 = 0x3,  //PWMѡ:T16N2OUT1
} UART_TYPE_TX2PS;

typedef enum
{
    UART_TX1PS_NO = 0x0,         //PWMѡ:ǵ
    UART_TX1PS_BUZ = 0x1,        //PWMѡ:BUZҪ̶38K
    UART_TX1PS_T16N1Out0 = 0x2,  //PWMѡ:T16N1OUT0
    UART_TX1PS_T16N1Out1 = 0x3,  //PWMѡ:T16N1OUT1
} UART_TYPE_TX1PS;

typedef enum
{
    UART_TX0PS_NO = 0x0,         //PWMѡ:ǵ
    UART_TX0PS_BUZ = 0x1,        //PWMѡ:BUZҪ̶38K
    UART_TX0PS_T16N0Out0 = 0x2,  //PWMѡ:T16N0OUT0
    UART_TX0PS_T16N0Out1 = 0x3,  //PWMѡ:T16N0OUT1
} UART_TYPE_TX0PS;

/*Ʋܽ*/
typedef enum
{
    UART_TYPE_TXD3 = 0x0,        //TXD3ܽ
    UART_TYPE_TX3BUZ = 0x1,      //BUZܽ
    UART_TYPE_T16N3OUT0 = 0x2,   //T16N3OUT0ܽ
    UART_TYPE_T16N3OUT1 = 0x3,   //T16N3OUT1ܽ
} UART_TYPE_TX3Sx;

typedef enum
{
    UART_TYPE_TXD2 = 0x0,        //TXD2ܽ
    UART_TYPE_TX2BUZ = 0x1,      //BUZܽ
    UART_TYPE_T16N2OUT0 = 0x2,   //T16N2OUT0ܽ
    UART_TYPE_T16N2OUT1 = 0x3,   //T16N2OUT1ܽ
} UART_TYPE_TX2Sx;

typedef enum
{
    UART_TYPE_TXD1 = 0x0,        //TXD1ܽ
    UART_TYPE_TX1BUZ = 0x1,      //BUZܽ
    UART_TYPE_T16N1OUT0 = 0x2,   //T16N1OUT0ܽ
    UART_TYPE_T16N1OUT1 = 0x3,   //T16N1OUT1ܽ
} UART_TYPE_TX1Sx;

typedef enum
{
    UART_TYPE_TXD0 = 0x0,        //TXD0ܽ
    UART_TYPE_TX0BUZ = 0x1,      //BUZܽ
    UART_TYPE_T16N0OUT0 = 0x2,   //T16N0OUT0ܽ
    UART_TYPE_T16N0OUT1 = 0x3,   //T16N0OUT1ܽ
} UART_TYPE_TX0Sx;

/* GPIOʼýṹ嶨 */
typedef struct
{
    GPIO_Pin_Signal GPIO_Signal; /* ϵźֻͣģ */
    GPIO_TYPE_FUNC GPIO_Func;    //Źѡ
    GPIO_TYPE_DIR GPIO_Direction;//ѡ
    GPIO_PUE_Input GPIO_PUEN;    //ʹ
    GPIO_PDE_Input GPIO_PDEN;    //ʹ
    GPIO_ODE_Output GPIO_OD;     //ģʽ©ʹ
    GPIO_TYPE_DS GPIO_DS;        //
} GPIO_InitStruType;

/* KINTжʹ */
typedef enum
{
    KINT_IE_Set_Disable = 0,       // жϽֹ
    KINT_IE_Set_Enable = 1,        // жʹ
} KINT_IE_Set;

/* KINTжϷʽ */
typedef enum
{
    KINT_Trigger_Rising_Edge = 0,  // شж
    KINT_Trigger_Trailing_Edge = 1,  // ½شж
    KINT_Trigger_High_Level = 2,   // ߵƽж
    KINT_Trigger_Low_Level = 3,      // ͵ƽж
    KINT_Trigger_Both_Edge = 4,      // غ½ضж
} KINT_Trigger_Style;

/* KINTʼýṹ */
typedef struct
{
    KINT_IE_Set IE_Set;          // жǷʹ
    KINT_Trigger_Style Trigger_Style;// жϴʽ
} KINT_InitSettingType;

/* PINT */
typedef enum
{
    PINT0 = 0x0,
    PINT1 = 0x1,
    PINT2 = 0x2,
    PINT3 = 0x3,
    PINT4 = 0x4,
    PINT5 = 0x5,
    PINT6 = 0x6,
    PINT7 = 0x7,
} PINT_TYPE;

/* PINT SEL */
typedef enum
{
    PINT_SEL0 = 0x0,
    PINT_SEL1 = 0x1,
    PINT_SEL2 = 0x2,
    PINT_SEL3 = 0x3,
    PINT_SEL4 = 0x4,
    PINT_SEL5 = 0x5,
    PINT_SEL6 = 0x6,
    PINT_SEL7 = 0x7,
} PINT_TYPE_SEL;

/* PINT Trigger */
typedef enum
{
    PINT_Trig_Rise = 0x0,
    PINT_Trig_Fall = 0x1,
    PINT_Trig_High = 0x2,
    PINT_Trig_Low = 0x3,
    PINT_Trig_Change = 0x4,
} PINT_TYPE_TRIG;

/* PINTжϱ־ */
typedef enum
{
    PINT_IT_PINT0 = 0x01,
    PINT_IT_PINT1 = 0x02,
    PINT_IT_PINT2 = 0x04,
    PINT_IT_PINT3 = 0x08,
    PINT_IT_PINT4 = 0x10,
    PINT_IT_PINT5 = 0x20,
    PINT_IT_PINT6 = 0x40,
    PINT_IT_PINT7 = 0x80,
    PINT_IT_PINTAll = 0xFF,
} PINT_TYPE_IT;

/* PINTʹܿ */
#define PINT0_Enable() (GPIO->PINTIE.PINTIE |= 0X1)
#define PINT1_Enable() (GPIO->PINTIE.PINTIE |= 0x2)
#define PINT2_Enable() (GPIO->PINTIE.PINTIE |= 0x4)
#define PINT3_Enable() (GPIO->PINTIE.PINTIE |= 0x8)
#define PINT4_Enable() (GPIO->PINTIE.PINTIE |= 0x10)
#define PINT5_Enable() (GPIO->PINTIE.PINTIE |= 0x20)
#define PINT6_Enable() (GPIO->PINTIE.PINTIE |= 0x40)
#define PINT7_Enable() (GPIO->PINTIE.PINTIE |= 0x80)
#define PINT0_Disable() (GPIO->PINTIE.PINTIE &= ~0x01)
#define PINT1_Disable() (GPIO->PINTIE.PINTIE &= ~0x02)
#define PINT2_Disable() (GPIO->PINTIE.PINTIE &= ~0x04)
#define PINT3_Disable() (GPIO->PINTIE.PINTIE &= ~0x08)
#define PINT4_Disable() (GPIO->PINTIE.PINTIE &= ~0x10)
#define PINT5_Disable() (GPIO->PINTIE.PINTIE &= ~0x20)
#define PINT6_Disable() (GPIO->PINTIE.PINTIE &= ~0x40)
#define PINT7_Disable() (GPIO->PINTIE.PINTIE &= ~0x80)

/* PINTʹܿ */
#define PINT0_MaskEnable()   (GPIO->PINTIE.PMASK |= 0X01)
#define PINT1_MaskEnable()   (GPIO->PINTIE.PMASK |= 0x02)
#define PINT2_MaskEnable()   (GPIO->PINTIE.PMASK |= 0x04)
#define PINT3_MaskEnable()   (GPIO->PINTIE.PMASK |= 0x08)
#define PINT4_MaskEnable()   (GPIO->PINTIE.PMASK |= 0x10)
#define PINT5_MaskEnable()   (GPIO->PINTIE.PMASK |= 0x20)
#define PINT6_MaskEnable()   (GPIO->PINTIE.PMASK |= 0x40)
#define PINT7_MaskEnable()   (GPIO->PINTIE.PMASK |= 0x80)
#define PINT0_MaskDisable()  (GPIO->PINTIE.PMASK &= ~0x01)
#define PINT1_MaskDisable()  (GPIO->PINTIE.PMASK &= ~0x02)
#define PINT2_MaskDisable()  (GPIO->PINTIE.PMASK &= ~0x04)
#define PINT3_MaskDisable()  (GPIO->PINTIE.PMASK &= ~0x08)
#define PINT4_MaskDisable()  (GPIO->PINTIE.PMASK &= ~0x10)
#define PINT5_MaskDisable()  (GPIO->PINTIE.PMASK &= ~0x20)
#define PINT6_MaskDisable()  (GPIO->PINTIE.PMASK &= ~0x40)
#define PINT7_MaskDisable()  (GPIO->PINTIE.PMASK &= ~0x80)

/* PINTжϱ */
#define PINT_ClearAllITPending() (GPIO->PIF.Word = (uint32_t)0xff)

void GPIO_Init(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx, GPIO_InitStruType *GPIO_InitStruct);
void GPIO_Write(GPIO_TYPE GPIOx, uint32_t Value);
uint32_t GPIO_Read(GPIO_TYPE GPIOx);
PinStatus GPIO_ReadBit(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx);
void GPIOA_SetBit(GPIO_TYPE_PIN PINx);
void GPIOA_ResetBit(GPIO_TYPE_PIN PINx);
void GPIOA_ToggleBit(GPIO_TYPE_PIN PINx);
void GPIOB_SetBit(GPIO_TYPE_PIN PINx);
void GPIOB_ResetBit(GPIO_TYPE_PIN PINx);
void GPIOB_ToggleBit(GPIO_TYPE_PIN PINx);
void GPIOA_SetDirection(GPIO_TYPE_PIN PINx, GPIO_TYPE_DIR Dir_Type);
void GPIOB_SetDirection(GPIO_TYPE_PIN PINx, GPIO_TYPE_DIR Dir_Type);
void PINT_Config(PINT_TYPE PINTx, PINT_TYPE_SEL SELx, PINT_TYPE_TRIG TRIGx);
void GPIO_SetSingalTypeFromPin(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx, GPIO_Pin_Signal GPIO_Signal);
void GPIO_SetDirRegFromPin(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx, GPIO_TYPE_DIR Dir);
void GPIO_SetODERegFromPin(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx, GPIO_ODE_Output ODE);
void GPIO_SetDSRegFromPin(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx, GPIO_TYPE_DS DS);
void GPIO_SetPUERegFromPin(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx, GPIO_PUE_Input PUE);
void GPIO_SetPDERegFromPin(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx, GPIO_PDE_Input PDE);
void GPIO_SetFuncxRegFromPin(GPIO_TYPE GPIOx, GPIO_TYPE_PIN PINx, GPIO_TYPE_FUNC Func);
FlagStatus PINT_GetITStatus(PINT_TYPE_IT PINT_Flag);
void PINT_ClearITPendingBit(PINT_TYPE_IT PINT_Flag);
void KINT_Init(GPIO_TYPE GPIOx, GPIO_TYPE_PIN Pin, KINT_InitSettingType *InitSet);
void KINT_ClearITFlag(GPIO_TYPE GPIOx, GPIO_TYPE_PIN Pin);
uint32_t KINT_GetITFlag(GPIO_TYPE GPIOx, GPIO_TYPE_PIN Pin);
void GPIO_TX0Config(UART_TYPE_TXPLV Plv, UART_TYPE_TX0PS Ps, UART_TYPE_TX0Sx TX0Sx);
void GPIO_TX1Config(UART_TYPE_TXPLV Plv, UART_TYPE_TX1PS Ps, UART_TYPE_TX1Sx TX1Sx);
void GPIO_TX2Config(UART_TYPE_TXPLV Plv, UART_TYPE_TX2PS Ps, UART_TYPE_TX2Sx TX2Sx);
void GPIO_TX3Config(UART_TYPE_TXPLV Plv, UART_TYPE_TX3PS Ps, UART_TYPE_TX3Sx TX3Sx);

#endif
