/***************************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ  system_ES8P508x.c
*  ߣ  Liut
*    V1.00
*  ڣ  2017/07/14
*    ⺯ļ
*  ע
           ѧϰʾʹãûֱôķջеκηΡ
***************************************************************/
#include "system_ES8P508x.h"
#include "ES8P508x.h"
#include "lib_config.h"
#include "lib_scu.h"
#include "lib_gpio.h"

uint32_t SystemCoreClock = 20000000;


/***************************************************************
SystemCoreClockUpdate
  ϵͳʱΪڲʱ20MHZͬʱSystemCoreClock
ֵ
ֵ
ֵ
***************************************************************/
void SystemCoreClockUpdate(void)
{
    uint32_t Prot_Temp;
    uint16_t Count = 0;
    SystemClockSelect(CLK_SEL_HRC);        //ѡϵͳʱΪHRCʱ
    PLLClock_Config(DISABLE, SCU_PLL_HRC, SCU_PLL_48M, ENABLE);   //PLLֹ
    Prot_Temp = SCU->PROT.PROT;

    if (Prot_Temp != 0)                                     //д
    {
        SCU->PROT.Word = 0x55AA6996; //
    }

    SCU->SCLKEN1.HRC_EN = 1;                                //ʹڲ20MHZ

    do
    {
        Count++;
    }
    while ((SCU->SCLKEN1.HRC_RDY == 0) && (Count != 0xFFF)); //ȴʱӿ

    if (Count == 0xFFF)
    {
        return ;
    }

    SCU->SCLKEN0.SYSCLK_DIV = 0;                            //ϵͳʱӺƵ1:1

    switch (SCU->SCLKEN0.CLK_SEL)
    {
        case 0:
            SystemCoreClock = 20000000;                     //HRC
            break;

        case 1:
            SystemCoreClock = 32000;                        //LRC
            break;

        default:
            break;
    }

    if (Prot_Temp != 0)                                     //д
    {
        SCU->PROT.Word = 0x00000000; //д
    }
}

/***************************************************************
SystemInit
  ϵͳʼʱ
ֵ
ֵ
ֵ
***************************************************************/
void SystemInit(void)
{
    SystemCoreClockUpdate();
}

/*************************END OF FILE**********************/
