#include	<hic.h>
#define	UART_TX_TRIS	PCT6
#define	UART_RX_TRIS	PCT7
//----------------------
volatile unsigned char twoSecondCounter = 0;		//2sʱ; T8P1Ϊ20msʱʱ
volatile unsigned char uartTxCount = 0;				//UARTֽ
volatile unsigned char uartRxCount = 0;				//UARTֽ
volatile unsigned char uartRxData[4] = {0,0,0,0};	//UARTջ
unsigned char uartTxData[4] = { 0x55,0xAA,0x5A,0xA5 };//UARTͻ


void Ram_Clr(void) //ramȫ
{
	__asm 
  { 
	CLR   IAAL;
	CLR   IAAH;
	CLR   IAD;
	INC   IAAL,1;
	JBS   PSW,C
	GOTO  $-3;
	INC   IAAH,1;
	JBS   IAAH,4
	GOTO  $-6;
  } 
}
/*==================================================================
жϷ
1UART RXжϣһݰΪ4ֽڣͨT8NļжǷΪݰͷֽڣԷݽմλ⣻T8N10msսյϸ֮ʱ10msΪսյһݰĵһֽڣ
2UART TXжϣֻҪжϵһݰ4ֽڣرTXжϣ
3T8P1ʱ20msжϣжϵʱ2sUART TXжϣʼһ4ֽݣ 
==================================================================*/
void isr(void) interrupt
{
	if ( RX1IE && RX1IF )
	{   								//UARTж
		uartRxData[uartRxCount] = RX1B;	//յݻ
		uartRxCount++;					//ջַһ
		T8N = 0;
		if(uartRxCount == 4)
		{								//4ֽ
			uartRxCount = 0;			//ջַ
			if( uartRxData[0]==0x55 && uartRxData[1]==0xAA && \
			uartRxData[2]==0x5A && uartRxData[3]==0xA5 )
			{
				PC5	^= 1;				//ȷPC5˿ȡ
			}
			uartRxData[0] = 0;			//ݻ
			uartRxData[1] = 0;
			uartRxData[2] = 0;
			uartRxData[3] = 0;
		} 
	}
	if ( TX1IE && TX1IF ) 
	{ 									//UARTж
		TX1B	= uartTxData[uartTxCount];	//ѷͻǰַݷ뷢ͼĴ
		uartTxCount++;					//ͻַһ
		if(uartTxCount == 4)
		{
			TX1IE = 0;					//4ֽں󣬹رUARTж
			uartTxCount = 0;			//㷢ͻַ
		}
	}
	if (T8P1IE && T8P1IF) 
	{									//T8P1ʱж
		T8P1IF = 0;
		twoSecondCounter++;
		if(twoSecondCounter == 100 )
		{
			twoSecondCounter = 0;		//2sʱʱ䵽UARTķж
			uartTxCount	= 0;			//㷢ͻַ
			TX1IF = 1;					//UARTͱ־
			TX1IE = 1;					//ʹUARTжϣ뷢жϷ
		}
	}
}
/*==================================================================

==================================================================*/
void main(void)
{
	Ram_Clr();
	//----------ϵͳʱӳʼ------------
	OSCC = 0x50;		//ϵͳʱΪڲ4MHz
	//--------------I/Oʼ----------------
	
	PCT5 = 0;			//PC6˿Ϊ
	//-------------T8P1ʼ--------------
	T8P1P = 249;		//T8P1PڼĴֵ
	T8P1C = 0x27;		//T8P1ԤƵ1:16,ͺƵ1:5,T8P1
	//--------------T8Nʼ--------------
	T8NC = 0x87;     	//ԤƵT8NƵ1:256
	T8N	= 0;			//T8NĴֵ
	//-------------UARTʼ--------------
	UART_TX_TRIS = 0;	//UART TX˿Ϊ
	UART_RX_TRIS = 1;	//UART RX˿Ϊ
	TX1M = 0;			//UARTģʽΪ8λݸʽ
	BRGH1 = 1;			//UARTΪģʽ
	BR1R = 207;			//UARTΪ1200bps
	RX1EN = 1;			//ʹUART
	TX1EN = 1;			//ʹUART
	//----------------жʹ----------------
	T8P1IF = 0;			//T8P1ʱжϱ־
	T8P1IE = 1;			//ʹT8P1ʱж
	TX1IE = 0;			//ֹUARTж
	RX1IF = 0;			//UARTжϱ־
	RX1IE = 1;			//ʹUARTж
	INTG = 0x00;		//Ĭжģʽжڵַ0x004
	GIE  = 1;			//ʹȫж
	while(1)
	{
		if(T8N > 39)
		{
			/*==================================================================
			յһ֮ʱ40256=10msΪǴһݵĵһֽڣռ㣬ͬʱֽڽ֮ļʱT8N
			==================================================================*/
			uartRxCount	= 0;
			T8N		= 0;
		}
	}
}