/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  flash.c
*  :  LuF
*  :  V1.10
*  :  2017/10/20
*  :  Flash IAP
          1.7P295xڲ17KֽFLASH洢34ҳÿҳ512ֽڣֲ֧дַΧΪ0000H~43FFH
          2.λIAPENʹʱES7P295xĳ洢ԽвдͶȡķʲĳַѾдݣ
            дĵַǰҪԤȶԸõַҳв
	      3.ָͨFRAָĵַԪеһֶROMDС
          4.FLASHдΪλдǰȲдԪڵҳдFLASHʱݱݣ
            ҳֱ̡
	      5.оƬҳʱΪ2msڼоƬͣ״̬
	      6.FLASH洢/дǰоƬʹFRENλ
	      7.ûִҳʱرWDTڲRCʱӣִвʱŹλоƬ
	      8.Flash洢ĿɿԲAN062_Ӧñʼ_MCUƬڷʧԴ洢
          עֵѹΪ֤ûѹֵʱflashдִߵʱͨöϵʽ
              ۲󡣱ѽֵѹεûҪߵԸflashд󣬿ȡֵѹ
              ΣIDesignerе<_ѹ>ѡʹá
*  ע:  ES7P295x
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

void RAMClear(void);	
void FlashWriteData(void);	      //Flashд
void FlashReadData(void) ;	      //Flash
unsigned char FlashErasePage();	  //Flashҳ128ֽ/ҳ	
unsigned int RamBuff[16];         //Ram16

unsigned char IAP_failure;

union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashAddr;                       //Flashַ

union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashData;                       //Flashݱ

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/ 
void isr(void) interrupt
{
    if ( IAPIE && IAPIF  ) 
	{ 	
    	IAPIF = 0;                      //жϱ־
        if(PRGS_ERR || ERSS_ERR)
        {
            IAP_failure = 1; 
        }	    
	}
}

/*********************************************************
:	void main()
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{
	unsigned char i;
     	
    RAMClear();							//RAM

    //LVDEN = 1;
    //LVDCH = 0x90;                     //ֵѹ4.7V

    FlashAddr.Word = 0x1E00;            //ʼַ   
    for(i=0;i<16;i++)
    {
        FlashReadData();                //Flash 
        RamBuff[i] = FlashData.Word;    //ݵǰRam
        FlashAddr.Word++;      
    }    

    FlashAddr.Word = 0x0A00;            //ʼַ 
    FlashErasePage();                   //ҳFlash

    for (i=0;i<16;i++)
    {
        RamBuff[i] = i;					//޸Ramǰ16ֽ
    }       
    
    FlashAddr.Word = 0x0A00;            //ʼַ  
    for(i=0;i<16;i++)
    {
        FlashData.Word = RamBuff[i];
        FlashWriteData();               //дFlash  
        FlashAddr.Word++;        
    }    

    for (i=0;i<16;i++)
    {
        RamBuff[i] = 0;                 //޸Ram
    }     
    
    FlashAddr.Word = 0x0A00;            //ʼַ 
    for(i=0;i<16;i++)
    {
        FlashReadData();                //ٴζFlash 
        RamBuff[i] = FlashData.Word;    //Ƿд
        FlashAddr.Word++;      
    }


    while(1);

}

/*********************************************************
:	void FlashWriteData(void)
  :	Flashд
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void FlashWriteData(void)
{		
	unsigned char gie_bk = GIE;

	__asm{CWDT};		//幷
        
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

    FRAH=FlashAddr.Byte[1];     //дʼַ
    FRAL=FlashAddr.Byte[0];

    FRAHN = ~FRAH;
    FRALN = ~FRAL;

    ROMDH=FlashData.Byte[1];    //д
    ROMDL=FlashData.Byte[0];

    ROMDHN=~ROMDH;              //д
    ROMDLN=~ROMDL;

    TOEN = 1;			//ʹTimeoutʱ
    IAPIE = 1;          //IAPжʹ
    IAPCLR = 1;			//IAP״̬

	IAPUL = 0xA5;		//

	IAPPRGS = 0xD5;		//д
    __Asm NOP;
 
	while(!IAP_DONE)	//ȴ
    {
        if(IAP_LVDIF || PRGS_ERR)break;
    }

	IAPUL = 0x00;		//
    WDTUL = 0xA5;
    SWDTEN = 1;

	GIE = gie_bk;			//ȫж
}

/*********************************************************
:	void FlashReadData(void) 
  :	Flash
ֵ: 
ֵ: bufݻ
ֵ: 
**********************************************************/
void FlashReadData(void) 
{ 
	unsigned char gie_bk = GIE;

	__asm{CWDT};		//幷
	
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

    FRAH = FlashAddr.Byte[1];    //öʼַ
    FRAL = FlashAddr.Byte[0];

	__Asm TBR;		             //

    FlashData.Byte[1] = ROMDH;
    FlashData.Byte[0] = ROMDL;

	GIE = gie_bk;			//ȫж
}

/*********************************************************
:	uchar FlashErasePage(void)
  :	Flash
ֵ: 
ֵ: 
ֵ: 0TRUE
		1FALSE 
**********************************************************/
unsigned char FlashErasePage(void)
{
	unsigned char gie_bk = GIE;

	__asm{CWDT};		//幷
	
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

    FRAH = FlashAddr.Byte[1];
    FRAL = FlashAddr.Byte[0];

    FRAHN = ~FRAH;
    
    TOEN = 1;			//ʹTimeoutʱ
    
    IAPIE = 1;          //ʹIAPж
    IAPCLR = 1;			//IAP״̬


    IAPUL = 0xA5;       //IAP
    IAPERSS = 0xAE;		//

    while(!IAP_DONE)	//ȴ
    {
        if(IAP_LVDIF || ERSS_ERR)break;
    }
    
    IAPUL = 0x00;		//

    WDTUL = 0xA5;
    SWDTEN = 1;
    IAPIE = 0;          //ж

	GIE = gie_bk;			//ȫж
}

/********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm{				//ַ0x0000~0x05FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		MOVI 0x06
		SUB  IAAH,0
		JBS	 PSW,C	
		GOTO $-8
	}
}
