/*********************************************************
*Copyright (C), 2015-2016, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	rw_flash.c
*  :	Wangk/Linford
*  :	V1.01
*  :	2016/01/06
*  :	Bootloader demo 
*  ע:    HR7P275
			ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include  <hic.h>
#include  <string.h>
#include  "typedef.h"
#include  "macrodef.h"
#include  "rw_flash.h"

u8 check_empty(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
        *buf_Addr = Read_SingleWord(word_addr);
		*(buf_Addr+1) = Read_SingleWord(word_addr)>>8;
		if(*buf_Addr != 0xFF || *(buf_Addr+1) != 0xFF)
		{
			return  FAILED;
		}
        ++word_addr;
    }
    return  SUCCESS;
}

/***************һword FLASH***********************
    Read_SingleWord
  һword FLASH
  FLASH ֵַ
ֵ  
***********************************************************/
u16 Read_SingleWord(u16  addr)
{
    FRAL = addr;
    FRAH = addr >> 8;
    __Asm  TBR;
    return(((u16)ROMDH << 8) + ROMDL);
}

/*********************Flash***********************
    Read_Cont
  Flash
  Flashֵַݴ洢RAMָ룬Ҫֽ(Ϊż)
ֵ
***********************************************************/
u8 Read_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
        *buf_Addr = Read_SingleWord(word_addr);
		*(++buf_Addr) = Read_SingleWord(word_addr)>>8;
        word_addr++;
        ++buf_Addr;
    }
    return  SUCCESS;
}

/***********************ҳ**************************
    Erase_Page
  ҳ
  ҳַ
ֵ
***********************************************************/
u8 Erase_Page(u16  page_addr)
{
	FRAL = page_addr & 0xFF;
    FRAH = (page_addr >> 8) & 0xFF;	//ַֽ
	FRALN = ~FRAL & 0xFF;
	FRAHN = ~FRAH & 0xFF;
	IAPCLR = 1;			//IAP״̬
	GIE=0;
	IAPUL = 0xA5;		//
	IAPERSS = 0xAE;		//
	__Asm NOP;
    while(!IAP_DONE)	//ȴ
    {
		;
        //if(IAP_LVDIF)
			//return FAILED;
    }
	IAPUL = 0x00;		//
	GIE=1;
	return SUCCESS;	
}

void Write_SingleWord(u16  addr, u16 word_dat)
{
    GIE = 0 ;
    FRAL = addr;		//ַֽ
    FRAH = addr >> 8;	//ַֽ
	FRALN = ~FRAL;
	FRAHN = ~FRAH;
    ROMDL = word_dat;	 //дFlashֽ
    ROMDH = word_dat >> 8; //
	ROMDHN=~ROMDH;         //д
    ROMDLN=~ROMDL;
	TOEN = 1;			//ʹTimeoutʱ
	IAPCLR = 1;			//IAP״̬
	IAPUL = 0xA5;		//
	IAPPRGS = 0xD5;		//д
    __Asm NOP;
	while(!IAP_DONE)	//ȴ
	{
		if(IAP_LVDIF)break;
	}
	IAPUL = 0x00;		//
	GIE = 1 ;
}
u8 Write_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
        Write_SingleWord(word_addr, *((u16 *)buf_Addr));
        word_addr++;
        buf_Addr += 2;
    }
    return  SUCCESS;
}
