/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	flash.c
*  :	XieYF
*  :	V1.10
*  :	2014/11/25
*  :	ڲFlashд
*  ע:    HR7P201
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

unsigned int RamBuff[16];   //Ram16

union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashAddr;                 //Flashַ
union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashData;                 //Flashݱ

void ReadFlash(void);       //Flash
void EraseFlash(void);      //Flash
void WriteFlash(void);      //Flashд



/*********************************************************
: void clear_ram(void)
  : RAMȫ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/  
void clear_ram(void) 
{
    __asm 
    { 
         CLR   IAAL;
         CLR   IAAH;
         CLR   IAD;
         INC   IAAL,1;
         JBS   PSW,C
         GOTO  $-3;
         INC   IAAH,1;
         JBS   IAAH,2
         GOTO  $-6;
    } 
}
//***********************************************************
//							
//***********************************************************
void main(void)
{
    unsigned char i;

	clear_ram();
    FlashAddr.Word = 0x4000;    //ʼַ   
    for(i=0;i<16;i++)
    {
        ReadFlash();            //Flash 
        RamBuff[i] = FlashData.Word;    //ݵǰRam
        FlashAddr.Word++;      
    }    

    FlashAddr.Word = 0x4000;    //ʼַ 
    EraseFlash();               //ҳFlash

    for (i=8;i<16;i++)
    {
        RamBuff[i] = i;         //޸Ram8ֽ
    }       
    
    FlashAddr.Word = 0x4000;    //ʼַ  
    for(i=0;i<16;i++)
    {
        FlashData.Word = RamBuff[i];
        WriteFlash();           //дFlash  
        FlashAddr.Word++;        
    }    

    for (i=0;i<16;i++)
    {
        RamBuff[i] = 0;         //޸Ram
    }     
    
    FlashAddr.Word = 0x4000;    //ʼַ 
    for(i=0;i<16;i++)
    {
        ReadFlash();            // ٴζFlash 
        RamBuff[i] = FlashData.Word;    //Ƿд
        FlashAddr.Word++;      
    }    
    
    while(1);
}

//***********************************************************
//						Flash
//***********************************************************
void ReadFlash(void)
{
	unsigned char gie_bk = GIE;

    while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

    FRAH = FlashAddr.Byte[1];   //öʼַ
    FRAL = FlashAddr.Byte[0];

    __asm
	{
        TBR                     //ȡݵROMDH/ROMDLĴ
    }
    FlashData.Byte[1] = ROMDH;
    FlashData.Byte[0] = ROMDL;

	GIE = gie_bk;			//ȫж
}

//***********************************************************
//						Flash
//***********************************************************
void EraseFlash(void)
{
	unsigned char gie_bk = GIE;

	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

    FRAH = FlashAddr.Byte[1];
    FRAL = FlashAddr.Byte[0];
    
    __asm
	{
        BSS ROMCL,FPEE		//ѡFlash
        BSS ROMCL,WREN		//ʹFlash
        MOVI 0x55
        MOVA ROMCH			//0x55д洢
        NOP					//8NOPָ
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        MOVI 0xAA
        MOVA ROMCH			//0xAAд洢
        NOP					//8NOPָ
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
		BSS ROMCL,WR		//  
		NOP
		NOP					//NOP
	    JBC ROMCL,WR		//жǷ־
        GOTO $-1			//ȴ
        BCC ROMCL,WREN     	//ֹFlash
    }

	GIE = gie_bk;			//ȫж
}
 
//***********************************************************
//						Flashд
//*********************************************************** 
void WriteFlash(void)
{
	unsigned char gie_bk = GIE;

	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

    FRAH=FlashAddr.Byte[1];		//дʼַ
    FRAL=FlashAddr.Byte[0];
    ROMDH=FlashData.Byte[1];    //д
    ROMDL=FlashData.Byte[0];
    __asm
	{
        BCC  ROMCL,FPEE		//ѡFlashд
        BSS  ROMCL,WREN		//ʹFlashд
        MOVI 0x55
        MOVA ROMCH			//0x55д洢
        NOP					//8NOPָ
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        MOVI 0xAA
        MOVA ROMCH			//0xAAд洢
        NOP					//8NOPָ
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        BSS ROMCL,WR		//д  
		NOP
		NOP					//NOP
        JBC ROMCL,WR		//жǷд־
        GOTO $-1			//ȴд
	   	BCC ROMCL,WREN     	//ֹFlashд
    }

	GIE = gie_bk;			//ȫж
}
  