/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	flash.c
*  :	XieYF
*  :	V1.0
*  :	2015/6/2
*  :	ڲflash
*  ע:    HR7P275
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "flash.h"

/*********************************************************
:	void FlashWriteData(uint addr, uchar *buf, uchar n)
  :	Flashдݣֽڱ
ֵ: addrַ
		bufݻ
		nݸ
ֵ: 
ֵ: 
**********************************************************/
void FlashWriteData(uint addr, uchar *buf, uchar n)
{
	uchar i;

	for (i=0; i<n; i++) 
	{  		
		FRAL = addr;		//ַֽ
		FRAH = addr >> 8;	//ַֽ
		ROMDL = *buf;		//дFlashֽ
		ROMDH = 0x00;		//Ը7λ
//		IAPCL = 0xC0;		//ѡFlash̲
		while(GIE == 1)     //ȫж
        {
            GIE = 0;
        }

		__asm				//д
		{	
begin:
			MOVI 0x55
			MOVA IAPCH
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP				//8NOP
 			MOVI 0xAA
			MOVA IAPCH
 			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP					//8NOP
			BSS	IAPCL, IAPGO	//FLASH IAP̲
			NOP
			goto begin
			JBC	IAPCL, IAPGO	//ȱ̽
			GOTO $-1
			
		}
	//	GIE = 1;				//ȫж
		addr++;
		buf++;
	}
}

/*********************************************************
:	void FlashReadData(uint addr, uchar *buf, uchar n) 
  :	Flashݣֽڶ
ֵ: addrַ
		nݸ
ֵ: bufݻ
ֵ: 
**********************************************************/
void FlashReadData(uint addr, uchar *buf, uchar n) 
{
	uchar i;
	FRAL = addr;			//ַֽ
	FRAH = addr >> 8;		//ַֽ
	for (i=0; i<n; i++) 
	{  
		__asm {TBR#1}		//򻺳FRA+1
		*buf = ROMDL;		//
		buf++;
		addr++;
	}
}

/*********************************************************
:	uchar FlashErasePage(uint addr)
  :	Flashҳ0xFF,512/ҳ
ֵ: 
ֵ: 
ֵ: 0TRUE
		1FALSE 
**********************************************************/
uchar FlashErasePage(uint addr)
{
	uchar i;
	if(addr < START_ADDR)	//FlashʼдַǷЧ
		return FALSE;
	FRAH = addr >> 8;		//ַֽ
	IAPCL = 0xE0;			//ѡFlash
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }
	//LRCEN = 0;			//LRCʱӣWDTֹͣλ
	__asm
	{	
		MOVI		0x55
        MOVA		IAPCH
        NOP
		NOP
		NOP		
		NOP
		NOP
		NOP	
		NOP
		NOP	         //8NOPָȴ8ָ
        MOVI		0xAA
        MOVA		IAPCH
        NOP
		NOP
		NOP		
		NOP
		NOP
		NOP	
		NOP
		NOP	         //8NOPָȴ8ָ
        BSS	IAPCL, IAPGO	//FLASH IAP
        NOP					//CPUͣ״ֱ̬ɺCPUָ
	}
	//LRCEN = 1;			//LRCʱӣWDTָWDTEN=1
	GIE = 1;			//ȫж
	return TRUE;
}
