/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	eeprom.c
*  :	XieYF
*  :	V1.0
*  :	2015/6/2
*  :	ڲeeprom
*  ע:    HR7P275
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "eeprom.h"

/*********************************************************
: void EEPROMWritePageData(uint page_addr, uint addr_offset, uchar *buf, uchar n)
  :	EEPROMҳУдݣҳֽڱ
ֵ: page_addrҳʼַ
		addr_offsetҳƫƵַ,0<=addr_offset<=15
		bufݻ
		nݸn<=16-addr_offset
ֵ: 
ֵ: 01дɹ, 0xFE00~0xFFFFдʧַܵ
**********************************************************/
uint EEPROMWritePageData(uint page_addr, uint addr_offset, uchar *buf, uchar n)
{
	uchar i, err_flag, err_cnt;	
	uchar rbuf_1[16], rbuf_2[16];
	uint aim_addr,err_addr;
	if(((page_addr-0xFE00)%0x10!=0)||(addr_offset>15)||(n>16-addr_offset)){
		return 0;
	}
	EEPROMReadData(page_addr, rbuf_1, 16);					//16ֽ
	for(i=0;i<n;i++){
		rbuf_1[i+addr_offset]=*(buf+i);
	}
	aim_addr=page_addr+addr_offset;
	EEPROMWriteData(aim_addr, buf, n);					//дnֽ
	EEPROMReadData(page_addr, rbuf_2, 16);					//16ֽ
	err_cnt=0;
	do{		
		for(i=0;i<16;i++){
			if(rbuf_2[i]!=rbuf_1[i]){
				err_flag=1;
				err_cnt++;
				if(err_cnt>32){
				err_addr=page_addr+i;
				return err_addr;
				}
				EEPROMWriteData(page_addr, rbuf_1, 16);		//д16EEPROM
				EEPROMReadData(page_addr, rbuf_2, 16);		//16ֽ
				break;
			}
			else{
				err_flag=0;
			}
		}
	}
	while(err_flag);
	return 1;
}

void EEPROMWriteData(uint addr, uchar *buf, uchar n) 				//ע⣺û򲻿ֱӵô˳
{
	uchar i;

	for (i=0; i<n; i++) 
	{  			
		FRAL = addr;		//ַֽ
		FRAH = addr >>8;	//ַֽ
		ROMDL = *buf;		//дEEPROMֽ
		IAPIF = 0;		//IAPжϱ־
		IAPIE = 0;		//IAPжʹ
		ROMDH = 0x00;		//Ը7λ
		IAPCL = 0x80;		//ѡEEPROM̲
		HRCEN = 1;		//ʹڲپ
		while(!HRCON);		//ȴڲپȶ
		while(GIE == 1)     //ȫж
        {
            GIE = 0;
        }
		__asm			//д
		{		
			MOVI 0x55
			MOVA IAPCH
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP			//8NOP
 			MOVI 0xAA
			MOVA IAPCH
 			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP			//8NOP
			BSS	IAPCL, IAPGO	//EEPROM IAP̲
			NOP
			JBC IAPCL,IAPGO		//ȴд
			GOTO $-1
		}
		GIE = 1;			//ȫж
		HRCEN = 0;			//رڲپ
		addr++;
		buf++;
	}
}

/*********************************************************
:	void EEPROMReadData(uint addr, uchar *buf, uchar n) 
  :	EEPROMݣֽڶ
ֵ: addrַ
		nݸ
ֵ: bufݻ
ֵ: 
**********************************************************/
void EEPROMReadData(uint addr, uchar *buf, uchar n) 
{
	uchar i;

	for (i=0; i<n; i++) 
	{  
		FRAL = addr;			//ַֽ
		FRAH = addr >> 8;		//ַֽ
		HRCEN = 1;			//ʹڲپ
		while(!HRCON);			//ȴڲپȶ
		__asm 
		{
			TBR			//򻺳
 			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
		}	
		*buf = ROMDL;			//
		HRCEN = 0;			//رڲپ
		addr++;
		buf++;
	}
}

