/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tkm_config.c
*  :	Flynn Yin
*  :	V2.80 
*  :	2020/1
*  :	ó
*  ע:    ESD-SFB-7P203
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "common.h"
#include "stdlib.h"
#include "string.h"
#include "main.h"
#include "tkm_config.h"

/*ulong pow_ulong(uchar i)
{
	return ((ulong)1<<i);
}*/

const unsigned int pow_ulong[] = {1<<0, 1<<1, 1<<2, 1<<3, 1<<4, 1<<5, 1<<6, 1<<7, 1<<8, 1<<9, 1<<10, 1<<11};

const uchar Channel_table[TK_NUM]=     // Channel table for use as tk channel
{
 #if TK_NUM >0
 TK_Channel0
 #endif
 #if TK_NUM >1
 ,TK_Channel1
 #endif
 #if TK_NUM >2
 ,TK_Channel2
 #endif
 #if TK_NUM >3
 ,TK_Channel3
 #endif
 #if TK_NUM >4
 ,TK_Channel4
 #endif
 #if TK_NUM >5
 ,TK_Channel5
 #endif
 #if TK_NUM >6
 ,TK_Channel6
 #endif
 #if TK_NUM >7
 ,TK_Channel7
 #endif
 #if TK_NUM >8
 ,TK_Channel8
 #endif
 #if TK_NUM >9
 ,TK_Channel9
 #endif
 #if TK_NUM >10
 ,TK_Channel10
 #endif
 #if TK_NUM >11
 ,TK_Channel11
 #endif

};

const uint Threshold_table[TK_NUM]=    // Threshold table for tk channel
{
 #if TK_NUM >0
 TK_Threshold_Channel0
 #endif
 #if TK_NUM >1
 ,TK_Threshold_Channel1
 #endif
 #if TK_NUM >2
 ,TK_Threshold_Channel2
 #endif
 #if TK_NUM >3
 ,TK_Threshold_Channel3
 #endif
 #if TK_NUM >4
 ,TK_Threshold_Channel4
 #endif
 #if TK_NUM >5
 ,TK_Threshold_Channel5
 #endif
 #if TK_NUM >6
 ,TK_Threshold_Channel6
 #endif
 #if TK_NUM >7
 ,TK_Threshold_Channel7
 #endif
 #if TK_NUM >8
 ,TK_Threshold_Channel8
 #endif
 #if TK_NUM >9
 ,TK_Threshold_Channel9
 #endif
 #if TK_NUM >10
 ,TK_Threshold_Channel10
 #endif
 #if TK_NUM >11
 ,TK_Threshold_Channel11
 #endif
};

const uint Threshold_table_9_10[TK_NUM]= //Threshold * 9 / 10
{
 #if TK_NUM >0
 TK_Threshold_Channel0 * 9 / 10
 #endif
 #if TK_NUM >1
 ,TK_Threshold_Channel1 * 9 / 10
 #endif
 #if TK_NUM >2
 ,TK_Threshold_Channel2 * 9 / 10
 #endif
 #if TK_NUM >3
 ,TK_Threshold_Channel3 * 9 / 10
 #endif
 #if TK_NUM >4
 ,TK_Threshold_Channel4 * 9 / 10
 #endif
 #if TK_NUM >5
 ,TK_Threshold_Channel5 * 9 / 10
 #endif
 #if TK_NUM >6
 ,TK_Threshold_Channel6 * 9 / 10
 #endif
 #if TK_NUM >7
 ,TK_Threshold_Channel7 * 9 / 10
 #endif
 #if TK_NUM >8
 ,TK_Threshold_Channel8 * 9 / 10
 #endif
 #if TK_NUM >9
 ,TK_Threshold_Channel9 * 9 / 10
 #endif
 #if TK_NUM >10
 ,TK_Threshold_Channel10 * 9 / 10
 #endif
 #if TK_NUM >11
 ,TK_Threshold_Channel11 * 9 / 10
 #endif
};

#if (TK_UARToutput_function ==ON)||(TK_IICoutput_function ==ON)
uchar Cnt_Mask;
uchar g_com;				//
uchar g_length;				//ݳ
uchar g_rp;					//ָ
uchar g_tp;					//ָ
uchar g_checksum;			//У
uchar Tx_timer;
uchar UploadSampByte[(TK_NUM*2)+5];		//ֽ
//uchar UploadRawByte[(TK_NUM*2)+5];		//˲ֽ
//uchar UploadBaseByte[(TK_NUM*2)+5];		//ֽ
uchar UploadBuf[(TK_NUM*2)+5];	        //ͻ

#endif

const uchar DF_TK_Singlepress   =TK_Singlepress;
uint  Opr_state;
/*
Bit15  Scan Enable bit   1 on 0 off
Bit14  Tempdata is full  1 full 0 receive
Bit13  Jillter sample enable bit  1 Enable     0  Disable
Bit12  Once scan complete bit     1 complete   0  busy
Bit11  Slider bit    1 Slider was be touch 0 not be touch
Bit10  Wheel  bit    1 Wheel  was be touch 0 not be touch
Bit9   Matrix Row bit     1   was be touch 0 not be touch
Bit8   Matrix Column bit  1   was be touch 0 not be touch
Bit7   Mode bit  0  Mode default  1  Mode2  
Bit6   Mode switch start switching  if 1 else 0       
Bit5   Powersave flag setting if 1 else 0
Bit4
Bit3
Bit2
Bit1
Bit0
*/

uint  TK_value;             //Temp value after scan
uchar TK_value_get;         //Temp value flag after scan
uchar Timer_counter;        //Timer counter        
uchar Tkchnum;              //TK num
uchar Tkscan_sampcounter;   //Sample counter  1--TK_Samples_perscan

//TKValueStru TK_Value_Arr[TK_NUM];
section1 TKValueStru TK_Value_Arr[TK_NUM] @0x0080;

#if TK_Lowpowermode == ON
uint TK_md2value_origin;
uint TK_md2average_backup;
uint  TK_mode1_nopresstimer;
#endif

TKValueStru curr_tk_value;

uchar g_wakeup_flag;
uchar Lock_averageconter;
uint  TK_state;
uint  TK_state_bk;
uint  TK_state_single;
uint TK_Base_percounter;
uchar Timer_10ms;
uint  TK_jitter_Value;

void proc_curr_tk_value(uchar idx, uchar direct)
{
	char * ptr_d = (char *)&curr_tk_value;
	char * ptr_s = (char *)&TK_Value_Arr[idx];
	char * tmp = ptr_d;

	if (direct == 1)	//0:   1:д
	{
		ptr_d = ptr_s;
		ptr_s = tmp;
	}
	unsigned char i = 0;

	for (; i < sizeof(TKValueStru); i++)
	{
		*ptr_d++ = *ptr_s++;
	}

	//memcpy(ptr_d, ptr_s, sizeof(TKValueStru));
}

//#if (Jitter_Function == ON)

//uchar TK_Jitter_tolerance[TK_NUM]; 
//#endif
//uchar TK_reg_TKSELL = 0;
//uchar TK_reg_TKSELH = 0;
/*********************************************************
:	void TKInit(void)
  :	ʼӳ
ֵ: 
**********************************************************/
void TKInit(void )
{
	uchar i;
	//for(i = 0; i < TK_NUM; i++)
	//{
		//if((Channel_table[i] & 0x1F) < 8)
		//{
			//TK_reg_TKSELL |= (1<<(Channel_table[i] & 0x1F));
		//}
		//else
		//{
			//TK_reg_TKSELH |= (1<<((Channel_table[i] & 0x1F) -8));
		//}
	//}
	TKSELL = TK_reg_TKSELL;                 //
	TKSELH = TK_reg_TKSELH;
	PCT0   = 1;								// PC0 Must be Setinput 
	TKTUN  =TK_reg_TKTUN;					//ǿCxŵʱ512*Tosc;
											//Ƚ˲ʱ4*ToscֹܽģʽЧ
	#if TK_Guardsensor_output == ON 
		TKTUN  |= 0x02;
	#endif	 

    TKCCE  = 0;								//ݽֹ
	TKCTR  = 1;								//δɨ谴͵ƽʹ
	TKCTL1 = TK_reg_TKCTL1;					//ΪݵλΪֵʱۼӺͺȡƽ
											//1βѡͨѯ 
	TKFCTL = TK_reg_TKFCTL;					//1/2ռձȣŵ翪ƵFosc/4(4M)
											//طƵƵʱԴѡ16MƵֹ
	//#if Auto_Jitter_hradware == ON
		TKFCTL |= 0x01;
	//#endif

	TKMODL = 0xFF;		//÷ŴϵĴ24λ
	TKMODM = 0xFF;
	TKMODH = 0x0F;
	TKMODU = 0x00;		//Ŵϵ4λ=0
	VRC    = TK_reg_VRC1;						//VREF1=1.5VȽͽֹ
 
	Tkchnum			= TK_NUM;		
	//Tkscan_sampcounter	= 0;                // At Ramclear  clear to 0  
	Opr_state			= 0x8000;				// Enable scan
	//TK_state			= 0;                    // At Ramclear  clear to 0 
	//TK_Base_percounter	= 0;                // At Ramclear  clear to 0 

	//TKValueStru * ptr = &TK_Value_Arr;
	//i =0;
	//for(; ptr < TK_Value_Arr + TK_NUM; ptr++)  //Clear all 
	//{
		//memset(ptr, 0, sizeof(TKValueStru));
		//#if (Jitter_Function == ON)
			//TK_Jitter_tolerance[i]=0; 
			//i++;
		//#endif
	//}  
	//TK_value_get       =0;
	//Timer_10ms         =0;
	//Lock_averageconter =0;
    // Timer_counter =0; 
	#if TK_Lowpowermode == ON
		TK_mode1_nopresstimer = 0;
		Opr_state |= 0x0020;
		
//		uint value_temp;
		WDT_Clear();               // TK 幷ظ幷 õWDTʱ ֹطֱ幷

		 if( TK_Wdttimer_sleepsetting >=2048 ){ WDTC=0x0F;}
		 else if( TK_Wdttimer_sleepsetting >=2048 ){ WDTUL=0xA5; WDTC =0x1E;}
		 else if( TK_Wdttimer_sleepsetting >=1024 ){ WDTUL=0xA5; WDTC =0x1D;}
		 else if( TK_Wdttimer_sleepsetting >=512 ) { WDTUL=0xA5; WDTC =0x1C;}
		 else if( TK_Wdttimer_sleepsetting >=256 ) { WDTUL=0xA5; WDTC =0x1B;}
		 else if( TK_Wdttimer_sleepsetting >=128 ) { WDTUL=0xA5; WDTC =0x1A;}
		 else if( TK_Wdttimer_sleepsetting >=64 )  { WDTUL=0xA5; WDTC =0x19;}
		 else if( TK_Wdttimer_sleepsetting >=8 )   { WDTUL=0xA5; WDTC =0x18;}
	#endif
}

#if TK_Lowpowermode ==ON
/*********************************************************
:	void SleepMode(void)
  :	˯ģʽŹڻ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void SleepMode(void)
{
	//رʹģ鼰жʹ
	GIE = 0;        //رжʹ
	T10EN = 0;		//رT10	
	T10IE = 0;
	TKEN = 0;		//رTK
	TKIE = 0;
	TX0EN = 0;		//رUART-TX0
	TX0IE = 0;
	RX0EN = 0;		//رUART-RX0 
	RX0IE = 0;
	//ùܽŷ״̬ƽ  
	PAT = 0x00;		
	PBT = 0x00;		
	PCT = 0x00;
	PET = 0x00;
	
	//PA7 = 0;
	//PB = 0x30;
	//PC0 =1;
	//PC1 = 1;
	//PE = 0x3F;
	
	PA = 0;
	PB = 0x37;
	PC0 =0;
	PC1 = 1;
	PE = 0x80;

	//رϵͳģʱ	
	OSCWP = 0x55;
	HRCEN = 0;
	OSCWP = 0x5A;
	CLKG = 0;
	WDTUL = 0xA5;
	WDTC  = 0x1B;//ŹʱӣԤƵ13232*8ms = 256ms

	sleep();		//sleep

	//Ѻִмɨ
	WDTUL = 0xA5;
	WDTC  = 0x00;//رտŹʱ

	OSCWP = 0x55;
	HRCEN = 1;
	//LRCEN = 0;
	while(!HRCON){} //ȴHRC״̬λ
	SCKS  = 0;		//ϵͳʱлѡλ
	//OSCC1 = 0x00; //HRCʱԴ16M  1:1Ƶ
	//while(CHG){}
	OSCWP = 0x5A;

    //T10CE = 1;
	TKCE = 1;
	TKEN = 1;
	//GIE  = 1;

}

/*********************************************************
:	void TKStandby(void)
  :	TK˯ɨӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
uchar TK_Sleep_cnt;
void TKStandby(void)
{
//	uchar i;
	uchar TK_data_flag = 0;
	WDT_Clear();               // TK 幷ظ幷 õWDTʱ ֹطֱ幷

	SleepMode();
	TK_Sleep_cnt++;
	if(TK_Sleep_cnt < 250)
	{
		TKPE = 0;
	}
	else
	{
		TKPE = 1;
	}

	PCT0 = 1;
	
	TKGO = 1;
	while(!TK_data_flag) 
	{
		if(TKIF == 1)
		{
			TKIF = 0;
			if(((TKSDAH != 0)||(TKSDAL != 0))&& (!(TKOV||TKERR||SCANOV)))
			{
				PCT0 = 0;
				PC0  = 0;
				TK_data_flag = 1;
				break;
			}
			TKGO = 1;
		}				
	}	
	
	if(TK_data_flag == 1)
	{
		if(TKPE == 0)
		{	
			TK_md2value_origin = TKSDAH;
			TK_md2value_origin=TK_md2value_origin<<8;
			TK_md2value_origin  += TKSDAL;
			uint cmp1=0;
			uint cmp2 = 0;
			cmp1 = TK_md2value_origin;
			if(cmp1 != 0)
			{
				cmp2 = (uint)(TK_md2average_backup +TK_Sleep_Threshold);
				if(cmp1 > cmp2)
				{
					if(TK_md2average_backup == 0)
					{
						g_wakeup_flag = 0;
						TK_md2average_backup = cmp1;
					}
					else
					{
						g_wakeup_flag = 1;
						Customer_wakeupfromsleepmode_init();
					}
				}
				else
				{
			
					if(TK_Sleep_cnt % 10 == 0)
					{
						if(cmp1 < TK_md2average_backup)
						{
							TK_md2average_backup--;
						}
						if(cmp1 > TK_md2average_backup)
						{
							//TK_md2average_backup++;
							TK_md2average_backup = cmp1;
						}
					}
					//TK_md2average_backup = cmp1;
					g_wakeup_flag = 0;
			
				}
			}
		}
		else//˯ɨ»
		{
			uchar *ptr;
			uchar i;
			union {
						uchar dl[2];
						uint  data;
					}tkdata;
			for(i=0;i<TK_NUM;i++)
			{
				ptr = 0x604F;
				ptr += (Channel_table[i] & 0x1F)<<1;
				tkdata.dl[0] = *ptr;
				tkdata.dl[1] = *(ptr+1);
				TK_value	 = tkdata.data;
				//#if  Max_Minvalueoff_filter ==ON 
				TK_value *=TK_Samples_perscan -2;
				//#else
				//TK_value *=TK_Samples_perscan;
				//#endif
				TKValueStru * ptr	= &TK_Value_Arr[i];
				ptr->tk_value_filter = DataFilter(TK_value,ptr->tk_value_filter);
				ptr->tk_value_average = DataFilter(ptr->tk_value_filter,ptr->tk_value_average);
			}
			TK_Sleep_cnt = 0;
		}
	}

}
#endif


#if TK_IOoutput_NUM >0
void TK_IO_output(void)
{ 
    uchar i = 0;
	  ulong TK_state_temp;
	  #if TK_Singlepress==ON
	  TK_state_temp=TK_state_single;
	  #else
	  TK_state_temp=TK_state;
	  #endif
	                            //  pow_ulong[i]
	  #if TK_IOoutput_NUM >0
	  if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port0  =LED_On;}else { TK_IOoutput_port0=LED_Off;}i++;  
	  #endif
	  #if TK_IOoutput_NUM >1
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port1 =LED_On;}else { TK_IOoutput_port1=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >2
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port2 =LED_On;}else { TK_IOoutput_port2=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >3
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port3 =LED_On;}else { TK_IOoutput_port3=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >4
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port4 =LED_On;}else { TK_IOoutput_port4=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >5
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port5 =LED_On;}else { TK_IOoutput_port5=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >6
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port6 =LED_On;}else { TK_IOoutput_port6=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >7
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port7 =LED_On;}else { TK_IOoutput_port7=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >8
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port8 =LED_On;}else { TK_IOoutput_port8=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >9
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port9 =LED_On;}else { TK_IOoutput_port9=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >10
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port10 =LED_On;}else { TK_IOoutput_port10=LED_Off;}i++;
	  #endif
	  #if TK_IOoutput_NUM >11
	  if(TK_state_temp & ((uint)1<<i) ){ TK_IOoutput_port11 =LED_On;}else { TK_IOoutput_port11=LED_Off;}i++;
	  #endif	 	 
}
#endif


// Tk state machine
void Tk_service(void)
{
	uchar i;
	uchar Lock_average = 0;
	//const uint *p;
	if( Opr_state &0x4000)						// Data was full process it
	{          	
	    WDT_Clear();                       // 幷ʹô˺ õWDTʱ ֹطֱ幷 

		//#if  Max_Minvalueoff_filter ==ON   // Update the origin value  cut off the max and min value 															  
			uchar k;				
			uint Jitter =0;	                            // 							   
			for (k=0;k<TK_NUM;k++)
			{
				proc_curr_tk_value(k ,0);

				//TKValueStru * ptr		= &TK_Value_Arr[k];
				//ptr->tk_value_origin -=ptr->tk_value_max;
				//ptr->tk_value_origin -=ptr->tk_value_min;
				//Jitter +=ptr->tk_value_max -ptr->tk_value_min;
				uint sum = curr_tk_value.tk_value_max + curr_tk_value.tk_value_min;

				//curr_tk_value.tk_value_origin -=curr_tk_value.tk_value_max;
				//curr_tk_value.tk_value_origin -=curr_tk_value.tk_value_min;
				curr_tk_value.tk_value_origin -= sum;
				Jitter +=curr_tk_value.tk_value_max - curr_tk_value.tk_value_min;
				proc_curr_tk_value(k ,1);
			}
			TK_jitter_Value = Jitter;                     // Refresh  the jitter value
			if(Jitter >Jitter_level1_Threshold)
			{							 
				Lock_averageconter =68;
			}
		//#endif

        TK_Base_percounter++;					// Every come every ++  			   
        
		for (i=0;i<Tkchnum;i++)
	    { 
			uint pow_2 = pow_ulong[i];
			uint curr_Threshold = Threshold_table[i];
			uint curr_Threshold_9_10 = Threshold_table_9_10[i];
	     		
			//TKValueStru * ptr = &TK_Value_Arr[i];

			proc_curr_tk_value(i,0);

			#if  (TK_UARToutput_function ==ON)||(TK_IICoutput_function ==ON)			// Update the UART data  									      
				UploadSampByte[2*i]     =(uchar)(curr_tk_value.tk_value_origin>>8);
				UploadSampByte[(2*i)+1] =(uchar)(curr_tk_value.tk_value_origin);
				//UploadRawByte[2*i]      =(uchar)(ptr->tk_value_filter>>8);
				//UploadRawByte[(2*i)+1]  =(uchar)(ptr->tk_value_filter);
				//UploadBaseByte[2*i]     =(uchar)(ptr->tk_value_average>>8);
				//UploadBaseByte[(2*i)+1] =(uchar)(ptr->tk_value_average);		 
			#endif	
	       
			//ptr->tk_value_filter =DataFilter(ptr->tk_value_origin,ptr->tk_value_filter);	// Origin data   Update value data		 

		    if(curr_tk_value.tk_value_average)      //if not 0
			{
			 curr_tk_value.tk_value_filter =DataFilter(curr_tk_value.tk_value_origin,curr_tk_value.tk_value_filter);	// Origin data   Update value data	
			}
			else                          // if 0 do the get baseline process
			{
			 curr_tk_value.tk_value_filter	= curr_tk_value.tk_value_origin;
		     curr_tk_value.tk_value_average	= curr_tk_value.tk_value_origin;		  
			// ptr->tk_value_average	= ptr->tk_value_origin + Threshold_table[i];		 //if Noise First average double threshold 
			}

			if( curr_tk_value.tk_value_origin >( curr_tk_value.tk_value_average + curr_Threshold ) )      		 
			{		   		                                                  
				Lock_average =1;
		                                                       // This time not update average		 
			}	 	
			else 
			{
				Lock_average =0;
				 if((curr_tk_value.tk_press_table < TK_Debounce_press)||(TK_jitter_Value > Jitter_level2_Threshold))   // No key press  but at press conter state  (TK_state &((ulong)1<<i))==0
				 {					
					 curr_tk_value.tk_press_table =0;						// Clear press counter											
				 }

			 //#if Jitter_Function == ON
				 //if(ptr->tk_press_table &&(ptr->tk_press_table < TK_Debounce_press))       // No key press  but at press conter state  (TK_state &((ulong)1<<i))==0
				 //{
					//TK_Jitter_tolerance[i]++;
					//if(TK_Jitter_tolerance[i] >Jitter_tolerance)
					//{
						//ptr->tk_press_table =0;												// Clear press counter
						//TK_Jitter_tolerance[i] =0;
					//}
				 //}
				 //else 
				 //{
					//TK_Jitter_tolerance[i] =0;
				 //}
			 //#endif
			}
		/********************************************** Check Trigger *****************************************/	
		uchar Mucheck = 1;
		//#if TK_Mult_Function == ON
		#if  TK_Mult_inhibition >0
		if(Mult_inhibition((curr_tk_value.tk_value_filter - curr_tk_value.tk_value_average),TK_Mult_inhibition))
		{
			Mucheck = 1;
		}
		else
		{
			Mucheck = 0;
			Lock_average = 0;
			if(TK_state & (pow_2))
			{
				curr_tk_value.tk_release_table = TK_Debounce_release;
				TK_state &= ~pow_2;
				Customer_Keystatejustrelease();
				if(curr_tk_value.tk_timeout_counter != 0)
				{
					curr_tk_value.tk_timeout_counter = 0;
				}
				curr_tk_value.tk_D_value = 0;
			}
		}
		#endif
		if(( curr_tk_value.tk_value_filter > (curr_tk_value.tk_value_average+curr_Threshold)) && Mucheck )			
		{
			curr_tk_value.tk_press_table++;	
			#if TK_Lowpowermode == ON
			if(g_wakeup_flag == 2)
			{
				g_wakeup_flag = 1;//߽׶
				TKEN = 1;
				TKGO = 1;
			}		   
			#endif
			curr_tk_value.tk_release_table=0;			   
		    if( curr_tk_value.tk_press_table >TK_Debounce_press) 			
			{
				//#if Auto_Jitter_software == ON
				if(TK_jitter_Value < Jitter_level2_Threshold)
			    {
					curr_tk_value.tk_press_table = TK_Debounce_press;			 
					TK_state |= pow_2;                                              // Set trigger process	
					Customer_Keystatejustpress();
					if(curr_tk_value.tk_timeout_counter==0){curr_tk_value.tk_timeout_counter=1;}			  			 
					
					//#if  TK_Singlepress ==ON                                        // Save the Dlt value
						curr_tk_value.tk_D_value= curr_tk_value.tk_value_filter - curr_tk_value.tk_value_average ; // Save the Dlt value
					//#endif	
				}
				else
				{
					curr_tk_value.tk_press_table =0;                                         // Clear 
				}
				//#else
				//{
					//ptr->tk_press_table = TK_Debounce_press;			 
					//TK_state |= pow_2;                                              // Set trigger process	
					//Customer_Keystatejustpress();
					//if(ptr->tk_timeout_counter==0){ptr->tk_timeout_counter=1;}			  			 				
					
					////#if  TK_Singlepress ==ON                                        // Save the Dlt value
						//ptr->tk_D_value= ptr->tk_value_filter - ptr->tk_value_average ; // Save the Dlt value
					////#endif
				//}
				//#endif	
			 }
		}
		 else
		 {
			 curr_tk_value.tk_press_table=0;                             // Clear press counter	
			 //#if Jitter_Function == ON
			 //TK_Jitter_tolerance[i] =0;
			 //#endif		   
			 if(TK_state &(pow_2))                        // Already press prepare to release check
			 {			     
				  //if(curr_tk_value.tk_value_filter <( curr_tk_value.tk_value_average +(curr_Threshold*9)/10 ))
				   if(curr_tk_value.tk_value_filter <( curr_tk_value.tk_value_average +(curr_Threshold_9_10)))
				  {				
						curr_tk_value.tk_release_table++;					
						if(curr_tk_value.tk_release_table >TK_Debounce_release)     // Release check
						{
							curr_tk_value.tk_release_table =TK_Debounce_release;
							TK_state &= ~pow_2;//~((ulong)1<<i);                    // Clear this trigger bit process
							Customer_Keystatejustrelease();					   
							if(curr_tk_value.tk_timeout_counter!=0){curr_tk_value.tk_timeout_counter=0;}       // Close timer counter
						    #if  TK_Singlepress ==ON                                    // Save the Dlt value
								curr_tk_value.tk_D_value = 0;      // Save the Dlt value
						    #endif
						}				    
				  }
				  else
				  {
						curr_tk_value.tk_release_table=0;                                           // Clear the release counter
				  }
			  }
			 else if((Lock_average==0)&&(TK_Base_percounter >TK_BaseSamples_perscan)&&(Lock_averageconter==0))
			  {				 				  					    
				  //Update averagedata  ;	
				  curr_tk_value.tk_value_average = DataFilter(curr_tk_value.tk_value_filter,curr_tk_value.tk_value_average);			 	                       				 				 	                       
			  }
		   }
		/********************************************** Check Trigger *****************************************/
		 curr_tk_value.tk_value_origin =0;                                     // Clear the origin data 		 	 

		 proc_curr_tk_value(i,1);
	  }	 


	  if(TK_Base_percounter >(TK_BaseSamples_perscan +0)){TK_Base_percounter =0;} // For next every  TK_BaseSamples_perscan  sample update
	  Opr_state &=~0x4000;                             // Release this state
	  //Single key press check 
	  #if  TK_Singlepress ==ON      
	        if(TK_state)                                                          // Any key pressed
			{                                     
             Singlekeyprocess();                                                  // Get Single key press state
			}
			else
			{
			 TK_state_single=0;
			}
      #endif
	  
	  
	  #if TK_Lowpowermode == ON
	  if(TK_state)
	  {
		  TK_mode1_nopresstimer = 0;
	  }
	  #endif

	   Opr_state |=0x8000;                              // Enable the scan enable bit	
	   #if TK_Lowpowermode == ON
	   if(g_wakeup_flag == 2)
		{
			g_wakeup_flag = 0;//߽׶
		}
	   #endif				 
					  		  
	}

  		    
}
// Check the time flag 
void Timer_check(void)
{
	uchar i;
	if(Timer_10ms > 80) //125 *80 10ms
	{
		Timer_10ms =0; 

		#if TK_Lowpowermode == ON
			TK_mode1_nopresstimer++;       // Check switch to mode2 time
		#endif

		#if TK_UARToutput_function ==ON
			if(Tx_timer)
			{
				Tx_timer++;
				if( Tx_timer >125){ Tx_timer=0; g_tp = 0;}       //Tx send 1s timeout send Reset
			 }
		#endif
        Timer_counter++;
		if(Timer_counter >5)  //50ms time out re start check TK scan
		{		
			Timer_counter=0;				// Measure time	
			if( Opr_state &0x8000 )			// Scan Enable
			{
				TKEN = 0;					// For TK module reset
				TKGO  = 0;					//Ӧģر

				TKTUN  =TK_reg_TKTUN;		//ǿCxŵʱ512*Tosc;
											//Ƚ˲ʱ4*ToscֹܽģʽЧ
				#if TK_Guardsensor_output == ON 
					TKTUN  |= 0x02;
				#endif	
 
				TKCCE  = 0;								//ݽֹ
				TKCTR  = 1;								//δɨ谴͵ƽʹ
				TKCTL1 = TK_reg_TKCTL1;					//ΪݵλΪֵʱۼӺͺȡƽ
														//1βѡͨѯ 
				TKFCTL = TK_reg_TKFCTL;					//1/2ռձȣŵ翪ƵFosc/4(4M)
														//طƵƵʱԴѡ16MƵֹ
				//#if Auto_Jitter_hradware == ON
					TKFCTL |= 0x01;
				//#endif

				TKMODL = 0xFF;		//÷ŴϵĴ24λ
				TKMODM = 0xFF;
				TKMODH = 0x0F;
				TKMODU = 0x00;	//Ŵϵ4λ=0
				VRC    = TK_reg_VRC1;						//VREF1=1.5VȽͽֹ
					
				PCT0 = 1;					//When scan the PC0 must set input
				TKSELL = TK_reg_TKSELL;
				TKSELH = TK_reg_TKSELH;

				//TKIE = 1; 
				TK_value_get  =0;
				TKEN = 1;
				TKGO = 1;
		  }                
		}
		 
		if(Lock_averageconter>2)
		{
			Lock_averageconter--;
			if(Lock_averageconter<5){Lock_averageconter=0;}		 
		}
        
		for (i=0;i<Tkchnum;i++)                   // Press timeout check
		{
			//uint * ptr = &(TK_Value_Arr[i].tk_timeout_counter);// &TK_timeout_counter[i];
			proc_curr_tk_value(i,0);
			if (curr_tk_value.tk_timeout_counter == 0)                        // This num not press ignore
		    {
				continue;
		    }
			else
		    {
				curr_tk_value.tk_timeout_counter = curr_tk_value.tk_timeout_counter + 1;		     
				if (curr_tk_value.tk_timeout_counter >= TK_Press_timeout)        // Timeout force average and cancer the press state
				{
					curr_tk_value.tk_timeout_counter = 0;											   
					Force_average(i);                 // Do force average 								   
				}				
		    }
			proc_curr_tk_value(i,1);
		 }

	} //End of if(Timer_10ms >Timercounter_10ms) //125 *80 10ms
}
// Get the TK channel data
void Update_TKdata(void)
{
	uchar *ptr2;
	uchar i;
	union {
				uchar dl[2];
				uint  data;
			}tkdata;
	if(TK_value_get ==1)
	{
		
		for(i=0;i<TK_NUM;i++)
		{
			proc_curr_tk_value(i,0);
			ptr2 = 0x604F;
			uchar tmp = (Channel_table[i] & 0x1F);
			tmp <<= 1;
			ptr2 += tmp;
			//tkdata.dl[0] = *ptr2;
			//tkdata.dl[1] = *(ptr2+1);
			//tkdata.data = *((uint*)ptr2);
			TK_value	 = *((uint*)ptr2);

			//TKValueStru * ptr		= &TK_Value_Arr[i];
			curr_tk_value.tk_value_origin += TK_value;
		
			//#if  Max_Minvalueoff_filter ==ON  

				if(Tkscan_sampcounter ==0)                 //First value
				{
					curr_tk_value.tk_value_max =TK_value;
					curr_tk_value.tk_value_min =TK_value;
				}
				else if(TK_value >curr_tk_value.tk_value_max)
				{
					curr_tk_value.tk_value_max =TK_value;
				}		  
				else if(TK_value <curr_tk_value.tk_value_min)
				{
					curr_tk_value.tk_value_min =TK_value;
				}
			//#endif
			proc_curr_tk_value(i,1);
		}
			
		Tkscan_sampcounter++;
		if( Tkscan_sampcounter >=TK_Samples_perscan )
		{
			#if TK_Lowpowermode == ON
				if( TK_mode1_nopresstimer >TK_Mode0_nokeytoswitch_time )
				{
					g_wakeup_flag = 2;	//׼߽׶2							
					TK_mode1_nopresstimer=0;							 
				}			
			#endif
			
			Tkscan_sampcounter =0;
			Opr_state |=0x4000;                           // Set data is full let Tk_service process 
				
			//if(Opr_state &0x0010){TKIE =0;}				  // if at get baseline state	Clear the TKIE  					 
		}

	  if(Opr_state &0x4000)
	  {
		Opr_state &=~0x8000; // Clear the scan enable bit if data is full  wait data process  also have one data can be scan		
	  } 
	  
	  TK_value_get =2;   
      
	  //PCT0 = 1;				//When scan the PC0 must set input
	  //TKIF = 0;		
	  //if(g_wakeup_flag != 2)
	  //{
		 //TKEN = 1;
		 //TKGO = 1;
	  //}                               
	}
}
