/*********************************************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	main.c
*  :	Flynn Yin
*  :	V2.80 
*  :	2020/1
*  :	ʾ
*  ע:    ESD-SFB-7P201ESD-SFB-7P202ESD-TKT-7P203
			1ذ			
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************************************/
#include "stdlib.h"
#include "main.h"

#define  Colour_Maxvalue  0x3F

unsigned char button_1=0;
unsigned char button_2=0;
unsigned char button_3=0;
unsigned char off_flag=0;
uchar Colour_num;
uchar Red_data;
uchar Green_data;
uchar Blue_data;

/*********************************************************
:	void Control_LED(void)
  :	LEDƺ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Control_LED(void)
{
	ulong Temp_red;
	ulong Temp_green;
	ulong Temp_blue;
	ulong Temp_clour;
	Temp_clour =0;
	if((button_1)||(button_2)||(button_3))
	{
	    if( TK_state_bkp !=TK_state )
		{
		  off_flag =0;
		}
		TK_state_bkp =TK_state;

		if(!(off_flag))
		{
		     Temp_red   =Red_data;
			 Temp_green =Green_data;
			 Temp_blue  =Blue_data;

			if(button_1)
			 {
			  if(Red_data >5){Red_data--;}
			  else {Red_data =Colour_Maxvalue;}
			 }
			 else 
			 {
			  Temp_red =0;
			 }
			if(button_2)
			 {
			  if(Green_data >5){Green_data--;}
			  else {Green_data =Colour_Maxvalue;}
			 }
			else
			 {
			  Temp_green =0;
			 }
			if(button_3)
			{
			 if(Blue_data >5){Blue_data--;}
			 else {Blue_data =Colour_Maxvalue;}
			}
			else
			{
			 Temp_blue =0;
			}
			Temp_clour =Temp_green; 
			Temp_clour <<=16;
			Temp_clour |=Temp_red <<8;
			Temp_clour |=Temp_blue;

			//if(button_1)SetColor(0x7f0000);
			//if(button_2)SetColor(0x007f00);
			//if(button_3)SetColor(0x00007f);
			SetColor(Temp_clour);
			SetColor(Temp_clour);
			off_flag=1;
		}
	}
	else{
			if(off_flag)
			{
				//SetColor(0x000000); //No finger clear RGB
				off_flag=0;
			}	
	    }
}
/*********************************************************
:	void main()
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
 {	
	 RAMClear();		      // RAM All the parameter Clear
	 MCUInit();		          // MCUʼ Customer need change
	 PBT5 =0;
	 Delay100ms(1);
	 Timerinit();
	 TKInit();	   

	 it_vectors_init();
	 TKIF = 0;                // ж	 
	 GIE  = 1;	
	 
	 #if  TK_UARToutput_function ==ON
	 UARTInit();
	 #endif
	   SetColor(0x000000); // Clear all light
	   Colour_num =0;      // 
	   TK_state_bkp =0;

	   Red_data   =Colour_Maxvalue;
       Green_data =Colour_Maxvalue;
       Blue_data  =Colour_Maxvalue;
	  
	   //Red_data   =5;
       //Green_data =5;
       //Blue_data  =5;
	while(1)
    {		
		WDT_Clear();                           // 
		#if TK_Lowpowermode == ON
			if(g_wakeup_flag == 0)
			{			
			 TKStandby();	                   // sleep mode					
			}
			else
		#endif	
		  {
			Tk_service();
			Timer_check();                     // Check if 10ms tick
			Update_TKdata();                   // Update channel data
			 //TK_state                        // Check the TK_state parameter to do the application   TK_state bits if press 1 no press 0
		    #if TK_IOoutput_NUM >0
			TK_IO_output();
			Control_LED();
			#endif 
		  }
    }
}

/***********************************************************
:	void MCUInit(void) 
  :	ϵͳʼӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void MCUInit(void) 
{
    OSCWP = 0x55;
	HRCEN = 1;
	//LRCEN = 0;
	while(!HRCON){} //ȴHRC״̬λ
	SCKS  = 0;		//ϵͳʱлѡλ
	//OSCC1 = 0x00; //HRCʱԴ16M  1:1Ƶ
	while(CHG){}
	OSCWP = 0x5A;
    PES =0;		
	PAS =0;
	PBS =0;
	//PCS =0;//ֶ˿  PC0 Ϊģ

	#if TK_Lowpowermode == ON
		g_wakeup_flag = 1;
		TK_mode1_nopresstimer = 0;
		TK_md2value_origin    = 0;
		TK_md2average_backup  = 0;
	#endif

	 #if TK_IOoutput_NUM >0
	 TK_IOoutput_port0 =LED_Off;
	 TK_IOoutput_trise0=0;
	 #endif
	  #if TK_IOoutput_NUM >1
	 TK_IOoutput_port1 =LED_Off;
	 TK_IOoutput_trise1=0;
	 #endif
	 #if TK_IOoutput_NUM >2
	 TK_IOoutput_port2 =LED_Off;
	 TK_IOoutput_trise2=0;
	 #endif
	  #if TK_IOoutput_NUM >3
	 TK_IOoutput_port3 =LED_Off;
	 TK_IOoutput_trise3=0;
	  #endif
	  #if TK_IOoutput_NUM >4
	 TK_IOoutput_port4 =LED_Off;
	 TK_IOoutput_trise4=0;
	  #endif
	  #if TK_IOoutput_NUM >5
	 TK_IOoutput_port5 =LED_Off;
	 TK_IOoutput_trise5=0;
	 #endif
	  #if TK_IOoutput_NUM >6
	 TK_IOoutput_port6 =LED_Off;
	 TK_IOoutput_trise6=0;
	  #endif
	  #if TK_IOoutput_NUM >7
	 TK_IOoutput_port7 =LED_Off;
	 TK_IOoutput_trise7=0;
	  #endif
	  #if TK_IOoutput_NUM >8
	 TK_IOoutput_port8 =LED_Off;
	 TK_IOoutput_trise8=0;
	  #endif
	  #if TK_IOoutput_NUM >9
	 TK_IOoutput_port9 =LED_Off;
	 TK_IOoutput_trise9=0;
	  #endif
	  #if TK_IOoutput_NUM >10
	 TK_IOoutput_port10 =LED_Off;
	 TK_IOoutput_trise10=0;
	  #endif
      #if TK_IOoutput_NUM >11
	 TK_IOoutput_port11 =LED_Off;
	 TK_IOoutput_trise11=0;
	  #endif
}
/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
    GIE = 0;
    for(IAAH=0; IAAH<0x02; IAAH++)
    {
		for(IAAL=0; IAAL<0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		WDT_Clear(); 
    }
}

/*********************************************************
:	void Delay100ms(uint time)
  :	ʱӳ
ֵ: timeʱλ100ms
ֵ: 
ֵ:  
**********************************************************/
void Delay100ms(uchar time)
{
   uchar i, j, k;
	for (i=0; i<time; i++)
	{
		for (j=0; j<100; j++)			
		{
			for (k=0; k<249; k++)
			{
				nop();
				nop();
				//nop();
				//clr_wdt();
				WDT_Clear();    // 忴Ź
			}
		}
	}
}


/*********************************************************
void UARTInit(void)
  :	UARTʼӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
 #if  TK_UARToutput_function ==ON
void UARTInit(void)
{
	PBT4  = 0;	//UART_TXΪ	
	PBT5  = 1;	//UART_RXΪ
	PBPU5 = 1;

	#if TK_UARToutput_Databit ==8
	TX0LEN	= 0;	//8λݸʽ
	RX0LEN  = 0;
	#elif TK_UARToutput_Databit ==9
	TX0LEN	= 1;	//9λݸʽ
	RX0LEN  = 1;
	#endif
	BRGH0 = 1;	//ģʽ
	#if  TK_UARToutput_Baudrate ==115200
	BR0R	= 8;	//115200bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#elif TK_UARToutput_Baudrate ==57600
	BR0R	= 11;	//57600bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#elif TK_UARToutput_Baudrate ==38400
	BR0R	= 18;	//38400bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#elif TK_UARToutput_Baudrate ==19200
	BR0R	= 51;	//19200bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#elif TK_UARToutput_Baudrate ==9600
	BR0R	= 103;	//9600bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#elif TK_UARToutput_Baudrate ==4800
	BR0R	= 207;	//4800bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#endif
	RX0EN = 1;	//UARTʹ	
	RX0IE = 1;	//ʹUARTж

	TX0EN = 1;	//UARTʹ	
	TX0IE = 0;	//ֹUARTжϣҪʱʹ

	RX0IF = 0;
	TX0IF = 0;
	g_tp=0;
}
#endif
/*********************************************************
void Customer_Keystatejustpress(void)
  : ͨոռ⵽״̬
ֵ: 
ֵ: TK_state
ֵ:  
**********************************************************/
void Customer_Keystatejustpress(void)
{ //TK_state was just freshed  you can use the  parameter as you want

}

/*********************************************************
void Customer_Keystatejustrelease(void)
  : ͨոռ⵽ͷ
ֵ: 
ֵ: TK_state
ֵ:  
**********************************************************/
void Customer_Keystatejustrelease(void)
{ //TK_state was just freshed  you can use the  parameter as you want
 
}

/*********************************************************
void Customer_wakeupfromsleepmode_init(void)
  : Ѻĳʼ ָʱ״̬ʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Customer_wakeupfromsleepmode_init(void)
{
	#if TK_Lowpowermode == ON
	TK_md2average_backup  = 0;
	#endif
	CLKG = 0xEF;
	T10EN = 1;
	
	#if  TK_UARToutput_function ==ON
	 UARTInit();
	#endif 
	TKPE = 1;
	TKIF = 0;
	T10IE = 1;
	T10IF = 0;
	GIE  = 1;
	TKGO = 1;

	Red_data   =Colour_Maxvalue;
    Green_data =Colour_Maxvalue;
    Blue_data  =Colour_Maxvalue;
	off_flag =0;

}

