/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  sleep.c
*  :
*  :  V1.01
*  :  2018/03/26
*  :  ߺ
*  ע:  
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "sleep.h"

/***************************************************************
 void sleep(void)
   ߺ
 ֵ
 ֵ
 ֵ
***************************************************************/
void sleep(void)
{
    GPIO_InitSettingType y;
    KINT_InitSettingType z;
    __disable_irq(); //رIRQж
    WDT_Clear();  //幷
    DeviceClockAllEnable();

    GPIO->PAINEB.Word = 0XFFFFFFFF; //ر
    GPIO->PBINEB.Word = 0XFFFFFFFF;
    GPIO->PADIR.Word = 0X00000000;  //
    GPIO->PBDIR.Word = 0X00000000;
    GPIO->PADATA.Word = 0X00000040;  //PA6߹رLED1
    GPIO->PBDATA.Word = 0X00000080;  //PB7

    y.Signal = GPIO_Pin_Signal_Digital;
    y.Func = GPIO_Reuse_Func0;
    y.Dir = GPIO_Direction_Input;
    y.ODE = GPIO_ODE_Output_Disable;
    y.DS = GPIO_DS_Output_Normal;
    y.PUE = GPIO_PUE_Input_Enable;
    y.PDE = GPIO_PDE_Input_Disable;
    GPIO_Init(GPIO_Pin_A22, &y);


    z.IE_Set = KINT_IE_Set_Enable;
    z.Trigger_Style = KINT_Trigger_Trailing_Edge;
    KINT_Init(GPIO_Pin_A22, &z);                     //ʼж

    SCU_RegUnLock();
    SCU_LVDVS_4V();    //LVDѵѹ4V
    SCU_LVDIFS_Fall(); //LVDѹ߼
    SCU_LVDFLT_Enable(); //LVD˲ʹ
    SCU_LVD_Enable(); //LVDжʹ
    SCU->WAKEUPTIME.MOSC_EN = 0; //˯ʱԶر
    SCU->WAKEUPTIME.WAKEUPTIME = 20; //ʱ䲻С40us
    SCB_SystemLPConfig(SCB_LP_SleepDeep, Enable);  //˯ģʽ
    SCU_RegLock();


    WDT_RegUnLock();//WDTرд
    WDT_ITEnable(); //IEʹ

    NVIC_EnableIRQ(LVD_IRQn);  //ʹLVDԴ
    NVIC_EnableIRQ(WDT_IRQn);  //ʹWDTԴ
    NVIC_EnableIRQ(KINT_IRQn); //ʹܰ


    while (1) //ѭ
    {
        SCU_RegUnLock();
        SCU->SCLKEN0.SYSCLK_DIV = 5;// ϵͳʱӺƵ1:32 //ϵͳʱڲС2us
        NVIC->ICPR[0] = 0XFFFFFFFF; //NVICʶ
        __NOP();
        __NOP();
        __WFI(); //
        __NOP();
        __NOP();
        SCU->SCLKEN0.SYSCLK_DIV = 0;// ָϵͳʱӺƵ
        SCU_RegLock();


        if (WDT_GetFlagStatus() != RESET)
        {
            WDT_Clear();  //幷
            GPIO_ToggleBit(GPIO_Pin_A23);   //PA23ת
        }

        if (SCU_GetLVDFlagStatus(SCU_LVDFlag_IF) != RESET) //LVD
        {
            SCU_RegUnLock();
            SCU_LVDClearIFBit();
            SCU_RegLock();
            NVIC_SystemReset();   //λ
        }

        if (KINT_GetITFlag(GPIO_Pin_A22) != RESET)  //KINT
        {
            KINT_ClearITFlag(GPIO_Pin_A22);      // жϱ־λ
            GPIO_ToggleBit(GPIO_Pin_A23);   //PA23ת
            GPIO_ToggleBit(GPIO_Pin_A23);   //PA23ת
            GPIO_ToggleBit(GPIO_Pin_A23);   //PA23ת
            GPIO_ToggleBit(GPIO_Pin_A23);   //PA23ת
            GPIO_ToggleBit(GPIO_Pin_A23);   //PA23ת
            GPIO_ToggleBit(GPIO_Pin_A23);   //PA23ת
            GPIO_ToggleBit(GPIO_Pin_A23);   //PA23ת
        }
    }
}
