/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  timer.h
*  :  Liut
*  :  V1.01
*  :  2017/06/28
*  :  Timerģͷļ
*  ע:  
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "timer.h"

/*********************************************************
: void T16NxInit(void)
  : T16Nxʱʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T16NxInit(void)
{
    T16Nx_BaseInitStruType x;
    T16Nx_PWMInitStruType z;	
    GPIO_InitSettingType y;

    /* ʼT16Nxʱ*/
    x.T16Nx_ClkS = T16Nx_ClkS_PCLK;             //ⲿʱPCLK
    x.T16Nx_SYNC = Disable;
    x.T16Nx_EDGE = T16Nx_EDGE_Rise;
    x.T16Nx_Mode = T16Nx_Mode_PWM;              //PWMģʽ
    x.T16Nx_PREMAT = 80;                        //ԤƵΪ1:80
    T16Nx_BaseInit(T16N0, &x);                  //ʼʱT16N0

    /*T16N0ͨ0*/
    z.T16Nx_MOE0 = Enable;                      //ͨ0
    z.T16Nx_MOE1 = Enable;                      //ͨ1
    z.T16Nx_POL0 = POSITIVE;                    //
    z.T16Nx_POL1 = POSITIVE;                    //
    z.T16Nx_PWMMODE = T16Nx_PWMMode_INDEP;      //ģʽ
    z.PWMDZE = Disable;                         //رջģʽ
    T16Nx_PMWOutInit(T16N0, &z);

    T16Nx_MAT0ITConfig(T16N0, T16Nx_Clr_Int);   //CNT0ƥ䵽MAT0¼
    T16Nx_MAT1ITConfig(T16N0, T16Nx_Go_No);     //CNT0ƥ䵽MAT1
    T16Nx_MAT0Out0Config(T16N0, T16Nx_Out_High); //CNT0ƥ䵽MAT0˿
    T16Nx_MAT1Out0Config(T16N0, T16Nx_Out_Low); //CNT0ƥ䵽MAT1˿
    T16Nx_SetCNT0(T16N0, 0);                    //T16N0ʼֵΪ0
    T16Nx_SetMAT0(T16N0, 1000);                 //T16N0MAT0ֵΪ
    T16Nx_SetMAT1(T16N0, 500);                  //T16N0MAT1ֵΪռձ

    /*T16N0 ͨ1*/
    T16Nx_MAT2ITConfig(T16N0, T16Nx_Clr_Int);   //CNT1ƥ䵽MAT2¼
    T16Nx_MAT3ITConfig(T16N0, T16Nx_Go_No);     //CNT1ƥ䵽MAT3
    T16Nx_MAT2Out1Config(T16N0, T16Nx_Out_High); //CNT10ƥ䵽MAT0˿
    T16Nx_MAT3Out1Config(T16N0, T16Nx_Out_Low); //CNT1ƥ䵽MAT1˿
    T16Nx_SetCNT1(T16N0, 0);                    //T16N0ʼֵΪ0
    T16Nx_SetMAT2(T16N0, 1000);                 //T16N0MAT2ֵΪ
    T16Nx_SetMAT3(T16N0, 200);                  //T16N0MAT3ֵΪռձ

    T16Nx_SetTOP0(T16N0, 1000);                 //üֵĴ0
    T16Nx_SetTOP1(T16N0, 1000);                 //üֵĴ1
    T16Nx_PTR_Config(T16N0, T16Nx_P0MAT0, Enable); //PWMģʽADCʹ

    T16Nx_ITConfig(T16N0, T16Nx_IT_MAT0, Enable);
    NVIC_Init(NVIC_T16N0_IRQn, NVIC_Priority_1, Enable);
		
    /* ʼPWM*/
    y.Signal = GPIO_Pin_Signal_Digital;
    y.Dir = GPIO_Direction_Output;
    y.Func = GPIO_Reuse_Func2;
    y.ODE = GPIO_ODE_Output_Disable;
    y.DS = GPIO_DS_Output_Normal;
    y.PUE = GPIO_PUE_Input_Enable;
    y.PDE = GPIO_PDE_Input_Disable;
    GPIO_Init(GPIO_Pin_A6, &y);                 //PA6ΪT16N0 ͨ0
    GPIO_Init(GPIO_Pin_A7, &y);                 //PA7ΪT16N0 ͨ1

    T16Nx_Enable(T16N0);                        //ʹT16N0

    return;
}
/*********************************************************
: void T16N3Init(void)
  : T16N3ʱʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T16N3Init(void)
{
    T16Nx_BaseInitStruType x;

    x.T16Nx_ClkS = T16Nx_ClkS_PCLK;                     //ڲʱPCLK
    x.T16Nx_SYNC = Disable;
    x.T16Nx_EDGE = T16Nx_EDGE_Rise;
    x.T16Nx_Mode = T16Nx_Mode_TC0;                      //ʱģʽ
    x.T16Nx_PREMAT = 2;
    T16Nx_BaseInit(T16N3, &x);                          //ʼʱT16N3

    T16Nx_MAT0ITConfig(T16N3, T16Nx_Clr_Int);           //MAT0ƥ
    T16Nx_SetCNT0(T16N3, 0);                            //T16N3ʼֵΪ0
    T16Nx_SetMAT0(T16N3, SystemCoreClock / 1000);       //T16N3MAT0ֵ
    T16Nx_ITConfig(T16N3, T16Nx_IT_MAT0, Enable);       //ʹT16N3ƥ0ж
    NVIC_Init(NVIC_T16N3_IRQn, NVIC_Priority_1, Enable); //ж
    T16Nx_Enable(T16N3);

    return;
}

