/*********************************************************
 *Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
 *ļ:  lib_timer.c
 *  :  ESM Application Team
 *  :  V1.01
 *  :  2016/11/01
 *  :  Timerģ⺯
 *  ע:
 ѧϰʾʹãûֱôķջеκηΡ
 **********************************************************/
#include "lib_timer.h"


/***************************************************************
  T16Nx_BaseInit
    T16Nxʼ,ʼʱѡⲿʱͬⲿʱӼԵѡ񣬹ģʽ
  ֵT16NxT16N0/1/2/3 T16Nx_BaseInitStructʼýṹַ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_BaseInit(T16N_TypeDef *T16Nx, T16Nx_BaseInitStruType *T16Nx_BaseInitStruct)
{
  T16Nx->CON0.CS = T16Nx_BaseInitStruct->T16Nx_ClkS;     //ʱԴѡ
  T16Nx->CON0.SYNC = T16Nx_BaseInitStruct->T16Nx_SYNC;   //ⲿʱͬʹ  Disable:ͬⲿʱӣΪ첽ģʽEnableͨPCLKⲿʱͬΪͬģʽⲿʱӵĸߵ͵ƽƽٱ2ʱ
  T16Nx->CON0.EDGE = T16Nx_BaseInitStruct->T16Nx_EDGE;   //ⲿʱӼѡ
  T16Nx->CON0.MOD = T16Nx_BaseInitStruct->T16Nx_Mode;    //ģʽѡ
  T16Nx->PREMAT.PREMAT = T16Nx_BaseInitStruct->T16Nx_PREMAT - 1; //ԤƵãΧ1-256
}


/***************************************************************
  T16Nx_CapInit
    T16Nx׽ʼ
  ֵT16NxT16N0/1/2/3 T16Nx_CapInitStructʼýṹַ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_CapInit(T16N_TypeDef *T16Nx, T16Nx_CapInitStruType *T16Nx_CapInitStruct)
{

  T16Nx->CON1.CAPL0 = T16Nx_CapInitStruct->T16Nx_CAPCAPL0; //ò׽0ؼǷʹ
  T16Nx->CON1.CAPL1 = T16Nx_CapInitStruct->T16Nx_CAPCAPL1; //ò׽1ؼǷʹ
  T16Nx->CON1.CAPPE = T16Nx_CapInitStruct->T16Nx_CapRise;  //벶׽Ƿʹ
  T16Nx->CON1.CAPNE = T16Nx_CapInitStruct->T16Nx_CapFall;  //½벶׽Ƿʹ
  T16Nx->CON1.CAPIS0 = T16Nx_CapInitStruct->T16Nx_CapIS0;  //ò׽˿T16NxIN0Ƿʹ
  T16Nx->CON1.CAPIS1 = T16Nx_CapInitStruct->T16Nx_CapIS1;  //ò׽˿T16NxIN1Ƿʹ
  T16Nx->CON1.CAPT = T16Nx_CapInitStruct->T16Nx_CapTime;   //ò׽

}

/***************************************************************
  T16Nx_PMWOutInit
    T16NxPWMʼ
  ֵT16NxT16N0/1/2/3 T16Nx_PWMInitStructʼýṹַ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_PMWOutInit(T16N_TypeDef *T16Nx, T16Nx_PWMInitStruType *T16Nx_PWMInitStruct)
{
  T16Nx->CON2.MOE0 = T16Nx_PWMInitStruct->T16Nx_MOE0;           //˿0Ƿʹ
  T16Nx->CON2.MOE1 = T16Nx_PWMInitStruct->T16Nx_MOE1;           //˿1Ƿʹ
  T16Nx->CON2.POL0 = T16Nx_PWMInitStruct->T16Nx_POL0;           //T16NxOut0
  T16Nx->CON2.POL1 = T16Nx_PWMInitStruct->T16Nx_POL1;           //T16NxOut1
  T16Nx->CON2.PWMMOD = T16Nx_PWMInitStruct->T16Nx_PWMMODE;      //PWMģʽѡ
  T16Nx->CON2.PWMDZE = T16Nx_PWMInitStruct->PWMDZE;             //PWMģʽǷʹ
}

/***************************************************************
  T16Nx_PMWPDZ_Config
    T16NxPWMģʽ
  ֵT16NxT16N0/1/2/3 PWM_PDZ_data1-256
  ֵ
  ֵ
 ***************************************************************/

void T16Nx_PWMPDZ_Config(T16N_TypeDef *T16Nx, unsigned int PWM_PDZ_data)
{
  T16Nx->PDZ.PDZ = PWM_PDZ_data - 1;
}

/***************************************************************
  T16Nx_MATxITConfig
    T16NxƥĹģʽ
  ֵT16NxT16N0/1/2/3 TypeƥĹģʽ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_MAT0ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATCON Type)
{
  T16Nx->CON0.MAT0S = Type;
}
void T16Nx_MAT1ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATCON Type)
{
  T16Nx->CON0.MAT1S = Type;
}
void T16Nx_MAT2ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATCON Type)
{
  T16Nx->CON0.MAT2S = Type;
}
void T16Nx_MAT3ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATCON Type)
{
  T16Nx->CON0.MAT3S = Type;
}


/***************************************************************
  T16Nx_MATxOutxConfig
    T16Nxƥ˿ڵģʽ
  ֵT16NxT16N0/1/2/3  Typeƥ˿ڵĹģʽ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_MAT0Out0Config(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATOUT Type)
{
  T16Nx->CON2.MOM0 = Type;
}
void T16Nx_MAT1Out0Config(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATOUT Type)
{
  T16Nx->CON2.MOM1 = Type;
}
void T16Nx_MAT2Out1Config(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATOUT Type)
{
  T16Nx->CON2.MOM2 = Type;
}
void T16Nx_MAT3Out1Config(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATOUT Type)
{
  T16Nx->CON2.MOM3 = Type;
}


/***************************************************************
  T16Nx_ITConfig
    T16Nж
  ֵT16NxT16N0/1/2/3 Typeж  NewStateʹ/ʧ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_IT Type, TYPE_FUNCEN NewState)
{
  if (NewState != Disable)
  {
    T16Nx->IE.Word |= (uint32_t)Type;
  }
  else
  {
    T16Nx->IE.Word &= (~(uint32_t)Type);
  }
}


/***************************************************************
  T16Nx_SetCNT0
    CNT0ֵ
  ֵT16NxT16N0/1/2/3 Value16λֵ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_SetCNT0(T16N_TypeDef *T16Nx, uint16_t Value)
{
  T16Nx->CON0.ASYWEN = Disable;
  T16Nx->CNT0.CNT0 = Value;
  T16Nx->CON0.ASYWEN = Enable;
}

/***************************************************************
  T16Nx_SetCNT1
    CNT1ֵ
  ֵT16NxT16N0/1/2/3 Value16λֵ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_SetCNT1(T16N_TypeDef *T16Nx, uint16_t Value)
{
  T16Nx->CON0.ASYWEN = Disable;
  T16Nx->CNT1.CNT1 = Value;
  T16Nx->CON0.ASYWEN = Enable;
}



/***************************************************************
  T16Nx_SetPREMAT
    ԤƵ
  ֵT16NxT16N0/1/2/3 Value1-256
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_SetPREMAT(T16N_TypeDef *T16Nx, uint8_t Value)
{
  T16Nx->PREMAT.PREMAT = Value - 1;
}

/***************************************************************
  T16Nx_SetPRECNT
    ԤƵ
  ֵT16NxT16N0/1/2/3 Value1-256
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_SetPRECNT(T16N_TypeDef *T16Nx, uint8_t Value)
{
  T16Nx->CON0.ASYWEN = Disable;
  T16Nx->PRECNT.PRECNT = Value;
  T16Nx->CON0.ASYWEN = Enable;
}


/***************************************************************
  T16Nx_SetMATx
    ƥĴ
  ֵT16NxT16N0/1/2/3 MATxTIM_MAT0/1/2/3  Value16λֵ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_SetMAT0(T16N_TypeDef *T16Nx, uint16_t Value)
{

  T16Nx->MAT0.MAT0 = Value;
}

void T16Nx_SetMAT1(T16N_TypeDef *T16Nx, uint16_t Value)
{

  T16Nx->MAT1.MAT1 = Value;
}
void T16Nx_SetMAT2(T16N_TypeDef *T16Nx, uint16_t Value)
{

  T16Nx->MAT2.MAT2 = Value;
}
void T16Nx_SetMAT3(T16N_TypeDef *T16Nx, uint16_t Value)
{

  T16Nx->MAT3.MAT3 = Value;
}

/***************************************************************
  T16Nx_SetMATx
    ƥĴ
  ֵT16NxT16N0/1/2/3 MATxTOP0/1  Value16λֵ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_SetTOP0(T16N_TypeDef *T16Nx, uint16_t Value)
{

  T16Nx->TOP0.TOP0 = Value;
}

void T16Nx_SetTOP1(T16N_TypeDef *T16Nx, uint16_t Value)
{

  T16Nx->TOP1.TOP1 = Value;
}


/***************************************************************
  T16Nx_GetMATx
    ȡƥĴֵ
  ֵT16NxT16N0/1/2/3 MATxTIM_MAT0/1/2/3
  ֵ
  ֵ16λֵ
 ***************************************************************/
uint16_t T16Nx_GetMAT0(T16N_TypeDef *T16Nx)
{
  return (T16Nx->MAT0.MAT0) ;

}

uint16_t T16Nx_GetMAT1(T16N_TypeDef *T16Nx)
{
  return (T16Nx->MAT1.MAT1) ;

}
uint16_t T16Nx_GetMAT2(T16N_TypeDef *T16Nx)
{
  return (T16Nx->MAT2.MAT2) ;

}
uint16_t T16Nx_GetMAT3(T16N_TypeDef *T16Nx)
{
  return (T16Nx->MAT3.MAT3) ;

}


/***************************************************************
  T16Nx_GetTOPx
    ȡƥĴֵ
  ֵT16NxT16N0/1/2/3 MATxTIM_TOP0/1
  ֵ
  ֵ16λֵ
 ***************************************************************/
uint16_t T16Nx_GetTOP0(T16N_TypeDef *T16Nx)
{
  return (T16Nx->TOP0.TOP0) ;

}

uint16_t T16Nx_GetTOP1(T16N_TypeDef *T16Nx)
{
  return (T16Nx->TOP1.TOP1) ;

}

/***************************************************************
  T16Nx_GetCNTx
    ȡĴֵ
  ֵT16NxT16N0/1/2/3
  ֵ16λֵ
 ***************************************************************/
uint16_t T16Nx_GetCNT0(T16N_TypeDef *T16Nx)
{
  return (T16Nx->CNT0.CNT0) ;
}

uint16_t T16Nx_GetCNT1(T16N_TypeDef *T16Nx)
{
  return (T16Nx->CNT1.CNT1) ;
}



/***************************************************************
  T16Nx_GetFlagStatus
    ȡָ־λ
  ֵT16NxT16N0/1/2/3 T16Nx_Flagжϱ־λ
  ֵ
  ֵRESET/SET
 ***************************************************************/
FlagStatus T16Nx_GetFlagStatus(T16N_TypeDef *T16Nx, T16Nx_TYPE_IT T16Nx_Flag)
{
  FlagStatus bitstatus = RESET;

  if ((T16Nx->IF.Word  & (uint32_t)T16Nx_Flag) != (uint32_t)RESET)
  {
    bitstatus = SET;
  }
  else
  {
    bitstatus = RESET;
  }

  return  bitstatus;
}


/***************************************************************
  T16Nx_ClearITPendingBit
    ָжϱ־λ
  ֵT16NxT16N0/1/2/3 T16Nx_Flagжϱ־λ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_ClearITPendingBit(T16N_TypeDef *T16Nx, T16Nx_TYPE_IT T16Nx_Flag)
{
  T16Nx->IF.Word = (uint32_t)T16Nx_Flag;
}


/***************************************************************
  T16Nx_Enable
    ʹT16Nx
  ֵT16NxT16N0/1/2/3
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_Enable(T16N_TypeDef *T16Nx)
{
  T16Nx->CON0.EN = 1;
}

/***************************************************************
  T16Nx_Enable
    ֹT16Nx
  ֵT16NxT16N0/1/2/3
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_Disable(T16N_TypeDef *T16Nx)
{
  T16Nx->CON0.EN = 0;
}


/***************************************************************
  T16Nx_PWMBK_Config
    PWMɲ
  ֵT16NxT16N0/1/2/3 ,Type PWMɲṹ
  ֵ
  ֵ
 ***************************************************************/
void T16Nx_PWMBK_Config(T16N_TypeDef *T16Nx, T16Nx_PWMBK_Type *type)
{

  T16Nx->CON2.PWMBKL0 = type->T16Nx_PWMBK_L0;    //PWMͨ0ɲƽѡ
  T16Nx->CON2.PWMBKL1 = type->T16Nx_PWMBK_L1;    //PWMͨ1ɲƽѡ
  T16Nx->CON2.PWMBKP0 = type->T16Nx_PWMBK_P0;    //PWMͨ0ɲźżѡ
  T16Nx->CON2.PWMBKP1 = type->T16Nx_PWMBK_P1;    //PWMͨ1ɲźżѡ
  T16Nx->CON2.PWMBKE0 = type->T16Nx_PWMBK_EN0;   //PWMͨ0ɲʹ
  T16Nx->CON2.PWMBKE1 = type->T16Nx_PWMBK_EN1;   //PWMͨ1ɲʹ
}
/***************************************************************
  T16Nx_GetPWMBKF
    ȡPWMBKFɲ־λ
  ֵT16NxT16N0/1/2/3
  ֵPWMBKF־λֵSETɲ¼RESETδɲ¼
  ֵ
 ***************************************************************/

FlagStatus T16Nx_GetPWMBKF(T16N_TypeDef *T16Nx)
{
  if (T16Nx->CON2.PWMBKF == 1)
    return SET;
  else
    return RESET;
}
/***************************************************************
  T16Nx_ResetPWMBKF
    : PWMBKF־־PWM˿ڻָshuc
  ֵT16NxT16N0/1/2/3
  ֵ
  ֵ
 ***************************************************************/

void T16Nx_ResetPWMBKF(T16N_TypeDef *T16Nx)
{
  T16Nx->CON2.PWMBKF = 1;
}

/***************************************************************
  T16Nx_PTR_Config
    : PWMģʽADCʹ
  ֵT16NxT16N0/1/2/3
  ֵ
  ֵ
 ***************************************************************/

void T16Nx_PTR_Config(T16N_TypeDef *T16Nx, T16Nx_PWMTRE_type Type, TYPE_FUNCEN NewState)
{
  if (NewState != Disable)
  {
    T16Nx->PTR.Word |= (uint32_t)Type;
  }
  else
  {
    T16Nx->PTR.Word &= (~(uint32_t)Type);
  }
}



/***************************************************************
  T32Nx_BaseInit
    T32Nxʼ,ʼʱѡⲿʱͬⲿʱӼԵѡ񣬹ģʽ
  ֵT32NxT32N0 T32Nx_BaseInitStructʼýṹַ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_BaseInit(T32N_TypeDef *T32Nx, T32Nx_BaseInitStruType *T32Nx_BaseInitStruct)
{

  T32Nx->CON0.CS         = T32Nx_BaseInitStruct->T32Nx_ClkS;     //ʱԴѡ
  T32Nx->CON0.SYNC       = T32Nx_BaseInitStruct->T32Nx_SYNC;     //ⲿʱͬʹ  Disable:ͬⲿʱӣΪ첽ģʽEnableͨPCLKⲿʱͬΪͬģʽⲿʱӵĸߵ͵ƽƽٱ2ʱ
  T32Nx->CON0.EDGE       = T32Nx_BaseInitStruct->T32Nx_EDGE;     //ⲿʱӼѡ
  T32Nx->CON0.MOD        = T32Nx_BaseInitStruct->T32Nx_Mode;     //ģʽѡ
  T32Nx->PREMAT.PREMAT   = T32Nx_BaseInitStruct->T32Nx_PREMAT - 1; //ԤƵãΧ1-256
}



/***************************************************************
  T32Nx_CapInit
    T32Nx׽ʼ
  ֵT32NxT32N0 T32Nx_CapInitStructʼýṹַ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_CapInit(T32N_TypeDef *T32Nx, T32Nx_CapInitStruType *T32Nx_CapInitStruct)
{

  T32Nx->CON1.CAPPE = T32Nx_CapInitStruct->T32Nx_CapRise;  //벶׽Ƿʹ
  T32Nx->CON1.CAPNE = T32Nx_CapInitStruct->T32Nx_CapFall;  //½벶׽Ƿʹ
  T32Nx->CON1.CAPIS0 = T32Nx_CapInitStruct->T32Nx_CapIS0;  //ò׽˿T32NxIN0Ƿʹ
  T32Nx->CON1.CAPIS1 = T32Nx_CapInitStruct->T32Nx_CapIS1;  //ò׽˿T32NxIN1Ƿʹ
  T32Nx->CON1.CAPT = T32Nx_CapInitStruct->T32Nx_CapTime;   //ò׽
  T32Nx->CON1.CAPL0 = T32Nx_CapInitStruct->T32Nx_CAPCAPL0; //ò׽0ؼǷʹ
  T32Nx->CON1.CAPL1 = T32Nx_CapInitStruct->T32Nx_CAPCAPL1; //ò׽1ؼǷʹ
}

/***************************************************************
  T32Nx_PMWOutInit
    T32NxPWMʼ
  ֵT32NxT32N0 T32Nx_PWMInitStructʼýṹַ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_PMWOutInit(T32N_TypeDef *T32Nx, T32Nx_PWMInitStruType *T32Nx_PWMInitStruct)
{
  T32Nx->CON1.MOE0 = T32Nx_PWMInitStruct->T32Nx_MOE0;           //˿0Ƿʹ
  T32Nx->CON1.MOE1 = T32Nx_PWMInitStruct->T32Nx_MOE1;           //˿1Ƿʹ

}


/***************************************************************
  T32Nx_MATxITConfig
    T32NxƥĹģʽ
  ֵT32NxT32N0 TypeƥĹģʽ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_MAT0ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATCON Type)
{
  T32Nx->CON0.MAT0S = Type;
}
void T32Nx_MAT1ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATCON Type)
{
  T32Nx->CON0.MAT1S = Type;
}
void T32Nx_MAT2ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATCON Type)
{
  T32Nx->CON0.MAT2S = Type;
}
void T32Nx_MAT3ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATCON Type)
{
  T32Nx->CON0.MAT3S = Type;
}


/***************************************************************
  T32Nx_MATxOutxConfig
    T32Nxƥ˿ڵģʽ
  ֵT32NxT32N0/1/2/3  Typeƥ˿ڵĹģʽ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_MAT0Out0Config(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATOUT Type)
{
  T32Nx->CON1.MOM0 = Type;
}
void T32Nx_MAT1Out0Config(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATOUT Type)
{
  T32Nx->CON1.MOM1 = Type;
}
void T32Nx_MAT2Out1Config(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATOUT Type)
{
  T32Nx->CON1.MOM2 = Type;
}
void T32Nx_MAT3Out1Config(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATOUT Type)
{
  T32Nx->CON1.MOM3 = Type;
}


/***************************************************************
  T32Nx_ITConfig
    T32Nж
  ֵT32NxT32N0 Typeж  NewStateʹ/ʧ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_IT Type, TYPE_FUNCEN NewState)
{
  if (NewState != Disable)
  {
    T32Nx->IE.Word |= (uint32_t)Type;
  }
  else
  {
    T32Nx->IE.Word &= (~(uint32_t)Type);
  }
}


/***************************************************************
  T32Nx_SetCNT0
    CNT0ֵ
  ֵT16NxT32N0/1/2/3 Value32λֵ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_SetCNT(T32N_TypeDef *T32Nx, uint32_t Value)
{
  T32Nx->CON0.ASYNC_WREN = Enable;
  T32Nx->CNT.CNT = Value;
  T32Nx->CON0.ASYNC_WREN = Disable;
}


/***************************************************************
  T32Nx_SetPREMAT
    ԤƵ
  ֵT32NxT32N0 Value1-256
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_SetPREMAT(T32N_TypeDef *T32Nx, uint8_t Value)
{
  T32Nx->PREMAT.PREMAT = Value - 1;
}

/***************************************************************
  T32Nx_SetPRECNT
    ԤƵ
  ֵT32NxT32N0 Value1-256
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_SetPRECNT(T32N_TypeDef *T32Nx, uint8_t Value)
{
  T32Nx->CON0.ASYNC_WREN = Enable;
  T32Nx->PRECNT.PRECNT = Value;
  T32Nx->CON0.ASYNC_WREN = Disable;
}

/***************************************************************
  T32Nx_SetMATx
    ƥĴ
  ֵT16NxT32N0 MATxTIM_MAT0/1/2/3  Value32λֵ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_SetMAT0(T32N_TypeDef *T32Nx, uint32_t Value)
{

  T32Nx->MAT0.MAT0 = Value;
}

void T32Nx_SetMAT1(T32N_TypeDef *T32Nx, uint32_t Value)
{

  T32Nx->MAT1.MAT1 = Value;
}
void T32Nx_SetMAT2(T32N_TypeDef *T32Nx, uint32_t Value)
{

  T32Nx->MAT2.MAT2 = Value;
}
void T32Nx_SetMAT3(T32N_TypeDef *T32Nx, uint32_t Value)
{

  T32Nx->MAT3.MAT3 = Value;
}

/***************************************************************
  T32Nx_GetMATx
    ȡƥĴֵ
  ֵT32NxT32N0 MATxT32Nx_MAT0/1/2/3
  ֵ
  ֵ32λֵ
 ***************************************************************/
uint32_t T32Nx_GetMAT0(T32N_TypeDef *T32Nx)
{
  return (T32Nx->MAT0.MAT0) ;

}

uint32_t T32Nx_GetMAT1(T32N_TypeDef *T32Nx)
{
  return (T32Nx->MAT1.MAT1) ;

}
uint32_t T32Nx_GetMAT2(T32N_TypeDef *T32Nx)
{
  return (T32Nx->MAT2.MAT2) ;

}
uint32_t T32Nx_GetMAT3(T32N_TypeDef *T32Nx)
{
  return (T32Nx->MAT3.MAT3) ;

}




/***************************************************************
  T32Nx_GetCNT
    ȡĴֵ
  ֵT32NxT32N0/1/2/3
  ֵ32λֵ
 ***************************************************************/
uint32_t T32Nx_GetCNT(T32N_TypeDef *T32Nx)
{
  return (T32Nx->CNT.CNT) ;
}

/***************************************************************
  T32Nx_GetFlagStatus
    ȡָ־λ
  ֵT32NxT32N0 T32Nx_Flagжϱ־λ
  ֵ
  ֵRESET/SET
 ***************************************************************/
FlagStatus T32Nx_GetFlagStatus(T32N_TypeDef *T32Nx, T32Nx_TYPE_IT T32Nx_Flag)
{
  FlagStatus bitstatus = RESET;

  if ((T32Nx->IF.Word  & (uint32_t)T32Nx_Flag) != (uint32_t)RESET)
  {
    bitstatus = SET;
  }
  else
  {
    bitstatus = RESET;
  }

  return  bitstatus;
}


/***************************************************************
  T32Nx_ClearITPendingBit
    ָжϱ־λ
  ֵT32NxT16N0 TIM_Flagжϱ־λ
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_ClearITPendingBit(T32N_TypeDef *T32Nx, T32Nx_TYPE_IT TIM_Flag)
{
  T32Nx->IF.Word = (uint32_t)TIM_Flag;
}


/***************************************************************
  T32Nx_Enable
    ʹT32Nx
  ֵT32NxT32N0
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_Enable(T32N_TypeDef *T32Nx)
{
  T32Nx->CON0.EN = 1;
}

/***************************************************************
  T32Nx_Enable
    ֹT32Nx
  ֵT32NxT32N0
  ֵ
  ֵ
 ***************************************************************/
void T32Nx_Disable(T32N_TypeDef *T32Nx)
{
  T32Nx->CON0.EN = 0;
}

/***************************************************************
  BUZC_Frequence
    BUZʹܺBUZźƵ
  ֵFrequence : BUZźƵʣsys_buz Ƿʹ
  ֵ
  ֵ
 ***************************************************************/
void BUZC_Frequence(uint32_t Frequence, TYPE_FUNCEN sys_buz)
{
  float tmp;

  if (sys_buz == Disable) //BUZCΪֱֹӽֹBUZC
  {
    GPIO->BUZC.BUZEN = 0;
    return;
  }

  tmp = SystemCoreClock / (Frequence * 2) - 1;
  GPIO->BUZC.BUZ_LOAD = (uint32_t)tmp;
  GPIO->BUZC.BUZEN = 1;
}

