/*********************************************************
 *Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
 *ļ:  lib_timer.h
 *  :  ESM Application Team
 *  :  V1.01
 *  :  2016/11/01
 *  :  Timerģ⺯ͷļ
 *  ע:
 ѧϰʾʹãûֱôķջеκηΡ
 **********************************************************/
#ifndef __LIB_TIMER_H__
#define __LIB_TIMER_H__

#include <stdint.h>
#include "HR8P506.h"
#include "type.h"
#include "system_HR8P506.h"


/* ʱԴѡ */
typedef enum
{

  T16Nx_ClkS_PCLK = 0x0,  //ʱԴѡ:ڲPCLK
  T16Nx_ClkS_CK0 = 0x1,   //ʱԴѡ:ⲿCK0ʱ
  T16Nx_ClkS_CK1 = 0x2,   //ʱԴѡ:ⲿCK1ʱ
} T16Nx_TYPE_CLKS;

/* ⲿʱӼѡ */
typedef enum
{
  T16Nx_EDGE_Rise = 0x0,  //ⲿʱӼѡ:
  T16Nx_EDGE_Fall = 0x1,  //ⲿʱӼѡ:½
  T16Nx_EDGE_All = 0x2,   //ⲿʱӼѡ:
} T16Nx_TYPE_EDGE;


/* ģʽѡ */
typedef enum
{
  T16Nx_Mode_TC0 = 0x0,  //ģʽ:ʱģʽ
  T16Nx_Mode_TC1 = 0x1,  //ģʽ:ʱģʽ
  T16Nx_Mode_CAP = 0x2,  //ģʽ:׽ģʽ
  T16Nx_Mode_PWM = 0x3,  //ģʽ:ģʽ
} T16Nx_TYPE_MODE;

/* T16Nxʼýṹ嶨 */
typedef struct
{
  T16Nx_TYPE_CLKS   T16Nx_ClkS; //ʱԴѡ

  TYPE_FUNCEN       T16Nx_SYNC;   //ⲿʱͬ

  T16Nx_TYPE_EDGE   T16Nx_EDGE; //ⲿʱӼѡ

  T16Nx_TYPE_MODE   T16Nx_Mode; //ģʽѡ

  unsigned int      T16Nx_PREMAT;  //ԤƵȣΧ 1-256


} T16Nx_BaseInitStruType;

/* ׽ */
typedef enum
{
  T16Nx_CapTime_1 = 0x0,  //׽:1
  T16Nx_CapTime_2 = 0x1,  //׽:2
  T16Nx_CapTime_3 = 0x2,  //׽:3
  T16Nx_CapTime_4 = 0x3,  //׽:4
  T16Nx_CapTime_5 = 0x4,  //׽:5
  T16Nx_CapTime_6 = 0x5,  //׽:6
  T16Nx_CapTime_7 = 0x6,  //׽:7
  T16Nx_CapTime_8 = 0x7,  //׽:8
  T16Nx_CapTime_9 = 0x8,  //׽:9
  T16Nx_CapTime_10 = 0x9,  //׽:10
  T16Nx_CapTime_11 = 0xA,  //׽:11
  T16Nx_CapTime_12 = 0xB,  //׽:12
  T16Nx_CapTime_13 = 0xC,  //׽:13
  T16Nx_CapTime_14 = 0xD,  //׽:14
  T16Nx_CapTime_15 = 0xE,  //׽:15
  T16Nx_CapTime_16 = 0xF,  //׽:16
} T16Nx_TYPE_CAPT;

/* ׽ܳʼṹ嶨 */
typedef struct
{
  TYPE_FUNCEN  T16Nx_CAPCAPL1;   //׽1ؼʹ

  TYPE_FUNCEN  T16Nx_CAPCAPL0;   //׽0ؼʹ

  TYPE_FUNCEN  T16Nx_CapRise;    //ز׽ʹ

  TYPE_FUNCEN  T16Nx_CapFall;    //½ز׽ʹ

  TYPE_FUNCEN  T16Nx_CapIS0;     //˿0ʹ

  TYPE_FUNCEN  T16Nx_CapIS1;     //˿1ʹ

  T16Nx_TYPE_CAPT  T16Nx_CapTime;  //׽

} T16Nx_CapInitStruType;


/* ƥĴֵƥĹģʽ */
typedef enum
{
  T16Nx_Go_No = 0x0,     //ƥĴֵƥĹģʽ:ж
  T16Nx_Hold_Int = 0x1,  //ƥĴֵƥĹģʽ:ּж
  T16Nx_Clr_Int = 0x2,   //ƥĴֵƥĹģʽ:㲢¼ж
  T16Nx_Go_Int = 0x3,    //ƥĴֵƥĹģʽ:ж
} T16Nx_TYPE_MATCON;



/* ж */
typedef enum
{
  T16Nx_IT_MAT0 = 0x01,    //ƥ0ж
  T16Nx_IT_MAT1 = 0x02,    //ƥ1ж
  T16Nx_IT_MAT2 = 0x04,    //ƥ2ж
  T16Nx_IT_MAT3 = 0x08,    //ƥ3ж
  T16Nx_IT_TOP0 = 0x10,    //T16N_CNT0ƥֵж
  T16Nx_IT_TOP1 = 0x20,    //T16N_CNT1ƥֵж
  T16Nx_IT_CAP0 = 0x40,    //˿T16NxIN0벶׽ж
  T16Nx_IT_CAP1 = 0x80,    //˿T16NxIN1벶׽ж
  T16Nx_IT_PBK0 = 0x100,   //PWMͨ0ɲж
  T16Nx_IT_PBK1 = 0x200,   //PWMͨ1ɲж
} T16Nx_TYPE_IT;


/* PWM */
typedef enum
{
  POSITIVE = 0X00,   //
  NEGATIVE = 0X01,   //
} T16Nx_PWMOUT_POLAR_Type;

/* PWMģʽѡ */
typedef enum
{
  T16Nx_PWMMode_INDEP = 0x0,   //ģʽ
  T16Nx_PWMMode_SYNC = 0x2,    //ͬģʽ
  T16Nx_PWMMode_COMPLE = 0x3,  //ģʽ
} T16Nx_PWMTYPE_MODE;


/* ƹܳʼṹ嶨 */
typedef struct
{
  TYPE_FUNCEN  T16Nx_MOE0;   //˿0ʹ

  TYPE_FUNCEN  T16Nx_MOE1;   //˿1ʹ

  T16Nx_PWMOUT_POLAR_Type  T16Nx_POL0;    //T16NxOUT0ѡλ

  T16Nx_PWMOUT_POLAR_Type  T16Nx_POL1;    //T16NxOUT1ѡλ

  T16Nx_PWMTYPE_MODE T16Nx_PWMMODE; //T16PWMģʽѡ

  TYPE_FUNCEN PWMDZE; //PWMģʽʹ

} T16Nx_PWMInitStruType;


/* ƥĴֵƥ˿ڵĹģʽ */
typedef enum
{
  T16Nx_Out_Hold = 0x0,    //ƥĴֵƥ˿ڵĹģʽ
  T16Nx_Out_Low = 0x1,     //ƥĴֵƥ˿ڵĹģʽ0
  T16Nx_Out_High = 0x2,    //ƥĴֵƥ˿ڵĹģʽ1
  T16Nx_Out_Switch = 0x3,  //ƥĴֵƥ˿ڵĹģʽȡ
} T16Nx_TYPE_MATOUT;

/* PWMɲƽ */
typedef enum
{
  PWMBKOUT_Low = 0,
  PWMBKOUT_High = 1,
} T16Nx_PWMBKOUT_LEVEl;


/* PWMɲźżѡ */
typedef enum
{
  PWMBKP_High = 0,
  PWMBKP_Low = 1,
} T16Nx_PWMBKP_LEVEl;



/*PWMɲ*/
typedef struct
{
  TYPE_FUNCEN T16Nx_PWMBK_EN0;                 //PWMͨ0ɲʹ
  TYPE_FUNCEN T16Nx_PWMBK_EN1;                 //PWMͨ0ɲʹ
  T16Nx_PWMBKOUT_LEVEl T16Nx_PWMBK_L0;         //PWMͨ0ɲƽѡ
  T16Nx_PWMBKOUT_LEVEl T16Nx_PWMBK_L1;        //PWMͨ1ɲƽѡ
  T16Nx_PWMBKP_LEVEl T16Nx_PWMBK_P0;            //PWMͨ0ɲźżѡ
  T16Nx_PWMBKP_LEVEl T16Nx_PWMBK_P1;            //PWMͨ1ɲźżѡ
} T16Nx_PWMBK_Type;



/*PWMģʽADCʹܿ*/

typedef enum
{
  T16Nx_P0MAT0 = 0x02,         //PWMͨ0ƥ0ʹ
  T16Nx_P0MAT1 = 0x04,         //PWMͨ0ƥ1ʹ
  T16Nx_P0TOP0 = 0x08,         //PWMͨ0ֵ0ʹ
  T16Nx_P1MAT2 = 0x20,         //PWMͨ1ƥ2ʹ
  T16Nx_P1MAT3 = 0x40,         //PWMͨ1ƥ3ʹ
  T16Nx_P1TOP1 = 0x80,         //PWMͨ1ֵ1ʹ
} T16Nx_PWMTRE_type;




/****************************************32Ϊʱݽṹ*********************************/


/* ʱԴѡ */
typedef enum
{

  T32Nx_ClkS_PCLK = 0x0,  //ʱԴѡ:ڲPCLK
  T32Nx_ClkS_CK0 = 0x1,   //ʱԴѡ:ⲿCK0ʱ
  T32Nx_ClkS_CK1 = 0x2,   //ʱԴѡ:ⲿCK1ʱ
} T32Nx_TYPE_CLKS;

/* ⲿʱӼѡ */
typedef enum
{
  T32Nx_EDGE_Rise = 0x0,  //ⲿʱӼѡ:
  T32Nx_EDGE_Fall = 0x1,  //ⲿʱӼѡ:½
  T32Nx_EDGE_All = 0x2,   //ⲿʱӼѡ:
} T32Nx_TYPE_EDGE;


/* ģʽѡ */
typedef enum
{
  T32Nx_Mode_TC0 = 0x0,  //ģʽ:ʱģʽ
  T32Nx_Mode_TC1 = 0x1,  //ģʽ:ʱģʽ
  T32Nx_Mode_CAP = 0x2,  //ģʽ:׽ģʽ
  T32Nx_Mode_PWM = 0x3,  //ģʽ:ģʽ
} T32Nx_TYPE_MODE;

/* T32Nxʼýṹ嶨 */
typedef struct
{
  T32Nx_TYPE_CLKS   T32Nx_ClkS; //ʱԴѡ

  TYPE_FUNCEN       T32Nx_SYNC;   //ⲿʱͬ

  T32Nx_TYPE_EDGE   T32Nx_EDGE; //ⲿʱӼѡ

  T32Nx_TYPE_MODE   T32Nx_Mode; //ģʽѡ

  unsigned int      T32Nx_PREMAT;  //ԤƵȣΧ 1-256


} T32Nx_BaseInitStruType;



/* ׽ */
typedef enum
{
  T32Nx_CapTime_1 = 0x0,  //׽:1
  T32Nx_CapTime_2 = 0x1,  //׽:2
  T32Nx_CapTime_3 = 0x2,  //׽:3
  T32Nx_CapTime_4 = 0x3,  //׽:4
  T32Nx_CapTime_5 = 0x4,  //׽:5
  T32Nx_CapTime_6 = 0x5,  //׽:6
  T32Nx_CapTime_7 = 0x6,  //׽:7
  T32Nx_CapTime_8 = 0x7,  //׽:8
  T32Nx_CapTime_9 = 0x8,  //׽:9
  T32Nx_CapTime_10 = 0x9,  //׽:10
  T32Nx_CapTime_11 = 0xA,  //׽:11
  T32Nx_CapTime_12 = 0xB,  //׽:12
  T32Nx_CapTime_13 = 0xC,  //׽:13
  T32Nx_CapTime_14 = 0xD,  //׽:14
  T32Nx_CapTime_15 = 0xE,  //׽:15
  T32Nx_CapTime_16 = 0xF,  //׽:16
} T32Nx_TYPE_CAPT;

/* ׽ܳʼṹ嶨 */
typedef struct
{
  TYPE_FUNCEN  T32Nx_CAPCAPL1;   //׽1ؼʹ

  TYPE_FUNCEN  T32Nx_CAPCAPL0;   //׽0ؼʹ

  TYPE_FUNCEN  T32Nx_CapRise;    //ز׽ʹ

  TYPE_FUNCEN  T32Nx_CapFall;    //½ز׽ʹ

  TYPE_FUNCEN  T32Nx_CapIS0;     //˿0ʹ

  TYPE_FUNCEN  T32Nx_CapIS1;     //˿1ʹ

  T32Nx_TYPE_CAPT  T32Nx_CapTime;  //׽

} T32Nx_CapInitStruType;

/* ƹܳʼṹ嶨 */
typedef struct
{
  TYPE_FUNCEN  T32Nx_MOE0;   //˿0ʹ

  TYPE_FUNCEN  T32Nx_MOE1;   //˿1ʹ

} T32Nx_PWMInitStruType;

/* ƥĴֵƥĹģʽ */
typedef enum
{
  T32Nx_Go_No = 0x0,     //ƥĴֵƥĹģʽ:ж
  T32Nx_Hold_Int = 0x1,  //ƥĴֵƥĹģʽ:ּж
  T32Nx_Clr_Int = 0x2,   //ƥĴֵƥĹģʽ:㲢¼ж
  T32Nx_Go_Int = 0x3,    //ƥĴֵƥĹģʽ:ж
} T32Nx_TYPE_MATCON;

/* ƥĴֵƥ˿ڵĹģʽ */
typedef enum
{
  T32Nx_Out_Hold = 0x0,    //ƥĴֵƥ˿ڵĹģʽ
  T32Nx_Out_Low = 0x1,     //ƥĴֵƥ˿ڵĹģʽ0
  T32Nx_Out_High = 0x2,    //ƥĴֵƥ˿ڵĹģʽ1
  T32Nx_Out_Switch = 0x3,  //ƥĴֵƥ˿ڵĹģʽȡ
} T32Nx_TYPE_MATOUT;


/* ж */
typedef enum
{
  T32Nx_IT_MAT0 = 0x01,    //ƥ0ж
  T32Nx_IT_MAT1 = 0x02,    //ƥ1ж
  T32Nx_IT_MAT2 = 0x04,    //ƥ2ж
  T32Nx_IT_MAT3 = 0x08,    //ƥ3ж
  T32Nx_IT_IT   = 0x10,     //T32Nƥ0xFFFFFFFFжʹλ
  T32Nx_IT_CAP0 = 0x20,    //T32N_CNT0ƥֵж
  T32Nx_IT_CAP1 = 0x40,    //T32N_CNT0ƥֵж
} T32Nx_TYPE_IT;


/*********************T16Nxģ麯 *********************/
void T16Nx_BaseInit(T16N_TypeDef *T16Nx, T16Nx_BaseInitStruType *T16Nx_BaseInitStruct);
void T16Nx_CapInit(T16N_TypeDef *T16Nx, T16Nx_CapInitStruType *T16Nx_CapInitStruct);
void T16Nx_PMWOutInit(T16N_TypeDef *T16Nx, T16Nx_PWMInitStruType *T16Nx_PWMInitStruct);
void T16Nx_PWMPDZ_Config(T16N_TypeDef *T16Nx, unsigned int PWM_PDZ_data);
void T16Nx_MAT0ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATCON Type);
void T16Nx_MAT1ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATCON Type);
void T16Nx_MAT2ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATCON Type);
void T16Nx_MAT3ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATCON Type);
void T16Nx_MAT0Out0Config(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATOUT Type);
void T16Nx_MAT1Out0Config(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATOUT Type);
void T16Nx_MAT2Out1Config(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATOUT Type);
void T16Nx_MAT3Out1Config(T16N_TypeDef *T16Nx, T16Nx_TYPE_MATOUT Type);
void T16Nx_ITConfig(T16N_TypeDef *T16Nx, T16Nx_TYPE_IT Type, TYPE_FUNCEN NewState);
void T16Nx_SetCNT0(T16N_TypeDef *T16Nx, uint16_t Value);
void T16Nx_SetCNT1(T16N_TypeDef *T16Nx, uint16_t Value);
void T16Nx_SetPREMAT(T16N_TypeDef *T16Nx, uint8_t Value);
void T16Nx_SetPRECNT(T16N_TypeDef *T16Nx, uint8_t Value);
void T16Nx_SetMAT0(T16N_TypeDef *T16Nx, uint16_t Value);
void T16Nx_SetMAT1(T16N_TypeDef *T16Nx, uint16_t Value);
void T16Nx_SetMAT2(T16N_TypeDef *T16Nx, uint16_t Value);
void T16Nx_SetMAT3(T16N_TypeDef *T16Nx, uint16_t Value);
void T16Nx_SetTOP0(T16N_TypeDef *T16Nx, uint16_t Value);
void T16Nx_SetTOP1(T16N_TypeDef *T16Nx, uint16_t Value);
uint16_t T16Nx_GetMAT0(T16N_TypeDef *T16Nx);
uint16_t T16Nx_GetMAT1(T16N_TypeDef *T16Nx);
uint16_t T16Nx_GetMAT2(T16N_TypeDef *T16Nx);
uint16_t T16Nx_GetMAT3(T16N_TypeDef *T16Nx);
uint16_t T16Nx_GetTOP0(T16N_TypeDef *T16Nx);
uint16_t T16Nx_GetTOP1(T16N_TypeDef *T16Nx);
uint16_t T16Nx_GetCNT0(T16N_TypeDef *T16Nx);
uint16_t T16Nx_GetCNT1(T16N_TypeDef *T16Nx);
FlagStatus T16Nx_GetFlagStatus(T16N_TypeDef *T16Nx, T16Nx_TYPE_IT T16Nx_Flag);
void T16Nx_ClearITPendingBit(T16N_TypeDef *T16Nx, T16Nx_TYPE_IT TIM_Flag);
void T16Nx_Enable(T16N_TypeDef *T16Nx);
void T16Nx_Disable(T16N_TypeDef *T16Nx);
void T16Nx_PWMBK_Config(T16N_TypeDef *T16Nx, T16Nx_PWMBK_Type *type);
FlagStatus T16Nx_GetPWMBKF(T16N_TypeDef *T16Nx);
void T16Nx_ResetPWMBKF(T16N_TypeDef *T16Nx);
void T16Nx_PTR_Config(T16N_TypeDef *T16Nx, T16Nx_PWMTRE_type Type, TYPE_FUNCEN NewState);

/***************************32λʱ********************************/

void T32Nx_BaseInit(T32N_TypeDef *T32Nx, T32Nx_BaseInitStruType *T32Nx_BaseInitStruct);
void T32Nx_CapInit(T32N_TypeDef *T32Nx, T32Nx_CapInitStruType *T32Nx_CapInitStruct);
void T32Nx_PMWOutInit(T32N_TypeDef *T32Nx, T32Nx_PWMInitStruType *T32Nx_PWMInitStruct);
void T32Nx_MAT0ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATCON Type);
void T32Nx_MAT1ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATCON Type);
void T32Nx_MAT2ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATCON Type);
void T32Nx_MAT3ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATCON Type);
void T32Nx_MAT0Out0Config(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATOUT Type);
void T32Nx_MAT1Out0Config(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATOUT Type);
void T32Nx_MAT2Out1Config(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATOUT Type);
void T32Nx_MAT3Out1Config(T32N_TypeDef *T32Nx, T32Nx_TYPE_MATOUT Type);
void T32Nx_ITConfig(T32N_TypeDef *T32Nx, T32Nx_TYPE_IT Type, TYPE_FUNCEN NewState);
void T32Nx_SetCNT(T32N_TypeDef *T32Nx, uint32_t Value);
void T32Nx_SetPREMAT(T32N_TypeDef *T32Nx, uint8_t Value);
void T32Nx_SetPRECNT(T32N_TypeDef *T32Nx, uint8_t Value);
void T32Nx_SetMAT0(T32N_TypeDef *T32Nx, uint32_t Value);
void T32Nx_SetMAT1(T32N_TypeDef *T32Nx, uint32_t Value);
void T32Nx_SetMAT2(T32N_TypeDef *T32Nx, uint32_t Value);
void T32Nx_SetMAT3(T32N_TypeDef *T32Nx, uint32_t Value);
uint32_t T32Nx_GetMAT0(T32N_TypeDef *T32Nx);
uint32_t T32Nx_GetMAT1(T32N_TypeDef *T32Nx);
uint32_t T32Nx_GetMAT2(T32N_TypeDef *T32Nx);
uint32_t T32Nx_GetMAT3(T32N_TypeDef *T32Nx);
uint32_t T32Nx_GetCNT(T32N_TypeDef *T32Nx);
FlagStatus T32Nx_GetFlagStatus(T32N_TypeDef *T32Nx, T32Nx_TYPE_IT T32Nx_Flag);
void T32Nx_ClearITPendingBit(T32N_TypeDef *T32Nx, T32Nx_TYPE_IT TIM_Flag);
void T32Nx_Enable(T32N_TypeDef *T32Nx);
void T32Nx_Disable(T32N_TypeDef *T32Nx);
void BUZC_Frequence(uint32_t Frequence, TYPE_FUNCEN sys_buz);

#endif
