/*********************************************************
 *Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
 *ļ:  lib_gpio.h
 *  :  ESM Application Team
 *  :  V1.01
 *  :  2016/11/01
 *  :  GPIOģ⺯ͷļ
 *  ע:
 ѧϰʾʹãûֱôķջеκηΡ
 **********************************************************/
#ifndef __LIB_GPIO_H__
#define __LIB_GPIO_H__

#include <stdint.h>
#include "HR8P506.h"
#include "type.h"

/* GPIOű */
typedef enum
{
  GPIO_Pin_B0 = 0,
  GPIO_Pin_B1 = 1,
  GPIO_Pin_B2 = 2,
  GPIO_Pin_B3 = 3,
  GPIO_Pin_B4 = 4,
  GPIO_Pin_B5 = 5,
  GPIO_Pin_B6 = 6,
  GPIO_Pin_B7 = 7,
  GPIO_Pin_B8 = 8,
  GPIO_Pin_B9 = 9,
  GPIO_Pin_B10 = 10,
  GPIO_Pin_B11 = 11,
  GPIO_Pin_B12 = 12,
  GPIO_Pin_B13 = 13,
  GPIO_Pin_A0 = 14,
  GPIO_Pin_A1 = 15,
  GPIO_Pin_A2 = 16,
  GPIO_Pin_A3 = 17,
  GPIO_Pin_A4 = 18,
  GPIO_Pin_A5 = 19,
  GPIO_Pin_A6 = 20,
  GPIO_Pin_A7 = 21,
  GPIO_Pin_A8 = 22,
  GPIO_Pin_A9 = 23,
  GPIO_Pin_A10 = 24,
  GPIO_Pin_A11 = 25,
  GPIO_Pin_A12 = 26,
  GPIO_Pin_A13 = 27,
  GPIO_Pin_A14 = 28,
  GPIO_Pin_A15 = 29,
  GPIO_Pin_A16 = 30,
  GPIO_Pin_A17 = 31,
  GPIO_Pin_A18 = 32,
  GPIO_Pin_A19 = 33,
  GPIO_Pin_A20 = 34,
  GPIO_Pin_A21 = 35,
  GPIO_Pin_A22 = 36,
  GPIO_Pin_A23 = 37,
  GPIO_Pin_A24 = 38,
  GPIO_Pin_A25 = 39,
  GPIO_Pin_A26 = 40,
  GPIO_Pin_A27 = 41,
  GPIO_Pin_A28 = 42,
  GPIO_Pin_A29 = 43,
  GPIO_Pin_A30 = 44,
  GPIO_Pin_A31 = 45,
} GPIO_Pin;

/* Ÿùѡ */
typedef enum
{
  GPIO_Reuse_Func0 = 0, // Ÿù0
  GPIO_Reuse_Func1 = 1, // Ÿù1
  GPIO_Reuse_Func2 = 2, // Ÿù2
  GPIO_Reuse_Func3 = 3, // Ÿù3
} GPIO_Reuse_Func;

/* ŷѡ */
typedef enum
{
  GPIO_Direction_Output = 0,  // 
  GPIO_Direction_Input = 1, // 뷽
} GPIO_Direction;

/* ©ʹλ */
typedef enum
{
  GPIO_ODE_Output_Disable = 0,  // ©ֹ
  GPIO_ODE_Output_Enable = 1, // ©ʹ
} GPIO_ODE_Output;

/* ѡ */
typedef enum
{
  GPIO_DS_Output_Normal = 0,  // ͨ
  GPIO_DS_Output_Strong = 1,  // ǿ
} GPIO_DS_Output;

/* ʹ */
typedef enum
{
  GPIO_PUE_Input_Disable = 0, // ֹ
  GPIO_PUE_Input_Enable = 1,  // ʹ
} GPIO_PUE_Input;

/* ʹ */
typedef enum
{
  GPIO_PDE_Input_Disable = 0, // ֹ
  GPIO_PDE_Input_Enable = 1,  // ʹ
} GPIO_PDE_Input;

/* ź */
typedef enum
{
  GPIO_Pin_Signal_Digital = 0,  // ź
  GPIO_Pin_Signal_Analog = 1, // ģź
} GPIO_Pin_Signal;

/* GPIOʼýṹ */
typedef struct
{
  GPIO_Pin_Signal Signal;   /* ϵźֻͣģ */

  GPIO_Direction Dir;   /* ʱ롢ѡ */
  GPIO_Reuse_Func Func;   /* ʱŸùѡ */

  GPIO_ODE_Output ODE;    /* šʱ©ѡ */
  GPIO_DS_Output DS;    /* šʱСѡ */

  GPIO_PUE_Input PUE;   /* š뷽ʱѡ */
  GPIO_PDE_Input PDE;   /* š뷽ʱѡ */
} GPIO_InitSettingType;

/* ⲿ˿жʹ */
typedef enum
{
  PINT_IE_Set_Disable = 0,  // жϽֹ
  PINT_IE_Set_Enable = 1,   // жʹ
} PINT_IE_Set;

/* ⲿ˿жϴʽ */
typedef enum
{
  PINT_Trigger_Rising_Edge = 0, // شж
  PINT_Trigger_Trailing_Edge = 1, // ½شж
  PINT_Trigger_High_Level = 2,  // ߵƽж
  PINT_Trigger_Low_Level = 3, // ͵ƽж
  PINT_Trigger_Both_Edge = 4, // غ½ضж
} PINT_Trigger_Style;

/* ⲿ˿ڳʼýṹ */
typedef struct
{
  PINT_IE_Set IE_Set;     // жǷʹ
  PINT_Trigger_Style Trigger_Style; // жϴʽ
} PINT_InitSettingType;

/* KINTжʹ */
typedef enum
{
  KINT_IE_Set_Disable = 0,  // жϽֹ
  KINT_IE_Set_Enable = 1,   // жʹ
} KINT_IE_Set;

/* KINTжϷʽ */
typedef enum
{
  KINT_Trigger_Rising_Edge = 0, // شж
  KINT_Trigger_Trailing_Edge = 1, // ½شж
  KINT_Trigger_High_Level = 2,  // ߵƽж
  KINT_Trigger_Low_Level = 3, // ͵ƽж
  KINT_Trigger_Both_Edge = 4, // غ½ضж
} KINT_Trigger_Style;

/* KINTʼýṹ */
typedef struct
{
  KINT_IE_Set IE_Set;     // жǷʹ
  KINT_Trigger_Style Trigger_Style; // жϴʽ
} KINT_InitSettingType;

/* Ƶƽ */
typedef enum
{
  UART_TXPLV_Low = 0x0,   //Ƶƽ:
  UART_TXPLV_High = 0x1,  //Ƶƽ:
} UART_TYPE_TXPLV;


/* PWMѡ */
typedef enum
{
  UART_TX0PS_NO = 0x0,         //PWMѡ:ǵ
  UART_TX0PS_T16N0Out0 = 0x1,  //PWMѡ:T16N1OUT0
  UART_TX0PS_T16N0Out1 = 0x2,  //PWMѡ:T16N1OUT1
  UART_TX0PS_BUZ = 0x3,        //PWMѡ:BUZҪ̶38K
} UART_TYPE_TX0PS;

typedef enum
{
  UART_TX1PS_NO = 0x0,         //PWMѡ:ǵ
  UART_TX1PS_T16N1Out0 = 0x1,  //PWMѡ:T16N1OUT0
  UART_TX1PS_T16N1Out1 = 0x2,  //PWMѡ:T16N1OUT1
  UART_TX1PS_BUZ = 0x3,        //PWMѡ:BUZҪ̶38K
} UART_TYPE_TX1PS;


/*Ʋܽ*/
typedef enum
{
  UART_TYPE_E0TX0 = 0,          //E0TX0ܽ
  UART_TYPE_T16N1OUT0 = 1,      //T16N1OUT0ܽ
  UART_TYPE_T16N1OUT1 = 2,      //T16N1OUT1ܽ
  UART_TYPE_TX1BUZ = 3,         //BUZܽ
} UART_TYPE_TX1Sx;

typedef enum
{
  UART_TYPE_TXD0 = 0,           //TXD0ܽ
  UART_TYPE_T16N0OUT0 = 1,      //T16N0OUT0ܽ
  UART_TYPE_T16N0OUT1 = 2,      //T16N0OUT1ܽ
  UART_TYPE_TX0BUZ = 3,         //BUZܽ
} UART_TYPE_TX0Sx;

/********************* GPIOģ麯 *********************/
void GPIO_Init(GPIO_Pin Pin, GPIO_InitSettingType *InitSet);
uint32_t GPIO_ReadBit(GPIO_Pin Pin);
void GPIO_WriteBit(GPIO_Pin Pin, uint32_t value);
void GPIO_SetBit(GPIO_Pin Pin);
void GPIO_ResetBit(GPIO_Pin Pin);
void GPIO_ToggleBit(GPIO_Pin Pin);
void PINT_Init(GPIO_Pin Pin, PINT_InitSettingType *InitSet);
void PINT_ClearITFlag(GPIO_Pin Pin);
uint32_t PINT_GetITFlag(GPIO_Pin Pin);
void KINT_Init(GPIO_Pin Pin, KINT_InitSettingType *InitSet);
void KINT_ClearITFlag(GPIO_Pin Pin);
uint32_t KINT_GetITFlag(GPIO_Pin Pin);
void GPIO_TX0Config(UART_TYPE_TXPLV Plv, UART_TYPE_TX0PS Ps, UART_TYPE_TX0Sx TX0Sx, TYPE_FUNCEN NewState);
void GPIO_TX1Config(UART_TYPE_TXPLV Plv, UART_TYPE_TX1PS Ps, UART_TYPE_TX1Sx TX1Sx, TYPE_FUNCEN NewState);

#endif
