/*******************************************************************************************************
*Copyright (C), 2016, Shanghai Eastsoft Microelectronics Co., Ltd   
*	ģ : ʼģ顣
*	ļ : init.c
*	     : V1.0
*	     
*	     2016\12\29             
*	޸ļ¼ :
*			      ˵
*
* ѧϰʾʹãûֱôķջеκηΡ
*******************************************************************************************************/
#include "includes.h"
/* 	˿			
	GPIO0			ISCK
	GPIO1			ISDA
	GPIO2			KEY0
	GPIO3			IIC_SDA
	GPIO4			IIC_SCL
	GPIO5			IIC_WP
	GPIO6			UART_RX
	GPIO7			UART_TX
	GPIO8			
	GPIO9			LED
	GPIO10			
	GPIO11			
*/
//ĬУ׼
const B16_B08 ADJ_DEFAULT[EE_PARAM_SUM] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/*
*********************************************************************************************************
*	  : WDT_Init
*	˵: emʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void WDT_Init(void)
{
	WDT->LOCK.Word = 0x1ACCE551;		//رд
	WDT->CON.CLKS = 1;					//WDTʱ 32K
	WDT->CON.RSTEN = 1;					//λʹ
	WDT->CON.EN = 1;					//WDTģʹ
	WDT->LOAD.Word = 0x00000FF;			//ʼֵ	
}
/*
*********************************************************************************************************
*	  : SCU_Init
*	˵: ʱӳʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void SCU_Init(void)
{
	SCU->PROT.Word = 0x55AA6996;		//رд
	/* ϵͳʱӳʼ */
	SCU->SCLKEN.Word = 0x0B;		
	/* ʱӳʼ */
	SCU->PCLKEN.Word = 0x110197;		//bit20:EMʱӡbit16:UART0bit8:T0 bit7:WDT bit2:IAP bit1:GPIO
}

/*
*********************************************************************************************************
*	  : LED_Init
*	˵: LEDʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void LED_Init(void)
{
	GPIO->MOD9.Word = 0x40;		
	GPIO->DIR.DIR_9 = 0;				//˿
	LED_On();
}
/*
*********************************************************************************************************
*	  : KEY_Init
*	˵: KEYʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void KEY_Init(void)
{
	GPIO->MOD2.Word = 0x04;
	GPIO->DIR.DIR_2 = 1;			//˿
}
/*
********************************************************************************************************
*	  : iic
*	˵: iic ʼ
*	    Σ
*	  ֵ: 
********************************************************************************************************
*/
void IIC_Init(void)
{
	/* WP --> GPIO5 */
	GPIO->MOD5.Word = 0x40;		
	GPIO->DIR.DIR_5 = 0;			//˿		
	
	GPIO->DATA.DATA_5 = 1;			//WP = 1	
	/* SDA --> GPIO3*/
	GPIO->MOD3.Word = 0x04;			
	GPIO->DIR.DIR_3 = 0;			//˿
	/* SCK --> GPIO4 */
	GPIO->MOD4.Word = 0x00;			
	GPIO->DIR.DIR_4 = 0;			//˿
	
	GPIO->DATA.DATA_5 = 0;			//WP = 0	
}
/*
*********************************************************************************************************
*	  : Timer0_Init
*	˵: T0ʼ,10msʱ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void Timer0_Init(void)
{
	T16N0->CON0.Word = 0x208; 		//MAT0
	T16N0->PREMAT.PREMAT = 0x03;	//4Ƶ
	T16N0->MAT0.Word = 49999;		//100hz	
	NVIC_EnableIRQ(T16N0INT_IRQn); //IRQʹ
	T16N0->CON0.EN = 1;				//T16N0ʹ
	T16N0->INT.MAT0IE = 1;			//T16N0ƥ0жʹ
}
/*
*********************************************************************************************************
*	  : Uart_Init
*	˵: uartʼ.UART0ʹܷʹܡUART_BAUD96001λֹͣλ8λλ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void Uart_Init(void)
{
	uint32_t temp;

	GPIO->MOD6.Word = 0x05;
	GPIO->DIR.DIR_6 = 1;			//˿
	GPIO->FLTEN.FLTEN_6 = 0;		//˿˲ֹ	

	GPIO->MOD7.Word = 0x01;
	GPIO->DIR.DIR_7 = 0;			//˿
	GPIO->FLTEN.FLTEN_7 = 0;		//˿˲ֹ

	temp = PCLK/(64*UART_BAUD) -1;	
	UART0->BRR.CLKS = 0;			//64Ƶ
	UART0->BRR.BRR = temp;			//buad = pclk/((BRR+1)*64)   
	UART0->CON.Word = 0xAF;			//UART0ʹܷʹܡ1λֹͣλ8λλżУ
	UART0->INT.RXIE = 1;			//жʹ
	UART0->INT.TXIE = 0;			//жʧ
	/* 4. USART1жʹ,NVIC,ʹUSART1 */ 
	NVIC_EnableIRQ(UART0TINT_IRQn); //IRQʹ
	NVIC_EnableIRQ(UART0RINT_IRQn); //IRQʹ	
}

/*
*********************************************************************************************************
*	  : EM_Init
*	˵: emʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void EM_Init(void)
{
	SCU->PCLKEN.Word |= 1<<20;		//EMʱʹ
	EM->PROT.Word = 0x78879669;		//رռñ
	//EMʼ	
/*	EM->AFEC.PGA1C = 0x05;			//PAG1 16
	EM->AFEC.PGA2C = 0x02;			//PAG2 2
	EM->AFEC.ADC1_EN = 1;			//ADC1 ʹ
	EM->AFEC.ADC2_EN = 1;			//ADC2 ʹ
	EM->AFEC.BGR_EN = 1;			//VREF ʹ
	EM->AFEC.CHOP1_PD = 0;			//chop1 clkʧ
	EM->AFEC.CHOP2_PD = 0;			//chop2 clkʧ
	EM->AFEC.HPF_EN = 1;			//HPF ˲ʹ*/
	EM->AFEC.Word = 0x11325; 		//ģǰ˿ƼĴ

/*	EM->START.EM_EN = 1;			//ʹ
	EM->START.RMS_EN = 1;			//Чֵ ʹ
	EM->START.CF_EN = 1;			// ʹ
	EM->START.EA_EN = 1;			//ֵ ʹ
	EM->START.APPF_EN = 1;			//ڹʲ ʹ
	EM->START.ZX_EN = 1;			// ʹ
	EM->START.FP_EN = 1;			//Ǻ͵ѹƵ ʹ
	EM->START.ERCLR = 1;			//Ĵ ʹ
	EM->START.CRC1_EN = 0;			//CRC1Уʧ
	EM->START.CRC2_EN = 0;			//CRC1Уʧ
	EM->START.CF1SEL = 0x02;		//CF1 ƽʱΪ Ϊ
	EM->START.CF1MOD = 0;			//йֵ
	EM->START.ZXSEL = 0x01;			//ź
	EM->START.POFF_MOD = 0;			//ʧģʽ ֹ */
	EM->START.Word = 0x1200FF;		

	EM->PFSET.Word = 0x00010000;	//Ƶ峣
	EM->PAGAIN.Word = 0;			//й
	EM->IAGAIN.Word = 0;			//Чֵ
	EM->UGAIN.Word = 0;				//ѹЧֵ
	EM->APHCAL.Word = 0;			//ǲֵ
	EM->PAOFF.Word = 0;				//ʧ
	EM->IAOFF.Word = 0;				//ʧ
	EM->UOFF.Word = 0;				//ѹʧ
	EM->PSTART.Word = 0;			//޼Ĵ
	
	GPIO->MOD10.Word = 0x01;
	GPIO->DIR.DIR_10 = 0;			//˿
	GPIO->FLTEN.FLTEN_6 = 0;		//˿˲ֹ	
}
/*
*********************************************************************************************************
*	  : GloableVar_Init
*	˵: EEPROMУ׼Ϊ0xFFΪоƬһϵ磬ĬֵEEPROMRAMС
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void GloableVar_Init(void)
{
	EM_GainPara_TypeDef *ptr;
	uint8_t adjust_first = 0;
	
	memset(ptr->U_Gain.B08, 0xFF, EE_PARAM_SUM*2);	
	EEP_ReadStr(EE_ADJ_BASEADDR, g_EM_GainPara.U_Gain.B08, EE_PARAM_SUM*2);
	adjust_first = memcmp(ptr->U_Gain.B08, g_EM_GainPara.U_Gain.B08,EE_PARAM_SUM*2);
	if (!adjust_first)	
	{
		//EEPROMΪ0xFF,һϵ
		memcpy(g_EM_GainPara.U_Gain.B08, ADJ_DEFAULT, EE_PARAM_SUM);
		EEP_WriteStr(EE_ADJ_BASEADDR, (uint8_t *)ADJ_DEFAULT[0].B08 ,EE_PARAM_SUM*2);	
		EEP_WriteStr(EE_ADJ_BASEADDR+EE_BACKUPS_OFFSET, (uint8_t *)ADJ_DEFAULT[0].B08 ,EE_PARAM_SUM*2);	
		
		//д0
		g_EP_Data.energy.B32 = 0;
		g_EP_Data.pulse = 0;
		EEP_WriteStr(EE_DI_ADDR, (uint8_t *)g_EP_Data.energy.B08 ,sizeof(g_EP_Data));	
	}
	else
	{
		//ǵһϵ磬ȡEEPZROMеĵ
		EEP_ReadStr(EE_DI_ADDR, (uint8_t*)g_EP_Data.energy.B08 , sizeof(g_EP_Data));		
	}
}
/*
*********************************************************************************************************
*	  : MCU_Init
*	˵: mcuʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void MCU_Init(void)
{
	SCU_Init();
//	WDT_Init();
	LED_Init();
	KEY_Init();
	IIC_Init();
	Timer0_Init();
	Uart_Init();
	EM_Init();
}
/*
*********************************************************************************************************
*	  : SYS_Init
*	˵: ϵͳʼ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void SYS_Init(void)
{
	GloableVar_Init();	
	EM_Config();
}
