/*******************************************************************************************************
*Copyright (C), 2016, Shanghai Eastsoft Microelectronics Co., Ltd   
*	ģ : ģ顣
*	ļ :common.c
*	     : V1.0
*	     
*	     2016\12\29             
*	޸ļ¼ :
*				汾	˵
*			
* ѧϰʾʹãûֱôķջеκηΡ
*******************************************************************************************************/
#include "includes.h"
/*
*********************************************************************************************************
*	  : HexToBcd
*	˵: HEXתΪBCD    
*	    : Ҫתֵ 
*	  ֵ: תֵ  
*********************************************************************************************************
*/
uint8_t HexToBcd( uint8_t value ) 
{
    return ( ((value/10) << 4) + (value % 10) );
}
/*
*********************************************************************************************************
*	  : BcdToHex
*	˵: BCDתΪHEX    
*	    : Ҫתֵ   
*	  ֵ: תֵ   
*********************************************************************************************************
*/
uint8_t BcdToHex( uint8_t value ) 
{
    return ( ((value&0xF0) >> 4) * 10 + (value & 0x0F) );
}
/*
*********************************************************************************************************
*	  : Hex2Bcd
*	˵: ֽHEXתΪBCD      
*	    : ҪתHEX      
*	  ֵ: 
*********************************************************************************************************
*/
void Hex2Bcd( uint8_t *Hexopt, uint8_t *BCDopt, uint8_t Len ) //ҪLenܴ8
{ 
    uint8_t ucA,ucB;
    B32_B08 TempHex;
  
    TempHex.B32 = 0;
    for (ucA=0; ucA<Len; ucA++)
    { 
        TempHex.B08[ucA] = Hexopt[ucA];
    }
    
    for (ucA=0; ucA<Len; ucA++)
    {
        ucB = TempHex.B32%100;
        BCDopt[ucA] = HexToBcd(ucB);
        TempHex.B32 = TempHex.B32/100;
    }   
}
/*
*********************************************************************************************************
*	  : Bcd2Hex
*	˵: ֽBCDתΪHEX      
*	    : ҪתBCD           
*	  ֵ: 
*********************************************************************************************************
*/
void Bcd2Hex( uint8_t *BCDopt, uint8_t *HEXopt, uint8_t Len ) 
{
    uint8_t ucA;
    unsigned long bai_n;
    B32_B08 TempHex;
   
    TempHex.B32 = 0;
    bai_n = 1;
    for (ucA=0; ucA<Len; ucA++)
    {
        TempHex.B32 += bai_n * ((BCDopt[ucA] >> 4 ) * 10 + (BCDopt[ucA] & 0x0F));
        bai_n *= 100;
    }
    for (ucA=0; ucA<Len; ucA++)
    { 
        HEXopt[ucA] = TempHex.B08[ucA];
    }
}

/*********************************************************
Hex2Bcd_4                 
  4ֽHEXתΪBCD
ֵҪתHEX
ֵ: BCD
ֵ                                        
*********************************************************/
void Hex2Bcd_4(uint8_t *HEXopt, uint8_t *BCDopt)
{
    Hex2Bcd( HEXopt, BCDopt, 4 );
}

/*********************************************************
Bcd2Hex_4                       
  4ֽBCDתΪHEX                  
ֵҪתBCD                                         
ֵ: HEX
ֵ                                        
*********************************************************/
void Bcd2Hex_4(uint8_t *BCDopt, uint8_t *HEXopt)
{
    Bcd2Hex( BCDopt, HEXopt, 4 );  
}

/*
*********************************************************************************************************
*	  : CheckOddEven
*	˵: жż
*	    :  ж
*	  ֵ: żλ
*********************************************************************************************************
*/
uint8_t CheckOddEven ( uint8_t Data )
{
    uint8_t i, j;
    j = 0;
    for ( i = 0; i < 8; i++ )
    {
        if ( Data & 0x01 )
        {
            j++;
        }
        Data = Data >> 1;
    }
    return ( j );
}
/*
*********************************************************************************************************
*	  : CheckOddEven
*	˵: ʱ1ms
*	    :  ʱʱ䡣λms
*	  ֵ: 
*********************************************************************************************************
*/
void DelayMs(uint16_t m)
{
	uint16_t i;
	
	while (m--)
	{
		for (i=0; i<1124; i++);
	}
} 
/*
*********************************************************************************************************
*	  : SumCheck
*	˵: У
*	    :  data Уָ num Уݸ
*	  ֵ: У
*********************************************************************************************************
*/
uint16_t SumCheck(uint8_t* data, uint8_t num)
{
	uint16_t check = 0;
	uint8_t	i;
	
	for (i=0; i<num; i++)
	{
		if (i%2)
			check += ((uint16_t)data[i] << 8);
		else
			check += data[i];
	}
	return check;
}
