/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tkm_config.c
*  :	Flynn Yin
*  :	V2.30
*  :	2018/10
*  :	ó
*  ע:    ESD-SFB-7P201
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "common.h"
#include "stdlib.h"
#include "string.h"
#include "main.h"
#include "tkm_config.h"

ulong pow(uchar i)
{
	return ((ulong)1<<i);
}

const uchar Channel_table[TK_NUM]=   // Channel table for use as tk channel
{
 #if TK_NUM >0
 TK_Channel0
 #endif
 #if TK_NUM >1
 ,TK_Channel1
 #endif
 #if TK_NUM >2
 ,TK_Channel2
 #endif
 #if TK_NUM >3
 ,TK_Channel3
 #endif
 #if TK_NUM >4
 ,TK_Channel4
 #endif
 #if TK_NUM >5
 ,TK_Channel5
 #endif
 #if TK_NUM >6
 ,TK_Channel6
 #endif
 #if TK_NUM >7
 ,TK_Channel7
 #endif
 #if TK_NUM >8
 ,TK_Channel8
 #endif
 #if TK_NUM >9
 ,TK_Channel9
 #endif
 #if TK_NUM >10
 ,TK_Channel10
 #endif
 #if TK_NUM >11
 ,TK_Channel11
 #endif
 #if TK_NUM >12
 ,TK_Channel12
 #endif
 #if TK_NUM >13
 ,TK_Channel13
 #endif
};

const uint Threshold_table[TK_NUM]=   // Threshold table for tk channel
{
 #if TK_NUM >0
 TK_Threshold_Channel0
 #endif
 #if TK_NUM >1
 ,TK_Threshold_Channel1
 #endif
 #if TK_NUM >2
 ,TK_Threshold_Channel2
 #endif
 #if TK_NUM >3
 ,TK_Threshold_Channel3
 #endif
 #if TK_NUM >4
 ,TK_Threshold_Channel4
 #endif
 #if TK_NUM >5
 ,TK_Threshold_Channel5
 #endif
 #if TK_NUM >6
 ,TK_Threshold_Channel6
 #endif
 #if TK_NUM >7
 ,TK_Threshold_Channel7
 #endif
 #if TK_NUM >8
 ,TK_Threshold_Channel8
 #endif
 #if TK_NUM >9
 ,TK_Threshold_Channel9
 #endif
 #if TK_NUM >10
 ,TK_Threshold_Channel10
 #endif
 #if TK_NUM >11
 ,TK_Threshold_Channel11
 #endif
 #if TK_NUM >12
 ,TK_Threshold_Channel12
 #endif
 #if TK_NUM >13
 ,TK_Threshold_Channel13
 #endif
};

#if (TK_UARToutput_function ==ON)||(TK_IICoutput_function ==ON)
uchar Cnt_Mask;
ulong ChannelMask;
uchar g_com;				//
uchar g_length;				//ݳ
uchar g_rp;					//ָ
uchar g_tp;					//ָ
uchar g_checksum;			//У
uchar Tx_timer;
uchar UploadSampByte[(TK_NUM*2)+5];	//ֽ
uchar UploadRawByte[(TK_NUM*2)+5];		//˲ֽ
uchar UploadBaseByte[(TK_NUM*2)+5];	//ֽ
uchar UploadBuf[(TK_NUM*2)+5];	        //ͻ
#endif

const uchar ChannelSum    = TK_NUM;	    //ʵʰֵ tkm_config.h޸
const uchar DF_TK_Singlepress   =TK_Singlepress;
uint  Opr_state;
/*
Bit15  Scan Enable bit   1 on 0 off
Bit14  Tempdata is full  1 full 0 receive
Bit13  Jillter sample enable bit  1 Enable     0  Disable
Bit12  Once scan complete bit     1 complete   0  busy
Bit11  Slider bit    1 Slider was be touch 0 not be touch
Bit10  Wheel  bit    1 Wheel  was be touch 0 not be touch
Bit9   Matrix Row bit     1   was be touch 0 not be touch
Bit8   Matrix Column bit  1   was be touch 0 not be touch
Bit7   Mode bit  0  Mode default  1  Mode2  
Bit6   Mode switch start switching  if 1 else 0       
Bit5   Powersave flag setting if 1 else 0
Bit4
Bit3
Bit2
Bit1
Bit0
*/

uint  TK_value;             //Temp value after scan
uchar TK_value_get;         //Temp value flag after scan
uint  Timer_counter;        //Timer counter
//uchar T8n_back;             
uchar Tkchnum;              //TK num
uchar Tkscan_numth;         //The active numth
uchar Tkscan_sampcounter;   //Sample counter  1--TK_Samples_perscan

TKValueStru TK_Value_Arr[TK_NUM];
uint  TK_jitter_Value;
uchar Lock_averageconter;
uchar TK_press_counter;
uchar TK_release_counter;
ulong TK_state;
ulong TK_state_single;
uint  TK_Base_percounter;
char  Timer_10ms;
uint  Mainloop_counter;
uchar TK_Jitter_tolerance[TK_NUM];  

/*********************************************************
:	void TKInit(void)
  :	ʼӳ
ֵ: 
**********************************************************/
void TKInit(void )
{
 uchar i;
 PBT |= 0x80;		// PB7 Must be Setinput

 VRC1  = TK_reg_VRC1;	//ʹADCVREF 2.6VVREF1=1.5V
 ACPC4 = TK_reg_ACPC4;	//ʹܱȽC4ڲVREF1

 TKMODL = (uchar)TK_Amplifi_setting;//÷ŴϵĴ24λ
 TKMODM = (uchar)(TK_Amplifi_setting>>8);
 TKMODH = (uchar)(TK_Amplifi_setting>>16);
 TKMODU = (uchar)(TK_Amplifi_setting>>24);//Ŵϵ4λ=0

 TKEN = 1;			    //ʹܴλ
 TKTUN =TK_reg_TKTUN;	//1ΣȽ˲ʱ8*ToscCxŵʱ32*ToscTKδΪ͵ƽ	
 Tkchnum =TK_NUM;
 Tkscan_numth =0;
 Tkscan_sampcounter=0;
 Opr_state=0x8000;      //Enable scan
 
 TKSEL = 0x40;           // 趨Ӧͨŵռձ1:2ɨƵfosc/4
 TK_state=0;
 TK_Base_percounter=0;

 TKValueStru * ptr = &TK_Value_Arr;
 i =0;
 for(; ptr < TK_Value_Arr + TK_NUM; ptr++)  //Clear all 
 {
	 memset(ptr, 0, sizeof(TKValueStru));
	 TK_Jitter_tolerance[i]=0; 
	 i++;
 }
  TK_value_get =0;
  Timer_10ms =0;
  Lock_averageconter =0;
}

void Tk_service(void)
{
	uchar i;
	uchar Lock_average=0;
	const uint *p;
	 if( Opr_state &0x4000)                // Data was full process it
	{          	

		#if  Max_Minvalueoff_filter ==ON  
						                            // Update the origin value  cut off the max and min value  
		uchar k;							
		uint Jitter =0;	                            // 			   
		for (k=0;k<TK_NUM;k++)
        {
			TK_Value_Arr[k].tk_value_origin -=TK_Value_Arr[k].tk_value_max;
			TK_Value_Arr[k].tk_value_origin -=TK_Value_Arr[k].tk_value_min;
			Jitter +=TK_Value_Arr[k].tk_value_max -TK_Value_Arr[k].tk_value_min;
		//TK_Value_Arr[k].tk_value_max=0;
		//TK_Value_Arr[k].tk_value_min=0;
		}
			TK_jitter_Value =Jitter;                     // Refresh  the jitter value
			if(Jitter >Jitter_level1_Threshold)
			{							 
			Lock_averageconter =68;
			}
		#endif

       TK_Base_percounter++;                 // Every come every ++  	  
		p =Threshold_table;		   
      for (i=0;i<Tkchnum;i++)
	  { 
		ulong pow_2 = pow(i);	       					
		TKValueStru * ptr = &TK_Value_Arr[i];
	   #if  (TK_UARToutput_function ==ON)||(TK_IICoutput_function ==ON)
                                             // Update the UART data        
		  UploadSampByte[2*i]     =(uchar)(ptr->tk_value_origin>>8);
		  UploadSampByte[(2*i)+1] =(uchar)(ptr->tk_value_origin);
		  UploadRawByte[2*i]      =(uchar)(ptr->tk_value_filter>>8);
		  UploadRawByte[(2*i)+1]  =(uchar)(ptr->tk_value_filter);
		  UploadBaseByte[2*i]     =(uchar)(ptr->tk_value_average>>8);
		  UploadBaseByte[(2*i)+1] =(uchar)(ptr->tk_value_average);		 
       #endif	
	     // Origin data   Update value data	 
		ptr->tk_value_filter =DataFilter(ptr->tk_value_origin,ptr->tk_value_filter);		 
		 if( ptr->tk_value_origin >( ptr->tk_value_average +p[i] ) )      		
		 {		   		                                                  
		   Lock_average =1;                                                                                 // This time not update average		 
		 }		
		 else 
		 {
		   Lock_average =0;
		   if(ptr->tk_press_table &&(ptr->tk_press_table < TK_Debounce_press))                              // No key press  but at press conter state  (TK_state &((ulong)1<<i))==0
		   {
		    TK_Jitter_tolerance[i]++;
			if(TK_Jitter_tolerance[i] >Jitter_tolerance)
			{
			 ptr->tk_press_table =0;                                                                       // Clear press counter
			 TK_Jitter_tolerance[i] =0;
			}
		   }
		   else 
		   {
		    TK_Jitter_tolerance[i] =0;
		   }

		 }
		/********************************************** Check Trigger *****************************************/	

		uchar Mucheck=1;
		if(Mult_inhibition( (ptr->tk_value_filter - ptr->tk_value_average), TK_Mult_inhibition))
		{
		  Mucheck =1;		
		}
		else    //Be inhibition
		{
		  Mucheck =0;
		  Lock_average =0;  // Go on average
		                    // Clear state
          if(TK_state &(pow_2)) 
		   {
			ptr->tk_release_table =TK_Debounce_release;
			TK_state &= ~pow_2;//~((ulong)1<<i);                    // Clear this trigger bit process	
			Customer_Keystatejustrelease();				   
			if(ptr->tk_timeout_counter!=0){ptr->tk_timeout_counter=0;}       // Close timer counter					  
			ptr->tk_D_value = 0;                                      // Save the Dlt value
		   }
		}

		if( (ptr->tk_value_filter > (ptr->tk_value_average+p[i]))&&Mucheck ) 			
		   {
			   ptr->tk_press_table++;			   
			   ptr->tk_release_table =0;			  
		    if( ptr->tk_press_table >TK_Debounce_press) 		
			 {
				    if(TK_jitter_Value < Jitter_level2_Threshold)
			         {
					     //if(Mult_inhibition( (ptr->tk_value_filter - ptr->tk_value_average), TK_Mult_inhibition) )
						     //{
							  ptr->tk_press_table = TK_Debounce_press;			 
							  TK_state |= pow_2;                                              // Set trigger process	
							  Customer_Keystatejustpress();
							  if(ptr->tk_timeout_counter==0){ptr->tk_timeout_counter=1;}			  			 
							  //#if  TK_Singlepress ==ON                                        // Save the Dlt value
							   ptr->tk_D_value= ptr->tk_value_filter - ptr->tk_value_average;   // Save the Dlt value
							  //#endif	
							 //}
					 }
					 else
					 {
					  ptr->tk_press_table =0;                                         // Clear 
					 }
			 }
		   }
		   else
		   {
			  if((TK_state &(pow_2))==0) { ptr->tk_press_table=0;}                   // Clear press counter					   	  

			   TK_Jitter_tolerance[i] =0;
			 if(TK_state &(pow_2))                        // Already press prepare to release check
			  {			     
				  if(ptr->tk_value_filter <( ptr->tk_value_average + ((p[i]*TK_Threshold_release)/10) ) )
				  {				
			        ptr->tk_release_table++;					
					if(ptr->tk_release_table >TK_Debounce_release)             // Release check
			          {
					   ptr->tk_release_table =TK_Debounce_release;
					   TK_state &= ~pow_2;//~((ulong)1<<i);                    // Clear this trigger bit process	
					   Customer_Keystatejustrelease();				   
					   if(ptr->tk_timeout_counter!=0){ptr->tk_timeout_counter=0;}       // Close timer counter
					   //#if  TK_Singlepress ==ON                                    // Save the Dlt value
                         ptr->tk_D_value = 0;                                      // Save the Dlt value
                       //#endif
					    ptr->tk_press_table=0;                             // Clear press counter
			          }				    
				  }
				  else
				  {
				   ptr->tk_release_table=0;                                           // Clear the release counter
				  }
			  }
			 else if((Lock_average==0)&&(TK_Base_percounter >TK_BaseSamples_perscan)&&(Lock_averageconter==0))
			  {
				 //Check if the number i was the Slider or Wheel area and the Slider or Wheel was touched then do not update the average 			    				 	
				  ptr->tk_value_average = DataFilter(ptr->tk_value_filter,ptr->tk_value_average);		//Use the filter data update the base line data	 	                       				 				 	                       
			  }
		   }
		/********************************************** Check Trigger *****************************************/
		 ptr->tk_value_origin =0;                                     // Clear the origin data  
		 //TK_value_origin[i] =0;                                     // Clear the origin data  
	  }	 

	  if(TK_Base_percounter >(TK_BaseSamples_perscan +0)){TK_Base_percounter =0;} // For next every  TK_BaseSamples_perscan  sample update
	  Opr_state &=~0x4000;                             // Release this state
	  //Single key press check 
	  #if  TK_Singlepress ==ON      
	        if(TK_state)                                                          // Any key pressed
			{                                     
             Singlekeyprocess();                                                  // Get Single key press state
			}
			else
			{
			 TK_state_single=0;
			}
      #endif
	   Opr_state |=0x8000;                              // Enable the scan enable bit		 	  		  
	}
  		    
}
void Timer_check(void)
{
  uchar i;
  if(Timer_10ms >Timercounter_10ms) //125 *80 10ms
	    {      
		 Timer_10ms =0;
		 
			#if TK_UARToutput_function ==ON
			if(Tx_timer)
			 {
			  Tx_timer++;
			  if( Tx_timer >125){ Tx_timer=0; g_tp = 0;}       //Tx send 1s timeout send Reset
			 }
			#endif

			Timer_counter++;
			if(Timer_counter >5)  //50ms time out re start check TK scan
			{		
			 Timer_counter=0;              // Measure time	
			 if( Opr_state &0x8000 )       // Scan Enable
			  {
				TKEN = 0;          // For TK module reset
				 PBT |= 0x80;		// PB7 Must be Setinput			
				 VRC1  = TK_reg_VRC1;	//ʹADCVREF 2.6VVREF1=1.4V
				 ACPC4 = TK_reg_ACPC4;	//ʹܱȽC4ڲVREF1

				 TKMODL = (uchar)TK_Amplifi_setting;//÷ŴϵĴ24λ
				 TKMODM = (uchar)(TK_Amplifi_setting>>8);
				 TKMODH = (uchar)(TK_Amplifi_setting>>16);
				 TKMODU = (uchar)(TK_Amplifi_setting>>24);//Ŵϵ4λ=0

				 TKEN = 1;			    //ʹܴλ
				 TKTUN =TK_reg_TKTUN;	//1ΣȽ˲ʱ8*ToscCxŵʱ32*ToscTKδΪ͵ƽ	

				TKGO = 0;			      //Ӧģر
				PB7 = 0;			      //Cxŵ
				PBT7 = 0;                 //Output0				 			 		  			   		                   	
				//TKScan();  
				PBT7 = 1;                 //When scan the PB7 must set input
				Config_TKIO2(Channel_table[Tkscan_numth]); 
				TKCTL = 0x03;                // ʹܴʹģ飬TKGO =1ɨ    
			  }                
			}
		   if(Lock_averageconter>2)
				{
				 Lock_averageconter--;
				 if(Lock_averageconter<5){Lock_averageconter=0;}		 
				}

			for (i=0;i<Tkchnum;i++)
			{
				uint * ptr = &(TK_Value_Arr[i].tk_timeout_counter);// &TK_timeout_counter[i];
				if (*ptr == 0)		  
			   {
				continue;
			   }
			  else
			   {
				   *ptr = *ptr + 1;		     
				 if (*ptr >= TK_Press_timeout)		    
				  {
				   *ptr = 0;			 
				   Force_average(i);                               // Do force average 			   
				  }
				}
			 }
		}
}

void Update_TKdata(void)
{
  if(TK_value_get)
	{
	  TK_value_get =0;
	   TK_Value_Arr[Tkscan_numth].tk_value_origin += TK_value;
		 #if  Max_Minvalueoff_filter ==ON  

		  if(Tkscan_sampcounter ==0)                 //First value
		  {
		   TK_Value_Arr[Tkscan_numth].tk_value_max =TK_value;
		   TK_Value_Arr[Tkscan_numth].tk_value_min =TK_value;
		  }
		  else if(TK_value >TK_Value_Arr[Tkscan_numth].tk_value_max)
		  {
		   TK_Value_Arr[Tkscan_numth].tk_value_max =TK_value;
		  }		  
		  else if(TK_value <TK_Value_Arr[Tkscan_numth].tk_value_min)
		  {
		   TK_Value_Arr[Tkscan_numth].tk_value_min =TK_value;
		  }
		 #endif
	  Tkscan_numth++;
	  if( Tkscan_numth >=TK_NUM )
		{
		Tkscan_numth=0;
		Tkscan_sampcounter++;
			if( Tkscan_sampcounter >=TK_Samples_perscan )
			{
			Tkscan_sampcounter =0;
			Opr_state |=0x4000;                           // Set data is full let Tk_service process 
			//if(Opr_state &0x0010){TKIE =0;}				  // if at get baseline state	Clear the TKIE  
			}
		}		
      TKScan();	                                                 // Scan the active channel		
	  if(Opr_state &0x4000){Opr_state &=~0x8000;}                // Clear the scan enable bit if data is full  wait data process  also have one data can be scan
	}
}

void Tk_getbaselinedata( void )
{
  uchar i;
  //             //Start scan
   TKGO = 0;			   //Ӧģر
   PB7 = 0;			       //Cxŵ
   PBT7 = 0;               //Output0
   Tkscan_numth =0;
   PBT7 = 1;                 //When scan the PB7 must set input	    
    Config_TKIO2(Channel_table[Tkscan_numth]);   
   Opr_state &=~0x4000;
   Opr_state |=0x0010;          // Set get baseline state
   TKCTL = 0x03;                // ʹܴʹģ飬TKGO =1ɨ	 
  while((Opr_state &0x4000)==0)  //Wait data is full
  {
   clr_wdt();
   Timer_check();        // Check if 10ms tick	 
  }
  
  for (i=0;i<Tkchnum;i++)
   {
    #if  Max_Minvalueoff_filter ==ON  
	TK_Value_Arr[i].tk_value_origin -=TK_Value_Arr[i].tk_value_max;
	TK_Value_Arr[i].tk_value_origin -=TK_Value_Arr[i].tk_value_min;
	#endif

    TKValueStru * ptr = &TK_Value_Arr[i];
    ptr->tk_value_filter =ptr->tk_value_origin;
    ptr->tk_value_average =ptr->tk_value_origin;
	ptr->tk_value_origin=0;

    //TK_value_filter[i]  =TK_value_origin[i];
    //TK_value_average[i] =TK_value_origin[i];
	//TK_value_origin[i]=0;
   }   
   Opr_state &=~0x4010;         // Clear again
   Opr_state |=0x8000;                              // Enable the scan enable bit
   TKIF =0;
   //TKIE =1;
}

void Tk_getbase_loop( void )
{
  uchar i;
  //             //Start scan
   TKGO = 0;			   //Ӧģر
   PB7 = 0;			       //Cxŵ
   PBT7 = 0;               //Output0
   Tkscan_numth =0;
   PBT7 = 1;                 //When scan the PB7 must set input	    
    Config_TKIO2(Channel_table[Tkscan_numth]);   
   Opr_state &=~0x4000;
   Opr_state |=0x0010;          // Set get baseline state
   TKCTL = 0x03;                // ʹܴʹģ飬TKGO =1ɨ	 
  while((Opr_state &0x4000)==0)  //Wait data is full
  {
   clr_wdt();
   Check_data();
   Timer_check();        // Check if 10ms tick	 
  }
  
  for (i=0;i<Tkchnum;i++)
   {
    #if  Max_Minvalueoff_filter ==ON  
	TK_Value_Arr[i].tk_value_origin -=TK_Value_Arr[i].tk_value_max;
	TK_Value_Arr[i].tk_value_origin -=TK_Value_Arr[i].tk_value_min;
	#endif

    TKValueStru * ptr = &TK_Value_Arr[i];
    ptr->tk_value_filter =ptr->tk_value_origin;
    ptr->tk_value_average =ptr->tk_value_origin;
	ptr->tk_value_origin=0;

    //TK_value_filter[i]  =TK_value_origin[i];
    //TK_value_average[i] =TK_value_origin[i];
	//TK_value_origin[i]=0;
   }   
   Opr_state &=~0x4010;         // Clear again
   Opr_state |=0x8000;                              // Enable the scan enable bit
   TKIF =0;
   //TKIE =1;
}

void Check_data( void )
{
  Mainloop_counter ++;
  if(Mainloop_counter >TK_counter_checkdata)
  {
    Mainloop_counter =0;
    if(Opr_state &0x8000)  // At scan enable state
		{
			if(TKIF) // Check if scan complete TKGO TKIF TKGO==0
			{				         				 
		      union {
				     uchar dl[2];
				     uint  data;
			        }tkdata;

					if (TKDAH||TKOV||TKERR||SCANOV)         // TKOV  TKERR SCANOV  Error
					 {
					  //tkdata.data = 0xFFFF;
					  //TK_value =0xFFFF;
					  //Wait the tk module reset
					  //FMQ_counter =1600;                  // 200ms FMQ any error for test 
				     } 
					else 
					{
					 tkdata.dl[0] = TKDAL;
					 tkdata.dl[1] = TKDAM;
					 TK_value =tkdata.data;
					 if(TK_value)
					 {
					  Timer_counter =0;              //Clear Measure time	for tk module
					  TK_value_get  =1;              //Set a flag for TK_value  update
		/********************************************** Update data start *****************************************************************************************/
					 // Update_TKdata();               //Update channel data
					  
						  
							  TK_value_get =0;
							   TK_Value_Arr[Tkscan_numth].tk_value_origin += TK_value;
								 #if  Max_Minvalueoff_filter ==ON  

								  if(Tkscan_sampcounter ==0)                 //First value
								  {
								   TK_Value_Arr[Tkscan_numth].tk_value_max =TK_value;
								   TK_Value_Arr[Tkscan_numth].tk_value_min =TK_value;
								  }
								  else if(TK_value >TK_Value_Arr[Tkscan_numth].tk_value_max)
								  {
								   TK_Value_Arr[Tkscan_numth].tk_value_max =TK_value;
								  }		  
								  else if(TK_value <TK_Value_Arr[Tkscan_numth].tk_value_min)
								  {
								   TK_Value_Arr[Tkscan_numth].tk_value_min =TK_value;
								  }
								 #endif
							  Tkscan_numth++;
							  if( Tkscan_numth >=TK_NUM )
								{
								Tkscan_numth=0;
								Tkscan_sampcounter++;
									if( Tkscan_sampcounter >=TK_Samples_perscan )
									{
									Tkscan_sampcounter =0;
									Opr_state |=0x4000;                           // Set data is full let Tk_service process 
									//if(Opr_state &0x0010){TKIE =0;}				  // if at get baseline state	Clear the TKIE  
									}
								}		
							  TKScan();	                                                 // Scan the active channel		
							  if(Opr_state &0x4000){Opr_state &=~0x8000;}                // Clear the scan enable bit if data is full  wait data process  also have one data can be scan
							
		/********************************************** Update data end  *****************************************************************************************/
					 }
					 
				    }
					TKIF = 0;          // ж		
					TKIE = 0; 		   
			}
		}
	Timer_10ms++;          // level2 counter
  }
}


