/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	int.c
*  :	Flynn Yin
*  :	V2.30
*  :	2018/10
*  :	ʾжϷ
*  ע:    HR7P201/202Ժݲɼ
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"
#include "stdlib.h"
//#include "tkm_config.h"
extern uint TK_value;

void it_vectors_init(void)
{
	INTVEN = 1;
	INTV0   = 0;
	INTV1   = 0;
	INTP    = 0x08;	     //IG3   TX RX ȼ
	GIEL    = 1;
}

#if  TK_Getdata_ISR  == ON
void Timerinit(void)
{                       
    T8NC = 0x01;		//T8NΪʱģʽ4Ƶ  8M/4= 2M  0.5us/Clock
    T8N = 6;			//趨ʱֵʱ125uS    250*0.5=125us
    T8NPRE = 1;			//ʹԤƵ  // 2 4 8 16 32 64 128 256
    T8NIE = 1;			//ʹT8Nʱж
    //GIE = 1;			//ʹȫж
    T8NEN = 1;			//T8NENʱ
}

void isr_t8N_handler(void) interrupt_low 0x0008
{
   uchar i;
 if (T8NIE && T8NIF)		//125us Timer
    {					    //T8Nʱж
        T8NIF = 0;		    //T8Nжϱ־
        T8N = T8N + 6;	    //T8NֵϽжʱ  T8N + 6;

		if(Opr_state &0x8000)  //At scan enable state
		{
			if(TKIF) // Check if scan complete TKGO TKIF TKGO==0
			{				         				 
		      union {
				     uchar dl[2];
				     uint  data;
			        }tkdata;

					if (TKDAH||TKOV||TKERR||SCANOV)         // TKOV  TKERR SCANOV  Error
					 {
					  //tkdata.data = 0xFFFF;
					  //TK_value =0xFFFF;
					  //Wait the tk module reset
					  //FMQ_counter =1600;                  // 200ms FMQ any error for test 
				     } 
					else 
					{
					 tkdata.dl[0] = TKDAL;
					 tkdata.dl[1] = TKDAM;
					 TK_value =tkdata.data;
					 if(TK_value)
					 {
					  Timer_counter =0;              //Clear Measure time	for tk module
					  TK_value_get  =1;              //Set a flag for TK_value  update
		/********************************************** Update data start *****************************************************************************************/
					 // Update_TKdata();               //Update channel data
					  
						  
							  TK_value_get =0;
							   TK_Value_Arr[Tkscan_numth].tk_value_origin += TK_value;
								 #if  Max_Minvalueoff_filter ==ON  

								  if(Tkscan_sampcounter ==0)                 //First value
								  {
								   TK_Value_Arr[Tkscan_numth].tk_value_max =TK_value;
								   TK_Value_Arr[Tkscan_numth].tk_value_min =TK_value;
								  }
								  else if(TK_value >TK_Value_Arr[Tkscan_numth].tk_value_max)
								  {
								   TK_Value_Arr[Tkscan_numth].tk_value_max =TK_value;
								  }		  
								  else if(TK_value <TK_Value_Arr[Tkscan_numth].tk_value_min)
								  {
								   TK_Value_Arr[Tkscan_numth].tk_value_min =TK_value;
								  }
								 #endif
							  Tkscan_numth++;
							  if( Tkscan_numth >=TK_NUM )
								{
								Tkscan_numth=0;
								Tkscan_sampcounter++;
									if( Tkscan_sampcounter >=TK_Samples_perscan )
									{
									Tkscan_sampcounter =0;
									Opr_state |=0x4000;                           // Set data is full let Tk_service process 
									//if(Opr_state &0x0010){TKIE =0;}				  // if at get baseline state	Clear the TKIE  
									}
								}		
							  TKScan();	                                                 // Scan the active channel		
							  if(Opr_state &0x4000){Opr_state &=~0x8000;}                // Clear the scan enable bit if data is full  wait data process  also have one data can be scan
							
		/********************************************** Update data end  *****************************************************************************************/
					 }
					 
				    }
					TKIF = 0;          // ж		
					TKIE = 0; 		   
			}
		}
		Timer_10ms++;
    }
}

void isr_i2c_tk_handler(void) interrupt_low 0x0020
{
	 uchar i;
 if(TKIE && TKIF)
    {     	 	  		
	  TKGO = 0;			 // Ӧģر
	  PB7  = 0;			 // Cxŵ
	  PBT7 = 0;          // Output0
	  TKIF = 0;          // ж		 	 		 	
    }

}
#endif

void isr_uartx_handler(void) interrupt_high 0x0014
{
   uchar i;
   uchar temp;
   #if TK_UARToutput_function ==ON
   if(RXIE && RXIF)			//UARTж	
    {  
    	g_com = RXB;		//UARTݼĴͬʱӲRXIF־  
		UploadBuf[0] = 0x68;
		UploadBuf[1] = 0x68;
		UploadBuf[2] = g_com;
		g_rp = 0;			 //ָ0
		Cnt_Mask = 0;
		g_checksum = 0;	 //У0
		if(g_tp ==0)         //Not in busy send state
		{
			if(g_com == COMMOND1)
			{				
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2];	//Уͣۼֵ
				while( Cnt_Mask < (TK_NUM*2))
				{
					if((0x00000001 << (Cnt_Mask/2)) & ChannelMask)
					{						
						UploadBuf[g_rp+4] = UploadSampByte[Cnt_Mask];
						
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						Cnt_Mask++;
					}
					else
					{
						Cnt_Mask++;
					}
				}
				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp+4] = g_checksum;
				TXB = UploadBuf[0];	//дͻ
				g_tp =1;
				TXIE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND2)
			{				
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
				while(Cnt_Mask < (TK_NUM*2))
				{
					if((0x00000001 << (Cnt_Mask/2)) & ChannelMask)
					{						
						UploadBuf[g_rp+4] = UploadRawByte[Cnt_Mask];						
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						Cnt_Mask++;
					}
					else
					{
						Cnt_Mask++;
					}
					
				}
				g_length =g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp+4] = g_checksum;
				TXB = UploadBuf[0];	//дͻ
				g_tp =1;
				TXIE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND3)
			{				
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
				while(Cnt_Mask < (TK_NUM*2))
				{
					if((0x00000001 << (Cnt_Mask/2)) & ChannelMask)
					{						
						UploadBuf[g_rp+4] = UploadBaseByte[Cnt_Mask];						
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						Cnt_Mask++;
					}
					else
					{
						Cnt_Mask++;
					}
				}
				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp+4] = g_checksum;
				TXB = UploadBuf[0];	//дͻ
				g_tp =1;
				TXIE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND4)  //ֵ
			{
				g_length = 9;
				UploadBuf[3] = 9;

				UploadBuf[4] = (uchar)(Opr_state);	     //Mode

			    #if  TK_Singlepress ==ON 
				UploadBuf[5] = (uchar)(TK_state_single>>16);    //ֵH
				UploadBuf[6] = (uchar)(TK_state_single>>8);	    //ֵM
				UploadBuf[7] = (uchar)(TK_state_single);		//ֵL
				#else
				UploadBuf[5] = (uchar)(TK_state>>16);    //ֵH
				UploadBuf[6] = (uchar)(TK_state>>8);	 //ֵM
				UploadBuf[7] = (uchar)(TK_state);		 //ֵL
				#endif

				#if  TK_Slider_Function ==ON  
				UploadBuf[8] = (uchar)(TK_slider_value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_slider_value);       //Byte L
				#else
				//UploadBuf[8] = 0;
				//UploadBuf[9] = 0;
				UploadBuf[8] = (uchar)(TK_jitter_Value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_jitter_Value);       //Byte L
				#endif

				#if  TK_Wheel_Function ==ON  
				UploadBuf[10] = (uchar)(TK_wheel_value>>8);    //Byte H
				UploadBuf[11] = (uchar)(TK_wheel_value);       //Byte L
				#else
				UploadBuf[10] = 0;
				UploadBuf[11] = 0;
				#endif

				#if  TK_Matrix_Function ==ON  
				UploadBuf[12] =TK_Matrix_value ;               //Byte 			
				#else			
				UploadBuf[12] = 0;                             //Byte
				#endif
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3] + UploadBuf[4] + UploadBuf[5];	//Уͣۼֵ
				g_checksum += UploadBuf[6] + UploadBuf[7] + UploadBuf[8] + UploadBuf[9] + UploadBuf[10] + UploadBuf[11]+ UploadBuf[12];	//Уͣۼֵ
				UploadBuf[13] = g_checksum;
				TXB = UploadBuf[0];	//дͻ
				g_tp =1;
				TXIE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND0)  //ͨ
			{
			    g_length     = 1;
				UploadBuf[3] = 1;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ				
				UploadBuf[4] =TK_NUM;
				g_checksum += UploadBuf[4];	                                                //Уͣۼֵ
				g_rp ++;								
				UploadBuf[g_rp+4] = g_checksum;
				TXB = UploadBuf[0];	    //дͻ
				g_tp =1;
				TXIE = 1;				//ʹTXж 
			}
			else
			{
				temp = ((g_com & 0xF0) >> 4 ) -6;
				ChannelMask &= ~(0x0000000F << (temp*4));
				ChannelMask |= ((g_com & 0x0F) << (temp*4));
			    g_length     = 0;
				UploadBuf[3] = 0;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ	
				g_rp ++;								
				UploadBuf[4] = g_checksum;
				TXB = UploadBuf[0];	    //дͻ
				g_tp =1;
				TXIE = 1;				//ʹTXж 
			}		
		}
		else
		{
			if(Tx_timer==0){Tx_timer =1;}
		}
    }	

	if(TXIE && TXIF)				//UARTж  
  	{	
		if(g_tp < g_length+5)
		{
			TXB = UploadBuf[g_tp];	//дͻ
			g_tp ++; 
		}
		else
		{
			g_tp = 0;				//ָ0
			TXIE = 0;				//ֹTXж 	
			Tx_timer=0;             //Clear counter
		}
    }
   #endif
}

/*********************************************************
:	void isr(void) interrupt
  :	ͳһжϷ  Ҫ INTVEN1 ΪDefault Mode
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
/*
void isr(void) interrupt
{
  if(RXIE && RXIF)			//UARTж	
    {}
  if(TXIE && TXIF)				//UARTж  
  	{}
  if (T8NIE && T8NIF)		//8ms Timer
    {}
  if(TKIE && TKIF)
    {}
}
*/


