/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tkm_config.h
*  :	Flynn Yin
*  :	V2.01
*  :	2017/11
*  :	ͷļ
*  ע:    HR7P201/202ԺӦ
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#ifndef   __TKM_CONFIG_H__
#define   __TKM_CONFIG_H__

#include <hic.h>
#include "common.h"
#include "main.h"

/*  */
/**********************************************************************************************************************************/
#define  TK_NUM    10              //ذ1--14/24

#define  TK_Channel0  TK21         //TK0--TK24  ظ ͬ
#define  TK_Channel1  TK23
#define  TK_Channel2  TK0

#define  TK_Channel3  TK7
#define  TK_Channel4  TK8
#define  TK_Channel5  TK9
#define  TK_Channel6  TK10
#define  TK_Channel7  TK11
#define  TK_Channel8  TK12
#define  TK_Channel9  TK13

#define  TK_Channel10  TK10
#define  TK_Channel11  TK11
#define  TK_Channel12  TK12
#define  TK_Channel13  TK13
#define  TK_Channel14  TK14
#define  TK_Channel15  TK15
#define  TK_Channel16  TK16
#define  TK_Channel17  TK17
#define  TK_Channel18  TK18
#define  TK_Channel19  TK19
#define  TK_Channel20  TK20
#define  TK_Channel21  TK21
#define  TK_Channel22  TK22
#define  TK_Channel23  TK23

#define  TK_Threshold_Channel0   150     //Ӿ 1--65535
#define  TK_Threshold_Channel1   150     //
#define  TK_Threshold_Channel2   150     //

#define  TK_Threshold_Channel3   100     //
#define  TK_Threshold_Channel4   100     //
#define  TK_Threshold_Channel5   100     //
#define  TK_Threshold_Channel6   100     //
#define  TK_Threshold_Channel7   100     //
#define  TK_Threshold_Channel8   100     //
#define  TK_Threshold_Channel9   100     //

#define  TK_Threshold_Channel10   100     //
#define  TK_Threshold_Channel11   100     //
#define  TK_Threshold_Channel12   100     //
#define  TK_Threshold_Channel13   100     //
#define  TK_Threshold_Channel14   100     //
#define  TK_Threshold_Channel15   100     //
#define  TK_Threshold_Channel16   100     //
#define  TK_Threshold_Channel17   100     //
#define  TK_Threshold_Channel18   100     //
#define  TK_Threshold_Channel19   100     //
#define  TK_Threshold_Channel20   100     //
#define  TK_Threshold_Channel21   100     //
#define  TK_Threshold_Channel22   100     //
#define  TK_Threshold_Channel23   100     //


#define  TK_Singlepress         OFF         //ON/OFF ͬһ̽һǿ ʵʰѹ3  OFF аͬʱ
#define  TK_Amplifi_setting     0x000FFFFF  //TK Ŵϵ趨  1--0x0FFFFFFF  0x0001FFFF
#define  TK_Samples_perscan     5        // ۼ趨1--16 16λ
#define  TK_Threshold_release   9        // 0.4-0.9 ɿ趨0.530ɿҪ15  5==50%
#define  TK_Samplevalue_step    30       // 趨1--65535 ֮һ
#define  TK_basevalue_step      5        // ߲趨  1--65535 ȲҪС
#define  TK_BaseSamples_perscan  64      // ߸ 趨1--65535
#define  TK_Press_timeout       (12*125) // 120s ʱǿȡ˰״̬ƽ 125--65535 
#define  TK_Debounce_press      3        // µĴ趨
#define  TK_Debounce_release    3        // 뿪Ĵ趨
                                         // ûаʱԶӦ

#define  TK_Jittersample         OFF     //  ON / OFF When on pls open the stdlib setting
#define  TK_Jitter_maxdelay      10      //  XX*32uS   1--30 this will cost scan time

//ι滮趨
#define  TK_MODE2       OFF            //   ON /OFF
#define  TKMODE2_NUM    1              //   ذ1--TK_NUM  ģʽ  0 Disable
                                       //   ڵ͹ĵӦʱ ʱģʽɨһͨԽʡ
#define  TKMODE2_Channel0  TK6         //   TK0--TK13  ظ ͬ
#define  TKMODE2_Channel1  TK13
#define  TKMODE2_Channel2  TK13

#define  TKMODE2_Channel3  TK3
#define  TKMODE2_Channel4  TK4
#define  TKMODE2_Channel5  TK5
#define  TKMODE2_Channel6  TK6
#define  TKMODE2_Channel7  TK7
#define  TKMODE2_Channel8  TK8
#define  TKMODE2_Channel9  TK9
#define  TKMODE2_Channel10  TK10
#define  TKMODE2_Channel11  TK11
#define  TKMODE2_Channel12  TK12
#define  TKMODE2_Channel13  TK13
#define  TKMODE2_Channel14  TK14
#define  TKMODE2_Channel15  TK15
#define  TKMODE2_Channel16  TK16
#define  TKMODE2_Channel17  TK17
#define  TKMODE2_Channel18  TK18
#define  TKMODE2_Channel19  TK19
#define  TKMODE2_Channel20  TK20
#define  TKMODE2_Channel21  TK21
#define  TKMODE2_Channel22  TK22
#define  TKMODE2_Channel23  TK23


#define  TKMODE2_Threshold_Channel0   70     //Ӿ 1--65535
#define  TKMODE2_Threshold_Channel1   160     //
#define  TKMODE2_Threshold_Channel2   160     //
#define  TKMODE2_Threshold_Channel3   160     //
#define  TKMODE2_Threshold_Channel4   160     //
#define  TKMODE2_Threshold_Channel5   160     //
#define  TKMODE2_Threshold_Channel6   30     //
#define  TKMODE2_Threshold_Channel7   30     //
#define  TKMODE2_Threshold_Channel8   30     //
#define  TKMODE2_Threshold_Channel9   30     //
#define  TKMODE2_Threshold_Channel10   30     //
#define  TKMODE2_Threshold_Channel11   30     //
#define  TKMODE2_Threshold_Channel12   30     //
#define  TKMODE2_Threshold_Channel13   30     //
#define  TKMODE2_Threshold_Channel14   30     //
#define  TKMODE2_Threshold_Channel15   30     //
#define  TKMODE2_Threshold_Channel16   30     //
#define  TKMODE2_Threshold_Channel17   30     //
#define  TKMODE2_Threshold_Channel18   30     //
#define  TKMODE2_Threshold_Channel19   30     //
#define  TKMODE2_Threshold_Channel20   30     //
#define  TKMODE2_Threshold_Channel21   30     //
#define  TKMODE2_Threshold_Channel22   30     //
#define  TKMODE2_Threshold_Channel23   30     //

#define  TK_Md2_Samples_perscan     3        // ۼ趨1--16 16λ
#define  TK_Md2_Threshold_release   9        // 0.4-0.9 ɿ趨0.530ɿҪ15  5==50%
#define  TK_Md2_Samplevalue_step    30       // 趨1--65535 ֮һ
#define  TK_Md2_basevalue_step      30       // ߲趨  1--65535 ȲҪС
#define  TK_Md2_BaseSamples_perscan 0        // ߸ 趨0--65535
#define  TK_Md2_Debounce_press      1        // µĴ趨
#define  TK_Md2_Debounce_release    1        // 뿪Ĵ趨
                                             

#define  TK_Matrix_Function  OFF            // ON  / OFF  󰴼֧
#define  TK_Matrix_Row_NUM   3             // 2--14

#define  TK_Matrix_Row0      TK_Ch0
#define  TK_Matrix_Row1      TK_Ch1
#define  TK_Matrix_Row2      TK_Ch2

#define  TK_Matrix_Row3      TK_Ch3
#define  TK_Matrix_Row4      TK_Ch4
#define  TK_Matrix_Row5      TK_Ch5
#define  TK_Matrix_Row6      TK_Ch6
#define  TK_Matrix_Row7      TK_Ch7
#define  TK_Matrix_Row8      TK_Ch8
#define  TK_Matrix_Row9      TK_Ch9
#define  TK_Matrix_Row10      TK_Ch10
#define  TK_Matrix_Row11      TK_Ch11
#define  TK_Matrix_Row12      TK_Ch12
#define  TK_Matrix_Row13      TK_Ch13
#define  TK_Matrix_Row14      TK_Ch14
#define  TK_Matrix_Row15      TK_Ch15
#define  TK_Matrix_Row16      TK_Ch16
#define  TK_Matrix_Row17      TK_Ch17
#define  TK_Matrix_Row18      TK_Ch18
#define  TK_Matrix_Row19      TK_Ch19
#define  TK_Matrix_Row20      TK_Ch20
#define  TK_Matrix_Row21      TK_Ch21
#define  TK_Matrix_Row22      TK_Ch22
#define  TK_Matrix_Row23      TK_Ch23




#define  TK_Matrix_Column_NUM   3             // 2--14

#define  TK_Matrix_Column0   TK_Ch3  
#define  TK_Matrix_Column1   TK_Ch4
#define  TK_Matrix_Column2   TK_Ch5

#define  TK_Matrix_Column3   TK_Ch3
#define  TK_Matrix_Column4   TK_Ch4
#define  TK_Matrix_Column5   TK_Ch5
#define  TK_Matrix_Column6   TK_Ch6
#define  TK_Matrix_Column7   TK_Ch7
#define  TK_Matrix_Column8   TK_Ch8
#define  TK_Matrix_Column9   TK_Ch9
#define  TK_Matrix_Column10   TK_Ch10
#define  TK_Matrix_Column11   TK_Ch11
#define  TK_Matrix_Column12   TK_Ch12
#define  TK_Matrix_Column13   TK_Ch13
#define  TK_Matrix_Column14   TK_Ch14
#define  TK_Matrix_Column15   TK_Ch15
#define  TK_Matrix_Column16   TK_Ch16
#define  TK_Matrix_Column17   TK_Ch17
#define  TK_Matrix_Column18   TK_Ch18
#define  TK_Matrix_Column19   TK_Ch19
#define  TK_Matrix_Column20   TK_Ch20
#define  TK_Matrix_Column21   TK_Ch21
#define  TK_Matrix_Column22   TK_Ch22
#define  TK_Matrix_Column23   TK_Ch23


//OutputValue = (Row th *Column NUM) + Column th +1  Only strong signal valued

//趨
#define  TK_Slider_Function   ON        // ON  / OFF ܿ
#define  TK_Slider_Levels     7          // 2--14   Sensor num ɼSensorɵSlider
#define  TK_Slider_poles_setting   32    // Value <= TK_Slider_poles_setting* (TK_Slider_Levels-1)

#define  TK_Slider_level0      TK_Ch3
#define  TK_Slider_level1      TK_Ch4
#define  TK_Slider_level2      TK_Ch5
#define  TK_Slider_level3      TK_Ch6
#define  TK_Slider_level4      TK_Ch7
#define  TK_Slider_level5      TK_Ch8
#define  TK_Slider_level6      TK_Ch9

#define  TK_Slider_level7      TK_Ch7
#define  TK_Slider_level8      TK_Ch8
#define  TK_Slider_level9      TK_Ch9
#define  TK_Slider_level10      TK_Ch10
#define  TK_Slider_level11      TK_Ch11
#define  TK_Slider_level12      TK_Ch12
#define  TK_Slider_level13      TK_Ch13
#define  TK_Slider_level14      TK_Ch14
#define  TK_Slider_level15      TK_Ch15
#define  TK_Slider_level16      TK_Ch16
#define  TK_Slider_level17      TK_Ch17
#define  TK_Slider_level18      TK_Ch18
#define  TK_Slider_level19      TK_Ch19
#define  TK_Slider_level20      TK_Ch20
#define  TK_Slider_level21      TK_Ch21
#define  TK_Slider_level22      TK_Ch22
#define  TK_Slider_level23      TK_Ch23


//趨
#define  TK_Wheel_Function   OFF           // ON  / OFF
#define  TK_Wheel_Levels     4             // 2--14   Sensor num
#define  TK_Wheel_poles_setting   32       // <=32* TK_Wheel_Levels

#define  TK_Wheel_level0      TK_Ch6
#define  TK_Wheel_level1      TK_Ch7
#define  TK_Wheel_level2      TK_Ch8
#define  TK_Wheel_level3      TK_Ch9

#define  TK_Wheel_level4      TK_Ch4
#define  TK_Wheel_level5      TK_Ch5
#define  TK_Wheel_level6      TK_Ch6
#define  TK_Wheel_level7      TK_Ch7
#define  TK_Wheel_level8      TK_Ch8
#define  TK_Wheel_level9      TK_Ch9
#define  TK_Wheel_level10      TK_Ch10
#define  TK_Wheel_level11      TK_Ch11
#define  TK_Wheel_level12      TK_Ch12
#define  TK_Wheel_level13      TK_Ch13
#define  TK_Wheel_level14      TK_Ch14 
#define  TK_Wheel_level15      TK_Ch15 
#define  TK_Wheel_level16      TK_Ch16 
#define  TK_Wheel_level17      TK_Ch17 
#define  TK_Wheel_level18      TK_Ch18 
#define  TK_Wheel_level19      TK_Ch19 
#define  TK_Wheel_level20      TK_Ch20 
#define  TK_Wheel_level21      TK_Ch21 
#define  TK_Wheel_level22      TK_Ch22 
#define  TK_Wheel_level23      TK_Ch23 

//TK_communicate.H	
//Ϊɨӿ趨ֱ֧IO UART   IICʽ

#define  TK_IOoutput_function    ON           // ON/ OFF
#define  TK_IOoutput_NUM         10            // 1--16

#define  TK_IOoutput_port0   PE2               // PA PB PC  Any bit
#define  TK_IOoutput_port1   PE4
#define  TK_IOoutput_port2   PA1

#define  TK_IOoutput_port3   PA2
#define  TK_IOoutput_port4   PE0
#define  TK_IOoutput_port5   PC0
#define  TK_IOoutput_port6   PC1
#define  TK_IOoutput_port7   PC4
#define  TK_IOoutput_port8   PC5
#define  TK_IOoutput_port9   PC6
#define  TK_IOoutput_port10   PC7

#define  TK_IOoutput_port11  PC7
#define  TK_IOoutput_port12  PC7
#define  TK_IOoutput_port13  PC7
#define  TK_IOoutput_port14  PC7
#define  TK_IOoutput_port15  PC7

#define  TK_IOoutput_trise0   PET2               // PA PB PC  TRISE bit
#define  TK_IOoutput_trise1   PET4
#define  TK_IOoutput_trise2   PAT1

#define  TK_IOoutput_trise3   PAT2
#define  TK_IOoutput_trise4   PET0
#define  TK_IOoutput_trise5   PCT0
#define  TK_IOoutput_trise6   PCT1
#define  TK_IOoutput_trise7   PCT4
#define  TK_IOoutput_trise8   PCT5
#define  TK_IOoutput_trise9   PCT6
#define  TK_IOoutput_trise10   PCT7

#define  TK_IOoutput_trise11   PCT7
#define  TK_IOoutput_trise12   PCT7
#define  TK_IOoutput_trise13   PCT7
#define  TK_IOoutput_trise14   PCT7
#define  TK_IOoutput_trise15   PCT7


#define  TK_IOLED_Function  Indicate          // Indicate/Toggle ɿ ǿشģʽ
#define  LED_On    0     //  0/1 
#define  LED_Off   1     //  0/1 

#define  TK_UARToutput_function    ON         // ON/ OFF
#define  TK_UARToutput_Baudrate    115200     // 115200  57600 38400 19200 .......9600
#define  TK_UARToutput_Databit      8         // 4,5,6,7,8
#define  TK_UARToutput_Stopbit      1         // 1,2,3(1.5)
#define  TK_UARToutput_Verifybit    No        //No Even Odd 

//TK_advance
#define  TK_reg_VRC1        0x03              //For VRC1  register  ʹADCVREF 2.6VVREF1=1.4V     80  0.6v     
#define  TK_reg_ACPC4       0x11              //For ACPC4 register  ʹܱȽC4ڲVREF1
#define  TK_reg_TKTUN       0x10              //For TKTUN register
#define  TK_reg_TKSEL       0x80              //趨Ӧͨŵռձ1:2ɨƵfosc/4

#define  TK_Guardsensor_output     OFF         // 
#define  TK_Guardsensor_setting    PB0        //ɨʱ߱ɨͨȣģʽΪͨ
#define  TK_GuardIOtrise_setting   PBT0

//When ON  if TK_Mode0_nokeytoswitch_time switch mode2 at mode2 every scan sleep TK_Wdttimer_sleepsetting time  any key press switch to mode1
#define  TK_Powersavemode_function     OFF      // ON/ OFF   When ON make sure you had opened the TK_MODE2 ON And WDT was opend on Config word
#define  TK_Wdttimer_sleepsetting      256     // mS  8/64/128/256/512/1024/2048 
#define  TK_Mode0_nokeytoswitch_time   10*125  // 10S  0--65535  Mode0 no key press time to switch Mode2  

//Following  For firmware support Do not change
#define  MCU_Type      202                    //  201 For 7p201;  202 for 7p202  MCU Default for 201 for MCU support

   #if  MCU_Type ==201
		#define  TK0        0   // PA0, PA1,  PA3,  PA4,  PA5,  PA6,  PA7,  PB0,   PB1,  PB2,  PB3,  PB4,  PB5,  PB6 
		#define  TK1        1   // PA1
		#define  TK2        2   // PA3
		#define  TK3        3   // PA4
		#define  TK4        4   // PA5
		#define  TK5        5   // PA6
		#define  TK6        6   // PA7
		#define  TK7        (0x80+7 )   // PB0
		#define  TK8        (0x80+8 )   // PB1
		#define  TK9        (0x80+9 )   // PB2
		#define  TK10       (0x80+10)   // PB3
		#define  TK11       (0x80+11)   // PB4
		#define  TK12       (0x80+12)   // PB5
		#define  TK13       (0x80+13)   // PB6
  #elif MCU_Type ==202
		#define  TK0        0   // PA0
		#define  TK1        1   // PA1
		#define  TK2        2   // PA2
		#define  TK3        3   // PA3
		#define  TK4        4   // PA5
		#define  TK5        5   // PA6
		#define  TK6        (0x80+6 )   // PB0
		#define  TK7        (0x80+7 )   // PB1
		#define  TK8        (0x80+8 )   // PB2
		#define  TK9        (0x80+9 )   // PB3
		#define  TK10       (0x80+10)   // PB4
		#define  TK11       (0x80+11)   // PB5
		#define  TK12       (0x80+12)   // PB6
		#define  TK13       (0x80+13)   // PB7
		#define  TK14       (0x40+14)   // PC0
		#define  TK15       (0x40+15)   // PC1
		#define  TK16       (0x40+16)   // PC2
		#define  TK17       (0x40+17)   // PC3
		#define  TK18       (0x40+18)   // PC4
		#define  TK19       (0x40+19)   // PC5
		#define  TK20       (0x20+20)   // PE0
		#define  TK21       (0x20+21)   // PE1
		#define  TK22       (0x20+22)   // PE2
		#define  TK23       (0x20+23)   // PE3
	#endif

	#define  TK_Ch0   0
	#define  TK_Ch1   1
	#define  TK_Ch2   2
	#define  TK_Ch3   3
	#define  TK_Ch4   4
	#define  TK_Ch5   5
	#define  TK_Ch6   6
	#define  TK_Ch7   7
	#define  TK_Ch8   8
	#define  TK_Ch9   9
	#define  TK_Ch10   10
	#define  TK_Ch11   11
	#define  TK_Ch12   12
	#define  TK_Ch13   13
	#define  TK_Ch14   14
	#define  TK_Ch15   15
	#define  TK_Ch16   16
	#define  TK_Ch17   17
	#define  TK_Ch18   18
	#define  TK_Ch19   19
	#define  TK_Ch20   20
	#define  TK_Ch21   21
	#define  TK_Ch22   22
	#define  TK_Ch23   23

#define SLAVE_ADDR  0x4E	//ӻַ
#define COMMOND4	0x50	//4ֵ
#define COMMOND0	0x51	//0ͨ
#define COMMOND1	0x5A	//1
#define COMMOND2	0x5B	//2˲
#define COMMOND3	0x5C	//3

extern const uchar Channel_table[];
extern const uint  Threshold_table[];
extern const uchar Channel_md2table[];
extern const uint  Threshold_md2table[];
extern const uchar Channel_MatrixRowtable[];
extern const uchar Channel_MatrixColumetable[];
extern const uchar Channel_Slidertable[];
extern const uchar Channel_Wheeltable[];
extern const uchar REG_PAT[];
extern const uchar ChannelSum;
extern const uchar ChannelSummd2;
extern const uchar DF_MCU_Type;
extern const uchar DF_TK_MODE2;
extern const uchar DF_TK_Matrix_Row_NUM;
extern const uchar DF_TK_Matrix_Column_NUM;
extern const uchar DF_TK_Slider_Levels;
extern const uchar DF_TK_Slider_poles_setting;
extern const uchar DF_TK_Wheel_Levels;
extern const uchar DF_TK_Wheel_poles_setting;
extern const uchar DF_TK_Jittersample;
extern const uchar DF_TK_Singlepress;

extern void  TKInit(void);	    //TKʼ
extern void  TKScan(void);		//TKɨ
extern void  TKRead(void);		//TKȡֵ
extern void Config_TKIO(uchar TK_Channelx );
extern void Config_TKIO2(uchar TK_Channelx );
extern void Tk_service(void);
extern void Tk_getbaselinedata(void);
extern void Singlekeyprocess(void);
extern void Matrix_process(void);
extern void Force_average(uchar num_th);
extern void TK_IO_output(void);
extern ulong CheckSliderID(uchar *p,uchar num);
//#if TK_Slider_Function ==ON
extern void Slider_process(void);
extern void Wheel_process(void);
extern void TK_Modeswitch(void);

//#endif
//#if TK_Powersavemode_function  ==ON
extern void Sleep_thenscan(void);
//#endif
extern void Update_filterdata(uchar j,uint TK_Samplevalue_stp );
extern void Update_averagedata(uchar j,uint TK_Samplevalue_stp );
/************************************************************************************************************************************/
#endif

