/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	keyint.c
*  :	XieYF
*  :	V1.50
*  :	2014/11/25
*  :	洢ʳ
*  ע:    HR7P195
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include	<hic.h>

//----------壬붨section2------------
section2 unsigned char 	flashErasePage;
section2 unsigned char 	flashWritePage,flashWriteAddr;
section2 unsigned char 	flashWriteDataH,flashWriteDataL;
section2 unsigned char	flashReadPage,flashReadAddr;
section2 unsigned char	flashReadDataH,flashReadDataL;
/*==================================================================
ҪΪ洢ʵFlashռĳʼ
趨page45FlashռΪд洢ʣÿpage128 Words趨ʵĴ洢ռΪ128BytesоƬÿWordsʹ15λҪ128 WordsĿռΪʵĴ洢ռ䡣
ȼʼַƫҳš12845128 = 5760(0x1680) CʹþԵַĳʽռFlash򣬱ʱռ䡣
ע⣺ʱʼַǰռһWordʼַΪַ+1Ӧ鳤Ϊ127
==================================================================*/
const unsigned char eepromData[127] @0xf01=
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x5A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};


/*==================================================================
RAM
==================================================================*/
void ram_clear(void)
{
	BKSR = (BKSR&0X0f)|0X00;   //BANK0
	for(IAA=0x020;IAA<=0x7f;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X00;   //BANK1
	for(IAA=0x0a0;IAA<=0xef;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X10;    //BANK2
	for(IAA=0x20;IAA<=0x6f;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X10;    //BANK3
	for(IAA=0xa0;IAA<=0xef;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X20;   //BANK4
	for(IAA=0x20;IAA<=0x6f;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X20;   //BANK5
	for(IAA=0xa0;IAA<=0xef;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X30;
	for(IAA=0x60;IAA<=0x6f;IAA++)
	{
		IAD = 0X00;
	}	
}
/*==================================================================
            				Flash
1ڣַҳflashErasePageΪ64ҳÿҳΪ128
2ڣ
==================================================================*/
void flashErase(void)
{
	__asm
	{
		SECTION	2					//ѡ洢2
		BCC		PSW,C
		RR		&flashErasePage&,0	//ȡҳҳ
		MOVA	FRAH				//ҳλFRAHĴ
		JBC		PSW,C
		GOTO	setErasePage
		BCC		FRAL,7				//ҳλFRALĴλ
		GOTO	eraseStart
setErasePage:
		BSS		FRAL,7
eraseStart:	
		BCC		INTC0,GIE_GIEH		//ȫжϣֹж
		BSS		ROMCL,MEWS			//ѡFlash
		BSS		ROMCL,MWEN			//ʹFlash
		BSS		ROMCL,MEN			//ʹFlash

		MOVI	0x55
		MOVA	ROMCH

		////滻8NOP
		MOV		FRAH,0				//ַЧ滻8nopָܶҲ
		XORI	0x0F			
		MOVI	0x0F			
		JBS		PSW,Z			
		MOVA	FRAH
		NOP
		NOP
		NOP	
		////8NOP滻
		MOVI	0xAA
		MOVA	ROMCH
		////滻8NOP
		MOV		FRAH,0				//ַЧ滻8nopָܶҲ
		XORI	0x0F			
		MOVI	0x0F			
		JBS		PSW,Z			
		MOVA	FRAH
		NOP
		NOP
		NOP
		////8NOP滻
		BSS		ROMCL,MTRG			//Flash
eraseWait:	
		JBC		ROMCL,MTRG			//ȴ
		GOTO	eraseWait
		BCC		ROMCL,MEN			//ֹFlash
		BCC		ROMCL,MWEN			//ֹFlash
		BSS		INTC0,GIE_GIEH		//¿ȫж
		SECTION	0					//ѡ洢0
	}
}
/*==================================================================
                        Flashд
1
	1дַҳflashWritePageΪ64ҳÿҳΪ128
	2дҳƫƵַflashWriteAddr
	3дݸֽڣflashWriteDataHǵ7bitЧ
	4дݵֽڣflashWriteDataL
2ڣ
==================================================================*/
void flashWrite(void)
{
	__asm
	{
		SECTION	2					//ѡ洢2
		MOV		&flashWriteDataH&,0
		MOVA	ROMDH
		MOV		&flashWriteDataL&,0
		MOVA	ROMDL

		BCC		&flashWriteAddr&,7
		BCC		PSW,C
		RR		&flashWritePage&,0	//Flash64ҳFRAH[4:0]FRAL[7]ѡ
		MOVA	FRAH
		JBS		PSW,C
		GOTO	setWriteAddr
setWritePage:
		BSS		&flashWriteAddr&,7
setWriteAddr:
		MOV		&flashWriteAddr&,0
		MOVA	FRAL
writeStart:
		BCC		INTC0,GIE_GIEH		//ȫжϣֹж
		BCC		ROMCL,MEWS			//ѡFlashд
		BSS		ROMCL,MWEN			//ʹFlashд
		BSS		ROMCL,MEN			//ʹFlash
		MOVI	0x55
		MOVA	ROMCH

		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		MOVI	0xAA
		MOVA	ROMCH	

		NOP							//ȴ8ָ
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP

		BSS		ROMCL,MTRG			//Flashд
writeWait:
		JBC		ROMCL,MTRG			//ȴд
		GOTO	writeWait
		BCC		ROMCL,MEN			//ֹFlash
		BCC		ROMCL,MWEN			//ֹFlashд
		BSS		INTC0,GIE_GIEH		//¿ȫж
		SECTION	0					//ѡ洢0
	}
}
/*==================================================================
                       Flash
1
	1ȡַҳflashReadPageΪ64ҳÿҳΪ128
	2ȡҳľλõַflashReadAddr
2ڣ
	1ݸֽڣflashReadDataHǵ7bitsЧ
	2ݵֽڣflashReadDataL
==================================================================*/
void flashRead(void)
{
	__asm
	{
		SECTION	2					//ѡ洢2
		BCC		&flashReadAddr&,7
		BCC		PSW,C
		RR		&flashReadPage&,0	//Flash64ҳFRAH[4:0]FRAL[7]ѡ
		MOVA	FRAH
		JBS		PSW,C
		GOTO	readStart
setReadPage:
		BSS		&flashReadAddr&,7
readStart:
		BCC		INTC0,GIE_GIEH		//ȫжϣֹж
		MOV		&flashReadAddr&,0
		MOVA	FRAL
		BSS		ROMCL,MEN			//ʹFlash
		BSS		ROMCL,MRTRG
		NOP
		NOP
readWait:
		JBC		ROMCL,MRTRG
		GOTO	readWait
		BSS		INTC0,GIE_GIEH
		MOV		ROMDH,0
		MOVA	&flashReadDataH&
		MOV		ROMDL,0
		MOVA	&flashReadDataL&		
		BCC		ROMCL,MEN			//ֹFlash
		BSS		INTC0,GIE_GIEH		//¿ȫж
		SECTION	0					//ѡ洢0
	}
}
/*==================================================================
								
==================================================================*/
void main(void)
{
	//----------ϵͳʱӳʼ------------
	OSCC = 0x50;			//ϵͳʱΪڲ4MHz
	//--------------I/Oʼ----------------
	ANSEL = 0xFF;			//ģ⸴ö˿ȫΪֿ
	ADCC1 = 0x0F;
	//----------Flashָҳ------------
	flashErasePage = 30;	//ѡҪFlash洢ҳ
	flashErase();			//Flash洢ӳ
	//----------Flashַָд------------
	flashWritePage = 30;	//ѡҪдFlash洢ҳ
	flashWriteAddr = 6;		//ҪдFlash洢ҳƫƵַ
	flashWriteDataH	= 0x5A;	//дݵĸ7 bitsֵ0x5A
	flashWriteDataL	= 0xA6;	//дݵĵ8 bitsֵ0xA6
	flashWrite();			//Flash洢дӳ
	//----------Flashַָ------------
	flashReadPage = 30;		//ѡҪȡFlash洢ҳ
	flashReadAddr = 6;		//趨ҪȡFlash洢ҳƫƵַ
	flashRead();			//Flash洢ӳ
	__Asm	NOP;
	while(1);
}
