/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	eeprom.c
*  :	XieYF
*  :	V1.20
*  :	2017/6/20
*  :	EEPROMд
*  ע:    HR7P154-SSOP10/SOP14ѡװ
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include "ramdefine.h"
#define Delay_10nop() {__Asm nop;__Asm nop;__Asm nop;__Asm nop;__Asm nop;__Asm nop;__Asm nop;__Asm nop;__Asm nop;__Asm nop;}


void Ram_Clr(void) //ramȫ
{
	__asm 
  { 
	CLR   IAAL;
	CLR   IAAH;
	CLR   IAD;
	INC   IAAL,1;
	JBS   IAAL,6;
	GOTO  $-3;
  } 
}
void main() 
{
	Ram_Clr();
    OSCP = 0x55;		//ʱӿд
	OSCC = 0xF0;	    //лʱӣ16MHz
    while (!SW_HS);	    //ȴʱл

	ANS = 0x3F;			//еģ趨ΪIO
	NPUSDA = 0;			//ʹSDA
	TRSCK = 0;
	TRSDA = 0;
	#ifdef HR7P154E4RB
	WP = 0;
	TRSWP = 0;
	VDD = 1;
	TRSVD = 0;
	#endif

	TIME_Delay(0xFF); 
	readdata = 0;

    while(1)
    {	  
		readdata = 0;
		for(i=1;i<=0x80;i++)
		{
			f_EEPWrite24C02A(i,i);        //趨I2C(24C02)ַд
			TIME_Delay(2000);             //ʱ2.3 
			readdata = f_EEPRead24C02A(i);  //I2Cֵַ
			if(readdata!=i){
				__Asm NOP;
			}
			__Asm NOP;
		}
	}
}

/*********************************************************
:	void f_EEPWrite24C02A(uchar i_WriteAddress,uchar i_WriteData)
  :	ַָд 
ֵ: i_WriteAddressдַ
		i_WriteDataд 
ֵ: 
ֵ:  
**********************************************************/                                                                          
void f_EEPWrite24C02A(uchar i_WriteAddress,uchar i_WriteData)
{
    f_EEPStart();                                        //IIC
    f_WriteByte(0xA0);                                   //д       
	f_WriteByte(i_WriteAddress);                         //дݵַ
	f_WriteByte(i_WriteData);							 //д
    f_EEPStop();                                         //ֹͣIIC
}	

/*********************************************************
:	uchar f_EEPRead24C02A(uchar i_ReadAddress)
  :	ַָ 
ֵ: i_ReadAddressַ
		i_WriteDataд 
ֵ: 
ֵ: ucGetCharȡ
**********************************************************/    
uchar f_EEPRead24C02A(uchar i_ReadAddress)
{
    uchar ucGetChar;
    f_EEPStart();                                        //IIC
    f_WriteByte(0xA0);                                   //д
    f_WriteByte(i_ReadAddress);                          //дݵĵַ
    f_EEPStart();                                        //IIC
    f_WriteByte(0xA1);                                   //
    ucGetChar = f_ReadByte();                            //Ӧֵַ																			
    f_EEPStop();                                         //ֹͣIIC
    return ucGetChar;
}                                                                         

 /*********************************************************
:	void f_EEPStart(void) 
  :	I2CMӳ 
ֵ: 
ֵ: 
ֵ: 
**********************************************************/ 
void f_EEPStart(void)
{
	TRSDA = 0;
    SDA = 1; 
    Delay_10nop(); 
    SCK = 1;
    Delay_10nop(); 
    SDA = 0;	
    Delay_10nop();
    SCK = 0;
    Delay_10nop();    
}

 /*********************************************************
:	void f_EEPStop(void) 
  :	I2CMֹͣӳ 
ֵ: 
ֵ: 
ֵ: 
**********************************************************/ 
void f_EEPStop(void)
{
	TRSDA = 0;
    SCK = 0;
    Delay_10nop();
    SDA = 0;
    Delay_10nop();
    SCK = 1;
    Delay_10nop();
    SDA = 1;
    Delay_10nop();
}

/*********************************************************
:	uchar f_ReadByte(void)
  :	I2CMֽʱ
ֵ: 
ֵ: 
ֵ: յֽ 
**********************************************************/
uchar f_ReadByte(void)
{
    uchar i,nValue;
	nValue = 0;
    TRSDA = 1;
    for (i = 0; i < 8; i++)
    {
        SCK = 1;                            //ʱΪ
        nValue = (nValue<<1)|SDA;           //ͨλƳ
        Delay_10nop();                      //ʱ5us  
        SCK = 0;                            //ʱΪ
        Delay_10nop();                      //ʱ5us
    }
    SDA = 1;                                //,ӦλΪ1
    Delay_10nop();                          //ʱ5us
    SCK = 1;                                //ʱΪ
    Delay_10nop();                          //ʱ5us
    SCK = 0;                                //ʱΪ
    return nValue;                                             
}

/*********************************************************
:	uchar f_WriteByte(void)  
  :	I2CMдֽʱ
ֵ: i_WriteDataֽ
ֵ: 
ֵ: 0TRUE
		1FALSE 
**********************************************************/
uchar f_WriteByte(uchar i_WriteData)
{
    uchar i;  
	Delay_10nop();
    TRSDA = 0;   
	SDA = 0;     
	
    for(i = 0; i < 8; i++)                 //ͨλд24C02
    { 
        SCK = 0;                           //ʱΪ             
        Delay_10nop();                     //ʱ5us  	
        if(i_WriteData & 0b10000000)                        
            SDA = 1;                       //λ1
        else
            SDA = 0;                       //λ0 
        Delay_10nop();                     //ʱ5us   
        SCK = 1;                           //ʱø
        Delay_10nop();                     //ʱ5us
        SCK = 0;                           //ʱ
        i_WriteData <<= 1;                 //дһλ
    }

    TRSDA = 1; 
    Delay_10nop();                         //ʱ5us
    SDA = 1;                               //
    Delay_10nop();                         //ʱ5us 
    SCK = 1;                               //ʱΪߵƽ
    Delay_10nop();	                       //ʱ5us  

    while(SDA)                             //ӦλǷȷ
    {        
        SCK = 0;                           //ӦȷʱΪ͵ƽ
        return 0;						   //0
	}                                  

    SCK = 0;                               //Ӧȷ,ʱΪ͵ƽ
    return 1;                              //1			
}	

/*********************************************************
:	void TIME_Delay(uint i_LoopCount)
  :	ʱӳ
ֵ: i_LoopCountʱ 
ֵ: 
ֵ:  
**********************************************************/
void TIME_Delay(uint i_LoopCount)
{
	uint i;                            //һʱõѭ
	for(i = i_LoopCount; i > 0; i--)	//Լʱ
	{
		;    
	}                                                             
    return;
}